/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.core.mythic.utils.MythicCondition;
import com.ticxo.modelengine.core.mythic.utils.MythicMechanic;
import com.ticxo.modelengine.core.mythic.utils.MythicTargeter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.targeters.ISkillTargeter;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class ModelEngineComponentRegistry
implements Listener {
    private final Map<String, Constructor<? extends ISkillMechanic>> mechanics = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillCondition>> conditions = Maps.newConcurrentMap();
    private final Map<String, Constructor<? extends ISkillTargeter>> targeters = Maps.newConcurrentMap();

    public ModelEngineComponentRegistry(JavaPlugin plugin, String packagePath) {
        this(plugin, Lists.newArrayList((Object[])new String[]{packagePath}));
    }

    public ModelEngineComponentRegistry(JavaPlugin plugin, Collection<String> packages) {
        for (String packagePath : packages) {
            Object clazz2;
            Collection mechanicsClasses = AnnotationUtil.getAnnotatedClasses((JavaPlugin)plugin, (String)packagePath, MythicMechanic.class);
            for (Object clazz2 : mechanicsClasses) {
                try {
                    Constructor constructor;
                    MythicMechanic annotation = ((Class)clazz2).getAnnotation(MythicMechanic.class);
                    String namespace = annotation.namespace();
                    String name = annotation.name();
                    String[] aliases = annotation.aliases();
                    if (!ISkillMechanic.class.isAssignableFrom((Class<?>)clazz2)) continue;
                    try {
                        constructor = ((Class)clazz2).getConstructor(MythicLineConfig.class);
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            constructor = ((Class)clazz2).getConstructor(MythicMechanicLoadEvent.class);
                        }
                        catch (NoSuchMethodException ex2) {
                            constructor = ((Class)clazz2).getConstructor(new Class[0]);
                        }
                    }
                    this.mechanics.put(name.toUpperCase(), constructor);
                    this.mechanics.put(namespace.toUpperCase() + ":" + name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.mechanics.put(alias.toUpperCase(), constructor);
                        this.mechanics.put(namespace + ":" + alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error((String)"Failed to register custom mechanic {0}", (Object[])new Object[]{((Class)clazz2).getCanonicalName()});
                    ex.printStackTrace();
                }
            }
            Collection conditionClasses = AnnotationUtil.getAnnotatedClasses((JavaPlugin)plugin, (String)packagePath, MythicCondition.class);
            clazz2 = conditionClasses.iterator();
            while (clazz2.hasNext()) {
                Class clazz3 = (Class)clazz2.next();
                try {
                    Constructor constructor;
                    MythicCondition annotation = clazz3.getAnnotation(MythicCondition.class);
                    String namespace = annotation.namespace();
                    String name = annotation.name();
                    String[] aliases = annotation.aliases();
                    if (!ISkillCondition.class.isAssignableFrom(clazz3)) continue;
                    try {
                        constructor = clazz3.getConstructor(MythicLineConfig.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz3.getConstructor(new Class[0]);
                    }
                    this.conditions.put(name.toUpperCase(), constructor);
                    this.conditions.put(namespace.toUpperCase() + ":" + name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.conditions.put(alias.toUpperCase(), constructor);
                        this.conditions.put(namespace + ":" + alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error((String)"Failed to register custom condition {0}", (Object[])new Object[]{clazz3.getCanonicalName()});
                    ex.printStackTrace();
                }
            }
            Collection targeterClasses = AnnotationUtil.getAnnotatedClasses((JavaPlugin)plugin, (String)packagePath, MythicTargeter.class);
            for (Class clazz4 : targeterClasses) {
                try {
                    Constructor constructor;
                    MythicTargeter annotation = clazz4.getAnnotation(MythicTargeter.class);
                    String namespace = annotation.namespace();
                    String name = annotation.name();
                    String[] aliases = annotation.aliases();
                    if (!ISkillTargeter.class.isAssignableFrom(clazz4)) continue;
                    try {
                        constructor = clazz4.getConstructor(MythicLineConfig.class);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = clazz4.getConstructor(new Class[0]);
                    }
                    this.targeters.put(name.toUpperCase(), constructor);
                    this.targeters.put(namespace.toUpperCase() + ":" + name.toUpperCase(), constructor);
                    for (String alias : aliases) {
                        this.targeters.put(alias.toUpperCase(), constructor);
                        this.targeters.put(namespace + ":" + alias.toUpperCase(), constructor);
                    }
                }
                catch (Throwable ex) {
                    MythicLogger.error((String)"Failed to register custom targeter {0}", (Object[])new Object[]{clazz4.getCanonicalName()});
                    ex.printStackTrace();
                }
            }
        }
    }

    @EventHandler
    public void onMythicMechanicLoad(MythicMechanicLoadEvent event) {
        String name = event.getMechanicName().toUpperCase();
        if (this.mechanics.containsKey(name)) {
            Constructor<? extends ISkillMechanic> constructor = this.mechanics.get(name);
            try {
                if (constructor.getParameterCount() == 1) {
                    if (constructor.getParameterTypes()[0] == MythicLineConfig.class) {
                        event.register(constructor.newInstance(event.getConfig()));
                    } else {
                        event.register(constructor.newInstance(event));
                    }
                } else {
                    event.register(constructor.newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                MythicLogger.error((String)"Failed to construct mechanic {0}", (Object[])new Object[]{name});
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onMythicConditionLoad(MythicConditionLoadEvent event) {
        String name = event.getConditionName().toUpperCase();
        if (this.conditions.containsKey(name)) {
            Constructor<? extends ISkillCondition> constructor = this.conditions.get(name);
            try {
                if (constructor.getParameterCount() == 1) {
                    event.register(constructor.newInstance(event.getConfig()));
                } else {
                    event.register(constructor.newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                MythicLogger.error((String)"Failed to construct condition {0}", (Object[])new Object[]{name});
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onMythicTargeterLoad(MythicTargeterLoadEvent event) {
        String name = event.getTargeterName().toUpperCase();
        if (this.targeters.containsKey(name)) {
            Constructor<? extends ISkillTargeter> constructor = this.targeters.get(name);
            try {
                if (constructor.getParameterCount() == 1) {
                    event.register(constructor.newInstance(event.getConfig()));
                } else {
                    event.register(constructor.newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                MythicLogger.error((String)"Failed to construct targeter {0}", (Object[])new Object[]{name});
                e.printStackTrace();
            }
        }
    }
}

