/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_19_R3.entity;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.nms.entity.wrapper.TrackedEntity;
import com.ticxo.modelengine.api.utils.ReflectionUtils;
import com.ticxo.modelengine.v1_19_R3.NMSFields;
import com.ticxo.modelengine.v1_19_R3.NMSMethods;
import com.ticxo.modelengine.v1_19_R3.network.utils.NetworkUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.ServerPlayerConnection;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TrackedEntityImpl
implements TrackedEntity {
    private final Entity entity;
    private final Supplier<PlayerChunkMap.EntityTracker> trackedEntitySupplier;
    private final Set<Player> forcedPairing = Sets.newConcurrentHashSet();
    private final Set<Player> forcedRemove = Sets.newConcurrentHashSet();
    private Predicate<Player> playerPredicate = DEFAULT_PREDICATE;
    @NotNull
    private PlayerChunkMap.EntityTracker lastTrackedEntity;

    public TrackedEntityImpl(Entity entity, Supplier<PlayerChunkMap.EntityTracker> trackedEntitySupplier, @NotNull PlayerChunkMap.EntityTracker lastTrackedEntity) {
        this.entity = entity;
        this.trackedEntitySupplier = trackedEntitySupplier;
        this.lastTrackedEntity = lastTrackedEntity;
    }

    @Override
    public int getBaseRange() {
        Integer range = (Integer)ReflectionUtils.get(this.getTrackedEntity(), NMSFields.TRACKED_ENTITY_range);
        if (range == null) {
            throw new NullPointerException(String.format("Unable to retrieve base range of entity with UUID %s.", this.entity.getUniqueId()));
        }
        return range;
    }

    @Override
    public void setBaseRange(int range) {
        ReflectionUtils.set(this.getTrackedEntity(), NMSFields.TRACKED_ENTITY_range, range);
    }

    @Override
    public int getEffectiveRange() {
        Integer range = (Integer)ReflectionUtils.call(this.getTrackedEntity(), NMSMethods.TRACKED_ENTITY_getEffectiveRange, new Object[0]);
        if (range == null) {
            throw new NullPointerException(String.format("Unable to retrieve range of entity with UUID %s.", this.entity.getUniqueId()));
        }
        return range;
    }

    @Override
    public Set<Player> getTrackedPlayer() {
        HashSet<Player> set = new HashSet<Player>(this.forcedPairing);
        for (ServerPlayerConnection connection : this.getTrackedEntity().f) {
            Player player = connection.f().getBukkitEntity().getPlayer();
            if (!this.playerPredicate.test(player) || this.forcedRemove.contains(player)) continue;
            set.add(player);
        }
        return set;
    }

    @Override
    public Set<Player> getTrackedPlayer(Predicate<Player> predicate) {
        HashSet<Player> set = new HashSet<Player>(this.forcedPairing);
        for (ServerPlayerConnection connection : this.getTrackedEntity().f) {
            Player player = connection.f().getBukkitEntity().getPlayer();
            if (!predicate.test(player) || !this.playerPredicate.test(player) || this.forcedRemove.contains(player)) continue;
            set.add(player);
        }
        return set;
    }

    @Override
    public void sendPairingData(Player player) {
        EntityPlayer nms = ((CraftPlayer)player).getHandle();
        this.getTrackedEntity().b.sendPairingData(packet -> NetworkUtils.send(player, (Packet<PacketListenerPlayOut>)packet), nms);
    }

    @Override
    public void broadcastSpawn() {
        for (Player player : this.getTrackedPlayer()) {
            this.sendPairingData(player);
        }
    }

    @Override
    public void broadcastRemove() {
        this.getTrackedEntity().a();
    }

    @Override
    public void addForcedPairing(Player player) {
        this.forcedPairing.add(player);
        this.removeForcedHidden(player);
    }

    @Override
    public void removeForcedPairing(Player player) {
        this.forcedPairing.remove(player);
    }

    @Override
    public void addForcedHidden(Player player) {
        this.forcedRemove.add(player);
        this.removeForcedPairing(player);
    }

    @Override
    public void removeForcedHidden(Player player) {
        this.forcedRemove.remove(player);
    }

    @NotNull
    private PlayerChunkMap.EntityTracker getTrackedEntity() {
        PlayerChunkMap.EntityTracker trackedEntity = this.trackedEntitySupplier.get();
        if (trackedEntity != null && this.lastTrackedEntity != trackedEntity) {
            this.syncInstance(trackedEntity);
            this.lastTrackedEntity = trackedEntity;
        }
        return this.lastTrackedEntity;
    }

    private void syncInstance(PlayerChunkMap.EntityTracker target) {
        Integer range = (Integer)ReflectionUtils.get(this.lastTrackedEntity, NMSFields.TRACKED_ENTITY_range);
        if (range != null) {
            ReflectionUtils.set(target, NMSFields.TRACKED_ENTITY_range, range);
        }
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public Predicate<Player> getPlayerPredicate() {
        return this.playerPredicate;
    }

    @Override
    public void setPlayerPredicate(Predicate<Player> playerPredicate) {
        this.playerPredicate = playerPredicate;
    }
}

