/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_20_R1.network;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.nms.network.NetworkHandler;
import com.ticxo.modelengine.api.utils.ReflectionUtils;
import com.ticxo.modelengine.v1_20_R1.NMSFields;
import com.ticxo.modelengine.v1_20_R1.network.ModelEngineChannelHandler;
import com.ticxo.modelengine.v1_20_R1.network.utils.Bundler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NetworkHandlerImpl
implements NetworkHandler {
    public static NetworkHandlerImpl instance;
    private final Map<UUID, ChannelPipeline> pipelines = Maps.newConcurrentMap();
    private final Map<UUID, Bundler> bundles = Maps.newConcurrentMap();
    private boolean isBatching;

    public NetworkHandlerImpl() {
        if (instance != null) {
            throw new IllegalStateException("Network handler already initialized");
        }
        instance = this;
    }

    @Override
    public int getProtocolVersion() {
        return SharedConstants.c();
    }

    @Override
    public Optional<ChannelPipeline> getPipeline(Player player) {
        return Optional.ofNullable(this.pipelines.get(player.getUniqueId()));
    }

    @Override
    public void removePipeline(Player player) {
        this.pipelines.remove(player.getUniqueId());
    }

    @Override
    public void injectChannel(Player player) {
        ModelEngineChannelHandler handler = new ModelEngineChannelHandler(player);
        PlayerConnection listener = ((CraftPlayer)player).getHandle().c;
        NetworkManager connection = (NetworkManager)ReflectionUtils.get(listener, NMSFields.SERVER_GAME_PACKET_LISTENER_IMPL_connection);
        ChannelPipeline pipeline = connection.m.pipeline();
        this.pipelines.put(player.getUniqueId(), pipeline);
        this.bundles.put(player.getUniqueId(), new Bundler());
        for (String name : pipeline.toMap().keySet()) {
            if (!(pipeline.get(name) instanceof NetworkManager)) continue;
            pipeline.addBefore(name, "model_engine_packet_handler", (ChannelHandler)handler);
            break;
        }
    }

    @Override
    public void ejectChannel(Player player) {
        PlayerConnection listener = ((CraftPlayer)player).getHandle().c;
        NetworkManager connection = (NetworkManager)ReflectionUtils.get(listener, NMSFields.SERVER_GAME_PACKET_LISTENER_IMPL_connection);
        Channel channel = connection.m;
        channel.eventLoop().submit(() -> {
            channel.pipeline().remove("model_engine_packet_handler");
            return null;
        });
        this.removePipeline(player);
        this.bundles.remove(player.getUniqueId());
    }

    @Override
    public void startBatch() {
        this.isBatching = true;
    }

    @Override
    public void endBatch() {
        for (Map.Entry<UUID, Bundler> entry : this.bundles.entrySet()) {
            ChannelPipeline pipeline = this.pipelines.get(entry.getKey());
            if (pipeline == null) continue;
            Bundler bundler = entry.getValue();
            bundler.bundle(arg_0 -> ((ChannelPipeline)pipeline).writeAndFlush(arg_0));
            bundler.clear();
        }
        this.isBatching = false;
    }

    public void appendPacket(UUID uuid, Packet<PacketListenerPlayOut> packet) {
        Bundler bundler = this.bundles.get(uuid);
        if (bundler != null) {
            bundler.appendPacket(packet);
        }
    }

    public void appendPackets(UUID uuid, Collection<Packet<PacketListenerPlayOut>> collection) {
        Bundler bundler = this.bundles.get(uuid);
        if (bundler != null) {
            bundler.appendPacket(collection);
        }
    }

    @Override
    public boolean isBatching() {
        return this.isBatching;
    }
}

