/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.interpolator;

import com.ticxo.modelengine.api.animation.interpolator.KeyframeInterpolator;
import com.ticxo.modelengine.api.animation.keyframe.type.AbstractKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class PrePostInterpolator<IN extends AbstractKeyframe<OUT>, OUT>
extends KeyframeInterpolator<IN, OUT> {
    public PrePostInterpolator(KeyframeInterpolator.Interpolation<IN, OUT> interpolateFunc) {
        this.setInterpolateFunc(interpolateFunc);
        this.setDefaultValue(() -> null);
    }

    public PrePostInterpolator(KeyframeInterpolator.Interpolation<IN, OUT> interpolateFunc, Supplier<OUT> def) {
        this.setInterpolateFunc(interpolateFunc);
        this.setDefaultValue(def);
    }

    @Override
    @Nullable
    public OUT interpolate(IAnimationProperty property) {
        float lastKey;
        if (this.isEmpty()) {
            return (OUT)this.defaultValue.get();
        }
        float time = (float)property.getTime();
        if (this.containsKey(Float.valueOf(time))) {
            return (OUT)((AbstractKeyframe)this.get(Float.valueOf(time))).getValue(0, property);
        }
        float nextKey = this.getHigherKey(time);
        if (nextKey == (lastKey = this.getLowerKey(time))) {
            return (OUT)((AbstractKeyframe)this.get(Float.valueOf(lastKey))).getValue(0, property);
        }
        float t = (time - lastKey) / (nextKey - lastKey);
        Object next = ((AbstractKeyframe)this.get(Float.valueOf(nextKey))).getValue(0, property);
        Object prev = ((AbstractKeyframe)this.get(Float.valueOf(lastKey))).getValue(1, property);
        return this.interpolateFunc.interpolate(new KeyframeInterpolator.Context(lastKey, nextKey, property, this), prev, next, t);
    }
}

