/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.entity.data.IEntityData;
import java.util.Map;
import java.util.UUID;

public class EntityDataTracker {
    private final Map<UUID, IEntityData> dataTrackers = Maps.newConcurrentMap();

    public void fetchEntityData() {
        for (Map.Entry<UUID, IEntityData> entry : this.dataTrackers.entrySet()) {
            IEntityData data = entry.getValue();
            if (!data.isDataValid()) {
                data.destroy();
                this.dataTrackers.remove(entry.getKey());
                continue;
            }
            data.syncUpdate();
        }
    }

    public void asyncFetchEntityData() {
        for (Map.Entry<UUID, IEntityData> entry : this.dataTrackers.entrySet()) {
            IEntityData data = entry.getValue();
            data.asyncUpdate();
        }
    }

    public void putEntityData(UUID uuid, IEntityData dataTracker) {
        this.dataTrackers.put(uuid, dataTracker);
    }

    public IEntityData getEntityData(UUID uuid) {
        return this.dataTrackers.get(uuid);
    }

    public IEntityData removeEntityData(UUID uuid) {
        return this.dataTrackers.remove(uuid);
    }

    public Map<UUID, IEntityData> getDataTrackers() {
        return this.dataTrackers;
    }
}

