/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.state;

import com.ticxo.modelengine.api.utils.state.StateNode;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class StateMachine<T> {
    protected StateNode<T> currentNode;

    public void setEntryNode(StateNode<T> entryNode) {
        this.currentNode = entryNode;
    }

    public StateNode<T> createNode() {
        return new StateNode(this);
    }

    public void execute(T target) {
        boolean updated = false;
        for (Map.Entry<Predicate<T>, Function<T, StateNode<T>>> entry : this.currentNode.getForceConnected().entrySet()) {
            if (!entry.getKey().test(target)) continue;
            this.currentNode.acceptExit(target);
            this.currentNode = entry.getValue().apply(target);
            if (this.currentNode != null) {
                this.currentNode.acceptEntry(target);
            }
            updated = true;
            break;
        }
        if (!updated && this.currentNode.testCommonPredicate(target)) {
            for (Map.Entry<Predicate<T>, Function<T, StateNode<T>>> entry : this.currentNode.getConnected().entrySet()) {
                if (!entry.getKey().test(target)) continue;
                this.currentNode.acceptExit(target);
                this.currentNode = entry.getValue().apply(target);
                if (this.currentNode == null) break;
                this.currentNode.acceptEntry(target);
                break;
            }
        }
        if (this.currentNode != null) {
            this.currentNode.acceptAction(target);
        }
    }

    public StateNode<T> getCurrentNode() {
        return this.currentNode;
    }
}

