/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.assets.BlueprintTexture;
import com.ticxo.modelengine.api.generator.assets.JavaItemModel;
import com.ticxo.modelengine.api.generator.assets.ModelAssets;
import com.ticxo.modelengine.api.generator.blueprint.BlueprintBone;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.generator.parser.ModelParser;
import com.ticxo.modelengine.api.model.ModelRegistry;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.api.utils.ticker.DualTicker;
import com.ticxo.modelengine.core.generator.ModelIdCache;
import com.ticxo.modelengine.core.generator.atlas.AtlasManager;
import com.ticxo.modelengine.core.generator.java.BaseItem;
import com.ticxo.modelengine.core.generator.parser.blockbench.BlockbenchParser;
import com.ticxo.modelengine.core.generator.parser.modelengine.ModelEngineParser;
import com.ticxo.modelengine.core.mythic.MythicUtils;
import it.unimi.dsi.fastutil.Pair;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;

public class ModelGeneratorImpl
implements ModelGenerator {
    private final ModelEngineAPI plugin;
    private final Gson gson;
    private final List<ModelParser> parsers = new ArrayList<ModelParser>();
    private final List<ModelAssets> assets = new ArrayList<ModelAssets>();
    private final AtlasManager atlasManager;
    private final File blueprintFolder;
    private final File packFolder;
    private final File assetsFolder;
    private final File baseItemFolder;
    private final File zippedResourcePack;
    private final File cachedIDJson;
    private final Map<ModelGenerator.Phase, Set<Runnable>> tasks = Maps.newConcurrentMap();
    private final Set<ModelGenerator.Phase> executed = new HashSet<ModelGenerator.Phase>();
    private ModelIdCache cache;
    private String namespace;
    private File modelFolder;
    private BaseItem baseItem;
    private BaseItemEnum baseItemType;
    private boolean initialized;

    public ModelGeneratorImpl(ModelEngineAPI plugin) {
        this.plugin = plugin;
        this.gson = plugin.getGson();
        this.blueprintFolder = TFile.createDirectory(plugin.getDataFolder(), "blueprints");
        this.packFolder = TFile.createDirectory(plugin.getDataFolder(), "resource pack");
        this.assetsFolder = TFile.createDirectory(this.packFolder, "assets");
        this.baseItemFolder = TFile.createDirectory(this.assetsFolder, "minecraft", "models", "item");
        this.zippedResourcePack = TFile.createFile(plugin.getDataFolder(), "resource pack.zip");
        this.cachedIDJson = TFile.createFileOrEmpty(plugin.getDataFolder(), ".data", "cache.json");
        this.atlasManager = new AtlasManager(this);
        this.refreshCache();
        plugin.getConfigManager().registerReferenceUpdate(this::updateConfig);
        this.parsers.add(new ModelEngineParser());
        this.parsers.add(new BlockbenchParser());
    }

    @Override
    public void importModels(boolean isStartup) {
        this.executed.clear();
        if (!isStartup || ConfigProperty.LATE_REGISTER.getBoolean()) {
            DualTicker.queueIOTask(() -> this.importModelsInternal(isStartup));
        } else {
            this.importModelsInternal(true);
        }
    }

    @Override
    public void generateAssets(boolean isStartup) {
        if (!ConfigProperty.LATE_REGISTER.getBoolean() && ConfigProperty.LATE_ASSETS.getBoolean()) {
            DualTicker.queueIOTask(() -> this.generateAssetsInternal(isStartup));
        } else {
            this.generateAssetsInternal(true);
        }
    }

    @Override
    public void zipResourcePack(boolean isStartup) {
        if (!ConfigProperty.ZIP.getBoolean()) {
            this.executeQueuedTask(ModelGenerator.Phase.FINISHED);
            return;
        }
        if (!ConfigProperty.LATE_ASSETS.getBoolean() && ConfigProperty.LATE_ZIPPING.getBoolean()) {
            DualTicker.queueIOTask(this::zipResourcePackInternal);
        } else {
            this.zipResourcePackInternal();
        }
    }

    @Override
    public void updateConfig() {
        this.namespace = ConfigProperty.NAMESPACE.getString();
        this.modelFolder = TFile.createDirectory(this.assetsFolder, this.namespace, "models");
        this.changeBaseItem(ConfigProperty.ITEM_MODEL.getBaseItem());
    }

    @Override
    public void queueTask(ModelGenerator.Phase post, Runnable task) {
        if (this.executed.contains((Object)ModelGenerator.Phase.FINISHED) || this.executed.contains((Object)post)) {
            task.run();
        } else {
            this.tasks.computeIfAbsent(post, phase -> new LinkedHashSet()).add(task);
        }
    }

    private void executeQueuedTask(ModelGenerator.Phase phase) {
        this.executed.add(phase);
        if (phase == ModelGenerator.Phase.FINISHED) {
            this.tasks.values().forEach(runnables -> runnables.forEach(Runnable::run));
            this.tasks.clear();
        } else {
            this.tasks.computeIfPresent(phase, (p, runnables) -> {
                runnables.forEach(Runnable::run);
                runnables.clear();
                return runnables;
            });
        }
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(phase));
    }

    public void changeBaseItem(BaseItemEnum base) {
        this.baseItemType = base;
        String name = base.name().toLowerCase(Locale.ENGLISH);
        InputStream inputStream = this.plugin.getResource("pack/colorable/" + name + ".json");
        if (inputStream == null) {
            TLogger.warn("Unknown colorable item: " + name + ". Reverting to use leather_horse_armor.");
            inputStream = this.plugin.getResource("pack/colorable/leather_horse_armor.json");
        }
        if (inputStream == null) {
            TLogger.error("Unable to locate base files.");
            return;
        }
        InputStreamReader itemTemplateReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.baseItem = (BaseItem)this.gson.fromJson((Reader)itemTemplateReader, BaseItem.class);
        this.baseItem.setName(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importModelsInternal(boolean isStartup) {
        TLogger.log();
        TLogger.log(LogColor.BOLD + LogColor.CYAN.toString() + "[Importing models]");
        this.initialized = false;
        this.executeQueuedTask(ModelGenerator.Phase.PRE_IMPORT);
        this.refreshCache();
        ModelRegistry registry = this.plugin.getModelRegistry();
        registry.clearRegistry();
        if (!this.blueprintFolder.isDirectory()) {
            this.initialized = true;
            this.executeQueuedTask(ModelGenerator.Phase.FINISHED);
            return;
        }
        List<Object> files = Lists.newArrayList();
        File[] fa = this.blueprintFolder.listFiles();
        if (fa != null) {
            files.addAll(Arrays.asList(fa));
        }
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            try {
                files.addAll(MythicUtils.getPackModelFiles());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (files.size() == 0) {
            this.initialized = true;
            this.executeQueuedTask(ModelGenerator.Phase.FINISHED);
            return;
        }
        LinkedList<File> compartment = new LinkedList<File>();
        files.sort((Comparator<Object>)Ordering.natural());
        block11: while (true) {
            File[] ca;
            for (File file : files) {
                if (!file.isFile()) {
                    if (!file.isDirectory()) continue;
                    compartment.add(file);
                    continue;
                }
                boolean fileParsed = false;
                TLogger.log();
                TLogger.log(LogColor.CYAN + "Importing " + file.getName() + ".");
                for (ModelParser parser : this.parsers) {
                    if (!parser.validateFile(file)) continue;
                    try {
                        Pair<ModelBlueprint, ModelAssets> modelData = parser.generate(file);
                        if (modelData == null) continue;
                        ModelBlueprint blueprint = (ModelBlueprint)modelData.left();
                        ModelAssets asset = (ModelAssets)modelData.right();
                        blueprint.finalizeModel();
                        for (Map.Entry<String, BlueprintBone> boneEntry : blueprint.getFlatMap().entrySet()) {
                            BlueprintBone bone = boneEntry.getValue();
                            if (!bone.isRenderer()) continue;
                            this.cache.requestId(blueprint.getName(), bone);
                        }
                        registry.registerBlueprint(blueprint);
                        this.assets.add(asset);
                        fileParsed = true;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (fileParsed) continue;
                IError.UNKNOWN_FORMAT.log();
            }
            do {
                if (!compartment.isEmpty()) continue;
                registry.sortIds();
                this.initialized = true;
                try (FileWriter writer = new FileWriter(this.cachedIDJson);){
                    this.cache.endSession();
                    writer.write(this.gson.toJson((Object)this.cache));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block11;
            } while ((ca = ((File)compartment.poll()).listFiles()) == null || ca.length == 0);
            files = Arrays.asList(ca);
            files.sort((Comparator<Object>)Ordering.natural());
        }
        this.executeQueuedTask(ModelGenerator.Phase.POST_IMPORT);
        this.generateAssets(isStartup);
    }

    private void generateAssetsInternal(boolean isStartup) {
        this.executeQueuedTask(ModelGenerator.Phase.PRE_ASSETS);
        this.baseItem.clearOverrides();
        this.atlasManager.reset();
        HashMap<String, BlueprintTexture.MCMeta> lazyMCMeta = new HashMap<String, BlueprintTexture.MCMeta>();
        for (ModelAssets asset : this.assets) {
            for (BlueprintTexture texture : asset.getTextures()) {
                if ("minecraft".equals(texture.getPath().getNamespace())) continue;
                this.atlasManager.addSingle(texture.getPath());
                File png = TFile.createFile(this.assetsFolder, "textures", texture.getPath(), "png");
                BufferedImage image = TFile.toImage(texture.getSource());
                try {
                    ImageIO.write((RenderedImage)image, "png", png);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (texture.getMcMeta() == null || !this.shouldGenerateMCMeta(image, texture)) continue;
                File mcmeta = TFile.createFile(this.assetsFolder, "textures", texture.getPath(), "png.mcmeta");
                try (FileWriter writer = new FileWriter(mcmeta);){
                    lazyMCMeta.put("animation", texture.getMcMeta());
                    writer.write(this.gson.toJson(lazyMCMeta));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (JavaItemModel model : asset.getModels().values()) {
                Integer id;
                model.finalizeModel();
                File modelJson = TFile.createFile(this.modelFolder, asset.getName(), model.getName() + ".json");
                try (FileWriter writer = new FileWriter(modelJson);){
                    writer.write(this.gson.toJson((Object)model));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if ((id = this.cache.cachedId.get(asset.getName() + ":" + model.getName())) == null) continue;
                this.baseItem.addModel(this.namespace + ":" + asset.getName() + "/" + model.getName(), id);
            }
        }
        this.assets.clear();
        this.baseItem.sortOverrides();
        File baseItemFile = TFile.createFile(this.baseItemFolder, this.baseItem.getName() + ".json");
        try (FileWriter writer = new FileWriter(baseItemFile);){
            writer.write(this.gson.toJson((Object)this.baseItem));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ConfigProperty.ATLAS.getBoolean()) {
            this.atlasManager.generateFile();
        }
        TFile.copyResource(this.plugin, this.packFolder, "pack", "pack.png");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "pack.mcmeta");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/head.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/left_arm.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/left_leg.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/right_arm.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/right_leg.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/slim_left.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/slim_right.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/custom/entities/player/torso.json");
        TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/models/item/player_head.json");
        if (ConfigProperty.SHADER.getBoolean()) {
            TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/shaders/core/rendertype_entity_translucent.fsh");
            TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/shaders/core/rendertype_entity_translucent.json");
            TFile.copyResource(this.plugin, this.packFolder, "pack", "assets/minecraft/shaders/core/rendertype_entity_translucent.vsh");
        }
        this.executeQueuedTask(ModelGenerator.Phase.POST_ASSETS);
        this.zipResourcePack(isStartup);
    }

    private void zipResourcePackInternal() {
        this.executeQueuedTask(ModelGenerator.Phase.PRE_ZIPPING);
        try {
            FileOutputStream zippedFOS = new FileOutputStream(this.zippedResourcePack);
            ZipOutputStream zipOut = new ZipOutputStream(zippedFOS);
            File[] files = this.packFolder.listFiles();
            if (files == null) {
                this.executeQueuedTask(ModelGenerator.Phase.FINISHED);
                return;
            }
            for (File file : files) {
                this.zipFile(file, file.getName(), zipOut);
            }
            zipOut.close();
            zippedFOS.close();
            TLogger.log();
            TLogger.log(LogColor.BRIGHT_GREEN + "Resource pack zipped.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.executeQueuedTask(ModelGenerator.Phase.POST_ZIPPING);
        this.executeQueuedTask(ModelGenerator.Phase.FINISHED);
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
            }
            zipOut.closeEntry();
            File[] children = fileToZip.listFiles();
            if (children != null) {
                for (File childFile : children) {
                    this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    private boolean shouldGenerateMCMeta(BufferedImage image, BlueprintTexture texture) {
        float uvRatio;
        if (texture.getMcMeta().isMustGenerate()) {
            return true;
        }
        float textureRatio = (float)image.getHeight() / (float)image.getWidth();
        if (TMath.isSimilar(textureRatio, uvRatio = (float)texture.getFrameHeight() / (float)texture.getFrameWidth())) {
            return false;
        }
        return textureRatio / uvRatio > 1.0f;
    }

    private void refreshCache() {
        try (FileReader reader = new FileReader(this.cachedIDJson);){
            this.cache = (ModelIdCache)this.gson.fromJson((Reader)reader, ModelIdCache.class);
            if (this.cache == null) {
                this.cache = new ModelIdCache();
            }
        }
        catch (IOException e) {
            this.cache = new ModelIdCache();
            TLogger.error("Unable to read the model ID cache file. Is it corrupted?");
            e.printStackTrace();
        }
    }

    public ModelEngineAPI getPlugin() {
        return this.plugin;
    }

    public Gson getGson() {
        return this.gson;
    }

    public List<ModelParser> getParsers() {
        return this.parsers;
    }

    public List<ModelAssets> getAssets() {
        return this.assets;
    }

    public AtlasManager getAtlasManager() {
        return this.atlasManager;
    }

    public File getBlueprintFolder() {
        return this.blueprintFolder;
    }

    public File getPackFolder() {
        return this.packFolder;
    }

    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    public File getBaseItemFolder() {
        return this.baseItemFolder;
    }

    public File getZippedResourcePack() {
        return this.zippedResourcePack;
    }

    public File getCachedIDJson() {
        return this.cachedIDJson;
    }

    public Map<ModelGenerator.Phase, Set<Runnable>> getTasks() {
        return this.tasks;
    }

    public Set<ModelGenerator.Phase> getExecuted() {
        return this.executed;
    }

    public ModelIdCache getCache() {
        return this.cache;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getModelFolder() {
        return this.modelFolder;
    }

    public BaseItem getBaseItem() {
        return this.baseItem;
    }

    public BaseItemEnum getBaseItemType() {
        return this.baseItemType;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }
}

