/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.bone.render;

import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRendererParser;
import com.ticxo.modelengine.api.model.bone.render.renderer.HeldItemRenderer;
import com.ticxo.modelengine.api.model.bone.type.HeldItem;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.UpdateDataTracker;
import com.ticxo.modelengine.core.model.bone.render.AbstractBehaviorRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class HeldItemRendererImpl
extends AbstractBehaviorRenderer
implements HeldItemRenderer {
    private final BehaviorRendererParser<HeldItemRenderer> parser;
    private final int id;
    private final UUID uuid;
    private final Map<String, HeldItemRenderer.Item> spawnQueue = new HashMap<String, HeldItemRenderer.Item>();
    private final Map<String, HeldItemRenderer.Item> rendered = new HashMap<String, HeldItemRenderer.Item>();
    private final Map<String, HeldItemRenderer.Item> destroyQueue = new HashMap<String, HeldItemRenderer.Item>();
    private final CollectionDataTracker<Integer> passengers = new CollectionDataTracker(new HashSet());
    private boolean initialized;

    public HeldItemRendererImpl(ActiveModel activeModel) {
        super(activeModel);
        this.parser = this.nmsHandler.getBehaviorRendererParser(this);
        this.id = this.nmsHandler.getEntityHandler().getNextEntityId();
        this.uuid = UUID.randomUUID();
    }

    @Override
    public void initialize() {
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            this.create(boneId, modelBone);
        }
        this.initialized = true;
    }

    private void create(String boneId, ModelBone modelBone) {
        Optional<? extends HeldItem> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM);
        if (maybeData.isEmpty()) {
            return;
        }
        BoneBehavior itemData = (BoneBehavior)((Object)maybeData.get());
        ActiveModel activeModel = modelBone.getActiveModel();
        ModelBlueprint blueprint = activeModel.getBlueprint();
        Vector3f modelScale = activeModel.getScale();
        Hitbox mainHitbox = blueprint.getMainHitbox();
        float scaledHeight = (float)mainHitbox.getHeight() * modelScale.y;
        float scaledWidth = (float)mainHitbox.getWidth() * modelScale.x;
        ItemImpl item = new ItemImpl(this.nmsHandler.getEntityHandler().getNextEntityId(), UUID.randomUUID());
        item.position.set(((HeldItem)((Object)itemData)).getLocation());
        item.scale.set(modelBone.getGlobalScale());
        item.rotation.set(((HeldItem)((Object)itemData)).getRotation());
        item.width.set(Float.valueOf(scaledWidth));
        item.height.set(Float.valueOf(scaledHeight));
        item.model.set(modelBone.isVisible() ? modelBone.getModel() : null);
        item.display.set(((HeldItem)((Object)itemData)).getDisplay());
        this.spawnQueue.put(boneId, item);
        this.destroyQueue.remove(boneId);
        this.passengers.add(item.id);
    }

    @Override
    public void readBoneData() {
        if (!this.initialized) {
            return;
        }
        this.destroyQueue.putAll(this.rendered);
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            HeldItemRenderer.Item renderer = this.rendered.get(boneId);
            if (renderer != null) {
                this.read(boneId, renderer, modelBone);
                continue;
            }
            this.create(boneId, modelBone);
        }
        this.destroyQueue.forEach((s, item) -> this.passengers.remove(item.getId()));
    }

    private void read(String boneId, HeldItemRenderer.Item item, ModelBone modelBone) {
        Optional<? extends HeldItem> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM);
        ActiveModel activeModel = modelBone.getActiveModel();
        ModelBlueprint blueprint = activeModel.getBlueprint();
        Vector3f modelScale = activeModel.getScale();
        Hitbox mainHitbox = blueprint.getMainHitbox();
        float scaledHeight = (float)mainHitbox.getHeight() * modelScale.y;
        float scaledWidth = (float)mainHitbox.getWidth() * modelScale.x;
        maybeData.ifPresent(heldItem -> {
            item.getPosition().set(((HeldItem)((Object)heldItem)).getLocation());
            item.getScale().set(modelBone.getGlobalScale());
            item.getRotation().set(((HeldItem)((Object)heldItem)).getRotation());
            item.getWidth().set(Float.valueOf(scaledWidth));
            item.getHeight().set(Float.valueOf(scaledHeight));
            if (!modelBone.isVisible()) {
                item.getModel().set(null);
            } else {
                item.getModel().set(modelBone.getModel());
                if (modelBone.getModelTracker().isDirty()) {
                    modelBone.getModelTracker().clearDirty();
                    item.getModel().markDirty();
                }
            }
            item.getDisplay().set(((HeldItem)((Object)heldItem)).getDisplay());
            this.destroyQueue.remove(boneId);
        });
    }

    @Override
    public void sendToClient() {
        if (!this.initialized) {
            return;
        }
        this.destroyQueue.keySet().forEach(this.rendered::remove);
        this.parser.sendToClients(this);
        this.rendered.putAll(this.spawnQueue);
        this.spawnQueue.clear();
        this.destroyQueue.clear();
    }

    @Override
    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.parser.destroy(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Map<String, HeldItemRenderer.Item> getSpawnQueue() {
        return this.spawnQueue;
    }

    @Override
    public Map<String, HeldItemRenderer.Item> getRendered() {
        return this.rendered;
    }

    @Override
    public Map<String, HeldItemRenderer.Item> getDestroyQueue() {
        return this.destroyQueue;
    }

    @Override
    public CollectionDataTracker<Integer> getPassengers() {
        return this.passengers;
    }

    public static class ItemImpl
    implements HeldItemRenderer.Item {
        private final int id;
        private final UUID uuid;
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Vector3f> scale = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Quaternionf> rotation = new UpdateDataTracker<Quaternionf>(new Quaternionf(), Quaternionf::set);
        private final DataTracker<Float> width = new DataTracker();
        private final DataTracker<Float> height = new DataTracker();
        private final DataTracker<ItemStack> model = new DataTracker();
        private final DataTracker<ItemDisplay.ItemDisplayTransform> display = new DataTracker<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.NONE);

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        @Override
        public DataTracker<Vector3f> getScale() {
            return this.scale;
        }

        @Override
        public DataTracker<Quaternionf> getRotation() {
            return this.rotation;
        }

        @Override
        public DataTracker<Float> getWidth() {
            return this.width;
        }

        @Override
        public DataTracker<Float> getHeight() {
            return this.height;
        }

        @Override
        public DataTracker<ItemStack> getModel() {
            return this.model;
        }

        @Override
        public DataTracker<ItemDisplay.ItemDisplayTransform> getDisplay() {
            return this.display;
        }

        public ItemImpl(int id, UUID uuid) {
            this.id = id;
            this.uuid = uuid;
        }
    }
}

