/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.render;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.ServerInfo;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.manager.BehaviorManager;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRenderer;
import com.ticxo.modelengine.api.model.bone.render.renderer.HeldItemRenderer;
import com.ticxo.modelengine.api.model.bone.type.HeldItem;
import com.ticxo.modelengine.api.model.render.DisplayRenderer;
import com.ticxo.modelengine.api.model.render.ModelRendererParser;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.UpdateDataTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DisplayRendererImpl
implements DisplayRenderer {
    private final ActiveModel activeModel;
    private final EntityHandler entityHandler;
    private final ModelRendererParser<DisplayRenderer> parser;
    private final Map<String, DisplayRenderer.Bone> spawnQueue = new HashMap<String, DisplayRenderer.Bone>();
    private final Map<String, DisplayRenderer.Bone> rendered = new HashMap<String, DisplayRenderer.Bone>();
    private final Map<String, DisplayRenderer.Bone> destroyQueue = new HashMap<String, DisplayRenderer.Bone>();
    private final Set<UUID> fullUpdate = new HashSet<UUID>();
    private PivotImpl pivot;
    private HitboxImpl hitbox;
    private boolean initialized;
    private boolean firstSpawned;

    public DisplayRendererImpl(ActiveModel activeModel) {
        this.activeModel = activeModel;
        this.entityHandler = ModelEngineAPI.getEntityHandler();
        this.parser = ModelEngineAPI.getNMSHandler().getModelRendererParser(this);
    }

    @Override
    public void initialize() {
        ModeledEntity model = this.activeModel.getModeledEntity();
        BaseEntity<?> base = model.getBase();
        Location location = base.getLocation();
        ModelBlueprint blueprint = this.activeModel.getBlueprint();
        Vector3f scale = this.activeModel.getScale();
        Vector3f hitboxScale = this.activeModel.getHitboxScale();
        Hitbox mainHitbox = blueprint.getMainHitbox();
        float scaledEyeHeight = (float)mainHitbox.getEyeHeight() * scale.y;
        float scaledHeight = (float)mainHitbox.getHeight() * hitboxScale.y;
        float scaledWidth = (float)mainHitbox.getMaxWidth() * hitboxScale.x;
        this.pivot = new PivotImpl(this.entityHandler.getNextEntityId());
        this.pivot.updatePosition(location, scaledEyeHeight);
        this.pivot.getYaw().set(Float.valueOf((180.0f - model.getYBodyRot()) * ((float)Math.PI / 180)));
        for (Map.Entry<String, ModelBone> entry : this.activeModel.getBones().entrySet()) {
            this.create(entry.getKey(), entry.getValue(), scaledEyeHeight);
        }
        this.forBehaviorRenderer(behaviorRenderer -> {
            behaviorRenderer.setModelRenderer(this);
            behaviorRenderer.initialize();
        });
        this.hitbox = new HitboxImpl(this.entityHandler.getNextEntityId(), this.entityHandler.getNextEntityId(), this.entityHandler.getNextEntityId());
        this.hitbox.updatePosition(location);
        this.hitbox.getHeight().set(Float.valueOf(scaledHeight));
        this.hitbox.getWidth().set(Float.valueOf(scaledWidth));
        this.hitbox.getShadowRadius().set(Float.valueOf(blueprint.getShadowRadius() * scale.x));
        this.hitbox.getHitboxVisible().set(this.activeModel.isHitboxVisible());
        this.hitbox.getShadowVisible().set(this.activeModel.isShadowVisible());
        ModelEngineAPI.getInteractionTracker().setModelRelay(this.hitbox.hitboxId, this.activeModel);
        this.initialized = true;
        this.firstSpawned = true;
    }

    private void create(String boneId, ModelBone modelBone, float eyeHeight) {
        if (!modelBone.isRenderer()) {
            return;
        }
        BoneImpl bone = new BoneImpl(this.entityHandler.getNextEntityId());
        bone.getVisibility().set(modelBone.isVisible());
        bone.getModel().set(modelBone.getModel());
        bone.getPosition().set(modelBone.getGlobalPosition().add(0.0f, -eyeHeight, 0.0f, new Vector3f()).rotateY(this.pivot.yaw.get().floatValue()));
        bone.getLeftRotation().set(modelBone.getGlobalLeftRotation().rotateLocalY(this.pivot.yaw.get().floatValue(), new Quaternionf()));
        bone.getScale().set(modelBone.getGlobalScale());
        bone.getRightRotation().set(modelBone.getGlobalRightRotation());
        this.initializeSpecialBehaviorRender(modelBone, bone);
        this.spawnQueue.put(boneId, bone);
        this.destroyQueue.remove(boneId);
        this.pivot.passengers.add(bone.id);
    }

    private void initializeSpecialBehaviorRender(ModelBone modelBone, DisplayRenderer.Bone bone) {
        modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM).ifPresent(item -> bone.getDisplay().set(((HeldItem)((Object)item)).getDisplay()));
        modelBone.getBoneBehavior(BoneBehaviorTypes.PLAYER_LIMB).ifPresent(limb -> bone.getDisplay().set(ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND));
    }

    @Override
    public void readModelData() {
        if (!this.initialized) {
            return;
        }
        ModeledEntity model = this.activeModel.getModeledEntity();
        BaseEntity<?> base = model.getBase();
        Location location = base.getLocation();
        ModelBlueprint blueprint = this.activeModel.getBlueprint();
        Vector3f scale = this.activeModel.getScale();
        Vector3f hitboxScale = this.activeModel.getHitboxScale();
        Hitbox mainHitbox = blueprint.getMainHitbox();
        float scaledEyeHeight = (float)mainHitbox.getEyeHeight() * scale.y;
        float scaledHeight = (float)mainHitbox.getHeight() * hitboxScale.y;
        float scaledWidth = (float)mainHitbox.getMaxWidth() * hitboxScale.x;
        this.pivot.updatePosition(location, scaledEyeHeight);
        this.pivot.getYaw().set(Float.valueOf((180.0f - model.getYBodyRot()) * ((float)Math.PI / 180)));
        this.destroyQueue.putAll(this.rendered);
        for (Map.Entry<String, ModelBone> entry : this.activeModel.getBones().entrySet()) {
            DisplayRenderer.Bone bone2 = this.rendered.get(entry.getKey());
            if (bone2 == null) {
                this.create(entry.getKey(), entry.getValue(), scaledEyeHeight);
                continue;
            }
            this.read(entry.getKey(), bone2, entry.getValue(), scaledEyeHeight);
        }
        this.destroyQueue.forEach((s, bone) -> this.pivot.passengers.remove(bone.getId()));
        this.forBehaviorRenderer(BehaviorRenderer::readBoneData);
        this.hitbox.updatePosition(location);
        this.hitbox.getHeight().set(Float.valueOf(scaledHeight));
        this.hitbox.getWidth().set(Float.valueOf(scaledWidth));
        this.hitbox.getShadowRadius().set(Float.valueOf(blueprint.getShadowRadius() * scale.x));
        this.hitbox.getHitboxVisible().set(this.activeModel.isHitboxVisible());
        this.hitbox.getShadowVisible().set(this.activeModel.isShadowVisible());
    }

    private void read(String boneId, DisplayRenderer.Bone bone, ModelBone modelBone, float eyeHeight) {
        bone.getPosition().set(modelBone.getGlobalPosition().add(0.0f, -eyeHeight, 0.0f, new Vector3f()).rotateY(this.pivot.getYaw().get().floatValue()));
        bone.getLeftRotation().set(modelBone.getGlobalLeftRotation().rotateLocalY(this.pivot.getYaw().get().floatValue(), new Quaternionf()));
        bone.getScale().set(modelBone.getGlobalScale());
        bone.getRightRotation().set(modelBone.getGlobalRightRotation());
        bone.getVisibility().set(modelBone.isVisible());
        if (modelBone.getModelTracker().isDirty()) {
            modelBone.getModelTracker().clearDirty();
            bone.getModel().set(modelBone.getModel());
            bone.getModel().markDirty();
        }
        this.updateSpecialBehaviorRender(modelBone, bone);
        this.destroyQueue.remove(boneId);
    }

    private void updateSpecialBehaviorRender(ModelBone modelBone, DisplayRenderer.Bone bone) {
        modelBone.getBoneBehavior(BoneBehaviorTypes.ITEM).ifPresent(item -> bone.getDisplay().set(((HeldItem)((Object)item)).getDisplay()));
    }

    @Override
    public void sendToClient() {
        if (!this.initialized) {
            return;
        }
        this.forManagers(BehaviorManager::preBoneRender);
        this.forBehavior(BoneBehavior::preRender);
        this.destroyQueue.keySet().forEach(this.rendered::remove);
        this.parser.sendToClients(this);
        this.rendered.putAll(this.spawnQueue);
        this.spawnQueue.clear();
        this.destroyQueue.clear();
        this.forBehaviorRenderer(BehaviorRenderer::sendToClient);
        this.forBehavior(BoneBehavior::onRender);
        this.forBehavior(BoneBehavior::postRender);
        this.forManagers(BehaviorManager::postBoneRender);
    }

    @Override
    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.forBehaviorRenderer(BehaviorRenderer::destroy);
        this.parser.destroy(this);
        ModelEngineAPI.getInteractionTracker().removeModelRelay(this.hitbox.hitboxId);
    }

    @Override
    public void createRealEntities() {
        World world = this.activeModel.getModeledEntity().getBase().getLocation().getWorld();
        if (world == null) {
            return;
        }
        Vector3f pos = this.pivot.getPosition().get();
        Location location = new Location(world, (double)pos.x, (double)pos.y, (double)pos.z);
        for (DisplayRenderer.Bone bone : this.rendered.values()) {
            world.spawn(location, ItemDisplay.class, itemDisplay -> {
                Quaternionf rotation = bone.getLeftRotation().get();
                if (ServerInfo.VERSION_NUMBER > 19) {
                    rotation = rotation.rotateY((float)Math.PI, new Quaternionf());
                }
                itemDisplay.setTransformation(new Transformation(bone.getPosition().get(), rotation, bone.getScale().get(), new Quaternionf()));
                itemDisplay.setItemStack(bone.getModel().get().clone());
                itemDisplay.setItemDisplayTransform(bone.getDisplay().get());
            });
        }
    }

    @Override
    public boolean pollFirstSpawn() {
        if (!this.firstSpawned) {
            return false;
        }
        this.firstSpawned = false;
        return true;
    }

    private void forManagers(Consumer<BehaviorManager<?>> consumer) {
        for (BehaviorManager<?> manager : this.activeModel.getBehaviorManagers().values()) {
            consumer.accept(manager);
        }
    }

    private void forBehavior(Consumer<BoneBehavior> consumer) {
        for (String boneId : this.activeModel.getBlueprint().getBones().keySet()) {
            Optional<ModelBone> maybeBone = this.activeModel.getBone(boneId);
            maybeBone.ifPresent(bone -> bone.getImmutableBoneBehaviors().values().forEach(consumer));
        }
    }

    private void forBehaviorRenderer(Consumer<BehaviorRenderer> consumer) {
        for (BehaviorRenderer renderer : this.activeModel.getBehaviorRenderers().values()) {
            if (renderer instanceof HeldItemRenderer) continue;
            consumer.accept(renderer);
        }
    }

    @Override
    public int getTick() {
        return this.activeModel.getModeledEntity().getTick();
    }

    @Override
    public void pushFullUpdate(Player player) {
        this.fullUpdate.add(player.getUniqueId());
    }

    @Override
    public boolean pollFullUpdate(Player player) {
        return this.fullUpdate.remove(player.getUniqueId());
    }

    @Override
    public ActiveModel getActiveModel() {
        return this.activeModel;
    }

    @Override
    public Map<String, DisplayRenderer.Bone> getSpawnQueue() {
        return this.spawnQueue;
    }

    @Override
    public Map<String, DisplayRenderer.Bone> getRendered() {
        return this.rendered;
    }

    @Override
    public Map<String, DisplayRenderer.Bone> getDestroyQueue() {
        return this.destroyQueue;
    }

    @Override
    public PivotImpl getPivot() {
        return this.pivot;
    }

    @Override
    public HitboxImpl getHitbox() {
        return this.hitbox;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public static class PivotImpl
    implements DisplayRenderer.Pivot {
        private final int id;
        private final UUID uuid = UUID.randomUUID();
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Float> yaw = new DataTracker();
        private final CollectionDataTracker<Integer> passengers = new CollectionDataTracker(new HashSet());

        public void updatePosition(Location location, float eyeHeight) {
            this.position.set(new Vector3f().set(location.getX(), location.getY() + (double)eyeHeight, location.getZ()));
        }

        @Override
        public void clearDirty() {
            this.yaw.clearDirty();
            this.passengers.clearDirty();
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        public DataTracker<Float> getYaw() {
            return this.yaw;
        }

        @Override
        public CollectionDataTracker<Integer> getPassengers() {
            return this.passengers;
        }

        public PivotImpl(int id) {
            this.id = id;
        }
    }

    public static class HitboxImpl
    implements DisplayRenderer.Hitbox {
        private final int pivotId;
        private final UUID pivotUuid = UUID.randomUUID();
        private final int hitboxId;
        private final UUID hitboxUuid = UUID.randomUUID();
        private final int shadowId;
        private final UUID shadowUuid = UUID.randomUUID();
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Float> width = new DataTracker();
        private final DataTracker<Float> height = new DataTracker();
        private final DataTracker<Float> shadowRadius = new DataTracker();
        private final DataTracker<Boolean> hitboxVisible = new DataTracker();
        private final DataTracker<Boolean> shadowVisible = new DataTracker();

        public void updatePosition(Location location) {
            this.position.set(new Vector3f().set(location.getX(), location.getY(), location.getZ()));
        }

        @Override
        public void clearDirty() {
            this.width.clearDirty();
            this.height.clearDirty();
            this.shadowRadius.clearDirty();
            this.hitboxVisible.clearDirty();
            this.shadowVisible.clearDirty();
        }

        @Override
        public int getPivotId() {
            return this.pivotId;
        }

        @Override
        public UUID getPivotUuid() {
            return this.pivotUuid;
        }

        @Override
        public int getHitboxId() {
            return this.hitboxId;
        }

        @Override
        public UUID getHitboxUuid() {
            return this.hitboxUuid;
        }

        @Override
        public int getShadowId() {
            return this.shadowId;
        }

        @Override
        public UUID getShadowUuid() {
            return this.shadowUuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        @Override
        public DataTracker<Float> getWidth() {
            return this.width;
        }

        @Override
        public DataTracker<Float> getHeight() {
            return this.height;
        }

        @Override
        public DataTracker<Float> getShadowRadius() {
            return this.shadowRadius;
        }

        @Override
        public DataTracker<Boolean> getHitboxVisible() {
            return this.hitboxVisible;
        }

        @Override
        public DataTracker<Boolean> getShadowVisible() {
            return this.shadowVisible;
        }

        public HitboxImpl(int pivotId, int hitboxId, int shadowId) {
            this.pivotId = pivotId;
            this.hitboxId = hitboxId;
            this.shadowId = shadowId;
        }
    }

    public static class BoneImpl
    implements DisplayRenderer.Bone {
        private final int id;
        private final UUID uuid = UUID.randomUUID();
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Quaternionf> leftRotation = new UpdateDataTracker<Quaternionf>(new Quaternionf(), Quaternionf::set);
        private final DataTracker<Vector3f> scale = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<Quaternionf> rightRotation = new UpdateDataTracker<Quaternionf>(new Quaternionf(), Quaternionf::set);
        private final DataTracker<ItemStack> model = new DataTracker();
        private final DataTracker<ItemDisplay.ItemDisplayTransform> display = new DataTracker<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.NONE);
        private final DataTracker<Boolean> visibility = new DataTracker<Boolean>(true);

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        @Override
        public DataTracker<Quaternionf> getLeftRotation() {
            return this.leftRotation;
        }

        @Override
        public DataTracker<Vector3f> getScale() {
            return this.scale;
        }

        @Override
        public DataTracker<Quaternionf> getRightRotation() {
            return this.rightRotation;
        }

        @Override
        public DataTracker<ItemStack> getModel() {
            return this.model;
        }

        @Override
        public DataTracker<ItemDisplay.ItemDisplayTransform> getDisplay() {
            return this.display;
        }

        @Override
        public DataTracker<Boolean> getVisibility() {
            return this.visibility;
        }

        public BoneImpl(int id) {
            this.id = id;
        }
    }
}

