/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.mechanics.disguise;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.core.mythic.MythicUtils;
import com.ticxo.modelengine.core.mythic.utils.MythicMechanic;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MythicMechanic(name="undisguise", aliases={"modelundisguise"})
public class UndisguiseMechanic
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;

    public UndisguiseMechanic(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)target.getBukkitEntity();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((Entity)player);
        if (modeledEntity != null) {
            String modelId = MythicUtils.getOrNullLowercase(this.modelId, (PlaceholderMeta)meta, target);
            if (modelId == null) {
                modeledEntity.markRemoved();
                ModelEngineAPI.getEntityHandler().setForcedInvisible(player, false);
                ModelEngineAPI.getEntityHandler().forceSpawn((Entity)player);
            } else {
                modeledEntity.removeModel(modelId).ifPresent(ActiveModel::destroy);
                if (modeledEntity.getModels().isEmpty()) {
                    modeledEntity.markRemoved();
                    ModelEngineAPI.getEntityHandler().setForcedInvisible(player, false);
                    ModelEngineAPI.getEntityHandler().forceSpawn((Entity)player);
                }
            }
        }
        return SkillResult.SUCCESS;
    }

    public boolean getTargetsCreatives() {
        return true;
    }
}

