/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.v1_19_R3.network;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.interaction.DynamicHitbox;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModelUpdater;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.render.renderer.MountRenderer;
import com.ticxo.modelengine.api.model.bone.type.Mount;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.network.ProtectedPacket;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.v1_19_R3.entity.EntityUtils;
import com.ticxo.modelengine.v1_19_R3.network.patch.ServerboundInteractPacketWrapper;
import com.ticxo.modelengine.v1_19_R3.network.utils.NetworkUtils;
import com.ticxo.modelengine.v1_19_R3.network.utils.PacketInterceptor;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ModelEngineChannelHandler
extends ChannelDuplexHandler {
    private final Player player;
    private final EntityPlayer serverPlayer;
    private final ModelUpdater updater;
    private final EntityHandler entityHandler;
    private final PacketInterceptor<PacketListenerPlayOut> writeInterceptors;
    private final PacketInterceptor<PacketListenerPlayIn> readInterceptors;

    public ModelEngineChannelHandler(Player player) {
        this.player = player;
        this.serverPlayer = ((CraftPlayer)player).getHandle();
        this.updater = ModelEngineAPI.getAPI().getModelUpdater();
        this.entityHandler = ModelEngineAPI.getEntityHandler();
        this.writeInterceptors = new PacketInterceptor();
        this.writeInterceptors.register(PacketPlayOutSpawnEntity.class, this::handleAddEntity).register(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayer).register(PacketPlayOutEntityDestroy.class, this::handleRemoveEntities).register(PacketPlayOutEntity.PacketPlayOutRelEntityMove.class, this::handleEntityId).register(PacketPlayOutEntity.PacketPlayOutEntityLook.class, this::handleEntityId).register(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class, this::handleEntityId).register(PacketPlayOutEntityHeadRotation.class, this::handleEntityId).register(PacketPlayOutEntityStatus.class, this::handleEntityId).register(PacketPlayOutEntityVelocity.class, this::handleEntityMotion).register(PacketPlayOutEntityTeleport.class, this::handleTeleportEntity).register(PacketPlayOutAnimation.class, this::handleAnimate).register(PacketPlayOutEntityMetadata.class, this::handleEntityData).register(PacketPlayOutEntityEquipment.class, this::handleSetEquipment).register(PacketPlayOutRemoveEntityEffect.class, this::handleEntityId).register(PacketPlayOutEntityEffect.class, this::handleUpdateMobEffect).registerPost(PacketPlayOutSpawnEntity.class, this::handleAddEntityPost).registerPost(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayerPost);
        this.readInterceptors = new PacketInterceptor();
        this.readInterceptors.register(PacketPlayInUseEntity.class, this::handleInteract).register(PacketPlayInSteerVehicle.class, this::handlePlayerInput);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ProtectedPacket) {
            ProtectedPacket protectedPacket = (ProtectedPacket)msg;
            super.write(ctx, protectedPacket.packet(), promise);
            return;
        }
        if (!(msg instanceof Packet)) {
            super.write(ctx, msg, promise);
            return;
        }
        ClientboundBundlePacket packet = (ClientboundBundlePacket)msg;
        try {
            if (packet instanceof ClientboundBundlePacket) {
                ClientboundBundlePacket bundle = packet;
                ArrayList<Packet<PacketListenerPlayOut>> list = new ArrayList<Packet<PacketListenerPlayOut>>();
                for (Packet subPacket : bundle.a()) {
                    Packet<PacketListenerPlayOut> result = this.writeInterceptors.accept((Packet<PacketListenerPlayOut>)subPacket);
                    if (result == null) continue;
                    list.add(result);
                    list.addAll(this.writeInterceptors.acceptPost(result));
                }
                packet = new ClientboundBundlePacket(list);
                super.write(ctx, (Object)packet, promise);
            } else {
                if ((packet = this.writeInterceptors.accept((Packet<PacketListenerPlayOut>)packet)) == null) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(packet);
                list.addAll(this.writeInterceptors.acceptPost((Packet<PacketListenerPlayOut>)packet));
                if (list.size() == 1) {
                    super.write(ctx, (Object)packet, promise);
                } else {
                    packet = new ClientboundBundlePacket(list);
                    super.write(ctx, (Object)packet, promise);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (!(msg instanceof Packet)) {
            super.channelRead(ctx, msg);
            return;
        }
        Packet<PacketListenerPlayIn> packet = this.readInterceptors.accept((Packet<PacketListenerPlayIn>)((Packet)msg));
        if (packet == null) {
            return;
        }
        super.channelRead(ctx, packet);
        this.readInterceptors.acceptPost(packet);
    }

    private PacketPlayOutSpawnEntity handleAddEntity(PacketPlayOutSpawnEntity packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private PacketPlayOutNamedEntitySpawn handleAddPlayer(PacketPlayOutNamedEntitySpawn packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private List<Packet<PacketListenerPlayOut>> handleAddEntityPost(PacketPlayOutSpawnEntity packet) {
        return this.handleMount(packet.c());
    }

    private List<Packet<PacketListenerPlayOut>> handleAddPlayerPost(PacketPlayOutNamedEntitySpawn packet) {
        return this.handleMount(packet.c());
    }

    private List<Packet<PacketListenerPlayOut>> handleMount(UUID uuid) {
        Pair<ActiveModel, MountController> pair = ModelEngineAPI.getMountPairManager().get(uuid);
        if (pair == null) {
            return null;
        }
        ActiveModel model = (ActiveModel)pair.left();
        ArrayList<Packet<PacketListenerPlayOut>> list = new ArrayList<Packet<PacketListenerPlayOut>>();
        model.getBehaviorRenderer(BoneBehaviorTypes.MOUNT).ifPresent(behaviorRenderer -> {
            if (behaviorRenderer instanceof MountRenderer) {
                MountRenderer renderer = (MountRenderer)behaviorRenderer;
                MountController controller = (MountController)pair.right();
                Mount patt6682$temp = controller.getMount();
                if (patt6682$temp instanceof BoneBehavior) {
                    BoneBehavior behavior = (BoneBehavior)((Object)patt6682$temp);
                    MountRenderer.Mount mount = (MountRenderer.Mount)renderer.getRendered().get(behavior.getBone().getBoneId());
                    CollectionDataTracker<Integer> ids = mount.getPassengers();
                    PacketDataSerializer buf = NetworkUtils.createByteBuf();
                    buf.d(mount.getMountId());
                    buf.d(ids.size());
                    ids.forEach(arg_0 -> ((PacketDataSerializer)buf).d(arg_0));
                    list.add((Packet<PacketListenerPlayOut>)new PacketPlayOutMount(buf));
                }
            }
        });
        return list;
    }

    private PacketPlayOutEntityDestroy handleRemoveEntities(PacketPlayOutEntityDestroy packet) {
        int id;
        PacketDataSerializer buf = NetworkUtils.readData(packet);
        int size = buf.m();
        HashSet<Integer> set = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            id = buf.m();
            if (!this.shouldShow(id)) continue;
            set.add(id);
        }
        if (set.size() == size) {
            return packet;
        }
        buf = NetworkUtils.createByteBuf();
        buf.d(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            buf.d(id);
        }
        return new PacketPlayOutEntityDestroy(buf);
    }

    private <U extends PacketListener, T extends Packet<U>> Packet<U> handleEntityId(T packet) {
        PacketDataSerializer buf = NetworkUtils.readData(packet);
        int id = buf.m();
        return this.shouldShow(id) ? packet : null;
    }

    private PacketPlayOutEntityVelocity handleEntityMotion(PacketPlayOutEntityVelocity packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private PacketPlayOutEntityTeleport handleTeleportEntity(PacketPlayOutEntityTeleport packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private PacketPlayOutAnimation handleAnimate(PacketPlayOutAnimation packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private PacketPlayOutEntityMetadata handleEntityData(PacketPlayOutEntityMetadata packet) {
        if (!this.shouldShow(packet.a())) {
            return null;
        }
        if (packet.a() != this.player.getEntityId()) {
            return packet;
        }
        if (this.entityHandler.isForcedInvisible(this.player)) {
            PacketDataSerializer buf = NetworkUtils.createByteBuf();
            buf.d(packet.a());
            for (DataWatcher.b item : packet.c()) {
                if (item.a() == 0) {
                    byte data = (Byte)item.c();
                    data = TMath.setBit(data, 5, true);
                    EntityUtils.writeData(buf, 0, DataWatcherRegistry.a, data);
                    continue;
                }
                EntityUtils.writeDataUnsafe(buf, item.a(), item.b(), item.c());
            }
            buf.writeByte(255);
            packet = new PacketPlayOutEntityMetadata(buf);
        }
        return packet;
    }

    private PacketPlayOutEntityEquipment handleSetEquipment(PacketPlayOutEntityEquipment packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private PacketPlayOutEntityEffect handleUpdateMobEffect(PacketPlayOutEntityEffect packet) {
        return this.shouldShow(packet.a()) ? packet : null;
    }

    private boolean shouldShow(int id) {
        if (ModelEngineAPI.isRenderCanceled(id)) {
            return false;
        }
        ModeledEntity entity = this.updater.getModeledEntity(id);
        return entity == null || entity.isBaseEntityVisible();
    }

    private PacketPlayInUseEntity handleInteract(PacketPlayInUseEntity packet) {
        DynamicHitbox hitbox;
        PacketDataSerializer buf = NetworkUtils.readData(packet);
        int entityId = buf.m();
        if (entityId == DynamicHitbox.getHitboxId() && (hitbox = ModelEngineAPI.getInteractionTracker().getDynamicHitbox(this.player.getUniqueId())) != null) {
            return new ServerboundInteractPacketWrapper(entityId, hitbox.getTarget(), packet);
        }
        ActiveModel activeModel = ModelEngineAPI.getInteractionTracker().getModelRelay(entityId);
        if (activeModel != null) {
            ModeledEntity modeledEntity = activeModel.getModeledEntity();
            if (modeledEntity == null) {
                return packet;
            }
            int id = modeledEntity.getBase().getEntityId();
            return new ServerboundInteractPacketWrapper(entityId, id, packet);
        }
        Integer relayed = ModelEngineAPI.getInteractionTracker().getEntityRelay(entityId);
        if (relayed != null) {
            return new ServerboundInteractPacketWrapper(entityId, relayed, packet);
        }
        return packet;
    }

    private PacketPlayInSteerVehicle handlePlayerInput(PacketPlayInSteerVehicle inputPacket) {
        MountController controller = ModelEngineAPI.getMountPairManager().getController(this.player.getUniqueId());
        if (controller != null) {
            MountController.MountInput input = controller.getInput();
            if (input == null) {
                controller.setInput(new MountController.MountInput(inputPacket.a(), inputPacket.c(), inputPacket.d(), inputPacket.e()));
            } else {
                input.setSide(inputPacket.a());
                input.setFront(inputPacket.c());
                input.setJump(inputPacket.d());
                input.setSneak(inputPacket.e());
            }
        }
        return inputPacket;
    }
}

