/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib;

import bsh.EvalError;
import bsh.Interpreter;
import io.lumine.mythic.lib.api.crafting.recipes.MythicCraftingManager;
import io.lumine.mythic.lib.api.crafting.recipes.vmp.MegaWorkbenchMapping;
import io.lumine.mythic.lib.api.crafting.recipes.vmp.SuperWorkbenchMapping;
import io.lumine.mythic.lib.api.crafting.uifilters.MythicItemUIFilter;
import io.lumine.mythic.lib.api.event.armorequip.ArmorEquipEvent;
import io.lumine.mythic.lib.api.placeholders.MythicPlaceholders;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.command.ExploreAttributesCommand;
import io.lumine.mythic.lib.command.HealthScaleCommand;
import io.lumine.mythic.lib.command.MMOTempStatCommand;
import io.lumine.mythic.lib.command.mythiclib.MythicLibCommand;
import io.lumine.mythic.lib.comp.McMMOAttackHandler;
import io.lumine.mythic.lib.comp.SkillAPIAttackHandler;
import io.lumine.mythic.lib.comp.adventure.AdventureParser;
import io.lumine.mythic.lib.comp.anticheat.AntiCheatSupport;
import io.lumine.mythic.lib.comp.anticheat.SpartanPlugin;
import io.lumine.mythic.lib.comp.dualwield.DualWieldHook;
import io.lumine.mythic.lib.comp.dualwield.RealDualWieldHook;
import io.lumine.mythic.lib.comp.flags.FlagHandler;
import io.lumine.mythic.lib.comp.flags.FlagPlugin;
import io.lumine.mythic.lib.comp.flags.ResidenceFlags;
import io.lumine.mythic.lib.comp.flags.WorldGuardFlags;
import io.lumine.mythic.lib.comp.mythicmobs.MythicMobsAttackHandler;
import io.lumine.mythic.lib.comp.mythicmobs.MythicMobsHook;
import io.lumine.mythic.lib.comp.placeholder.DefaultPlaceholderParser;
import io.lumine.mythic.lib.comp.placeholder.MythicPlaceholderAPIHook;
import io.lumine.mythic.lib.comp.placeholder.PlaceholderAPIHook;
import io.lumine.mythic.lib.comp.placeholder.PlaceholderAPIParser;
import io.lumine.mythic.lib.comp.placeholder.PlaceholderParser;
import io.lumine.mythic.lib.comp.protocollib.DamageParticleCap;
import io.lumine.mythic.lib.glow.GlowModule;
import io.lumine.mythic.lib.glow.provided.MythicGlowModule;
import io.lumine.mythic.lib.gson.Gson;
import io.lumine.mythic.lib.gui.PluginInventory;
import io.lumine.mythic.lib.hologram.HologramFactory;
import io.lumine.mythic.lib.hologram.HologramFactoryList;
import io.lumine.mythic.lib.hologram.factory.BukkitHologramFactory;
import io.lumine.mythic.lib.listener.AttackEffects;
import io.lumine.mythic.lib.listener.DamageReduction;
import io.lumine.mythic.lib.listener.ElementalDamage;
import io.lumine.mythic.lib.listener.MitigationMechanics;
import io.lumine.mythic.lib.listener.PlayerListener;
import io.lumine.mythic.lib.listener.PvpListener;
import io.lumine.mythic.lib.listener.SkillTriggers;
import io.lumine.mythic.lib.listener.event.AttackEventListener;
import io.lumine.mythic.lib.listener.option.FixMovementSpeed;
import io.lumine.mythic.lib.listener.option.HealthScale;
import io.lumine.mythic.lib.manager.ConfigManager;
import io.lumine.mythic.lib.manager.DamageManager;
import io.lumine.mythic.lib.manager.ElementManager;
import io.lumine.mythic.lib.manager.EntityManager;
import io.lumine.mythic.lib.manager.IndicatorManager;
import io.lumine.mythic.lib.manager.JsonManager;
import io.lumine.mythic.lib.manager.ModifierManager;
import io.lumine.mythic.lib.manager.SkillManager;
import io.lumine.mythic.lib.manager.StatManager;
import io.lumine.mythic.lib.metrics.bukkit.Metrics;
import io.lumine.mythic.lib.util.loadingorder.DependencyCycleCheck;
import io.lumine.mythic.lib.util.loadingorder.DependencyNode;
import io.lumine.mythic.lib.version.ServerVersion;
import io.lumine.mythic.lib.version.SpigotPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class MythicLib
extends JavaPlugin {
    public static MythicLib plugin;
    private final DamageManager damageManager = new DamageManager();
    private final EntityManager entityManager = new EntityManager();
    private final StatManager statManager = new StatManager();
    private final JsonManager jsonManager = new JsonManager();
    private final ConfigManager configManager = new ConfigManager();
    private final ElementManager elementManager = new ElementManager();
    private final SkillManager skillManager = new SkillManager();
    private final ModifierManager modifierManager = new ModifierManager();
    private final FlagHandler flagHandler = new FlagHandler();
    private final IndicatorManager indicatorManager = new IndicatorManager();
    private final Gson gson = new Gson();
    private Interpreter interpreter;
    private AntiCheatSupport antiCheatSupport;
    private ServerVersion version;
    private AttackEffects attackEffects;
    private MitigationMechanics mitigationMechanics;
    private AdventureParser adventureParser;
    private PlaceholderParser placeholderParser;
    private GlowModule glowModule;

    public void onLoad() {
        plugin = this;
        try {
            this.version = new ServerVersion(Bukkit.getServer().getClass());
            this.getLogger().log(Level.INFO, "Detected Bukkit Version: " + this.version.toString());
        }
        catch (Exception exception) {
            this.getLogger().log(Level.INFO, ChatColor.RED + "Your server version is not compatible.");
            exception.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.flagHandler.registerPlugin(new WorldGuardFlags());
            this.getLogger().log(Level.INFO, "Hooked onto WorldGuard");
        }
        this.adventureParser = new AdventureParser();
    }

    public void onEnable() {
        Stack<DependencyNode> dependencyCycle;
        new Metrics((Plugin)this);
        new SpigotPlugin(90306, this).checkForUpdate();
        this.saveDefaultConfig();
        int configVersion = this.getConfig().contains("config-version", true) ? this.getConfig().getInt("config-version") : -1;
        int defConfigVersion = this.getConfig().getDefaults().getInt("config-version");
        if (configVersion != defConfigVersion) {
            this.getLogger().warning("You may be using an outdated config.yml!");
            this.getLogger().warning("(Your config version: '" + configVersion + "' | Expected config version: '" + defConfigVersion + "')");
        }
        this.interpreter = new Interpreter();
        try {
            this.interpreter.eval("import java.lang.Math;");
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
        Bukkit.getServicesManager().register(HologramFactory.class, (Object)new BukkitHologramFactory(), (Plugin)this, ServicePriority.Low);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.damageManager, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new DamageReduction(), (Plugin)this);
        this.attackEffects = new AttackEffects();
        Bukkit.getPluginManager().registerEvents((Listener)this.attackEffects, (Plugin)this);
        this.mitigationMechanics = new MitigationMechanics();
        Bukkit.getPluginManager().registerEvents((Listener)this.mitigationMechanics, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AttackEventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MythicCraftingManager(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SkillTriggers(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ElementalDamage(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PvpListener(), (Plugin)this);
        ArmorEquipEvent.registerListener(this);
        if (this.getConfig().getBoolean("health-scale.enabled")) {
            Bukkit.getPluginManager().registerEvents((Listener)new HealthScale(this.getConfig().getDouble("health-scale.scale"), this.getConfig().getInt("health-scale.delay", 0)), (Plugin)this);
        }
        if (this.getConfig().getBoolean("fix-movement-speed")) {
            Bukkit.getPluginManager().registerEvents((Listener)new FixMovementSpeed(), (Plugin)this);
        }
        for (HologramFactoryList custom : HologramFactoryList.values()) {
            if (!custom.isInstalled(this.getServer().getPluginManager())) continue;
            try {
                Bukkit.getServicesManager().register(HologramFactory.class, (Object)custom.generateFactory(), (Plugin)this, custom.getServicePriority());
                this.getLogger().log(Level.INFO, "Hooked onto " + custom.getPluginName());
            }
            catch (Exception exception) {
                this.getLogger().log(Level.WARNING, "Could not hook onto " + custom.getPluginName() + ": " + exception.getMessage());
            }
        }
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            this.damageManager.registerHandler(new MythicMobsAttackHandler());
            Bukkit.getPluginManager().registerEvents((Listener)new MythicMobsHook(), (Plugin)this);
            MythicItemUIFilter.register();
            this.getLogger().log(Level.INFO, "Hooked onto MythicMobs");
        }
        if (Bukkit.getPluginManager().getPlugin("Residence") != null) {
            this.flagHandler.registerPlugin(new ResidenceFlags());
            this.getLogger().log(Level.INFO, "Hooked onto Residence");
        }
        if (Bukkit.getPluginManager().getPlugin("Spartan") != null) {
            this.antiCheatSupport = new SpartanPlugin();
            this.getLogger().log(Level.INFO, "Hooked onto Spartan");
        }
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
            if (this.getConfig().getBoolean("damage-particles-cap.enabled")) {
                new DamageParticleCap(this.getConfig().getInt("damage-particles-cap.max-per-tick"));
            }
            this.getLogger().log(Level.INFO, "Hooked onto ProtocolLib");
        }
        if (Bukkit.getPluginManager().getPlugin("mcMMO") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new McMMOAttackHandler(), (Plugin)this);
            this.getLogger().log(Level.INFO, "Hooked onto mcMMO");
        }
        if (Bukkit.getPluginManager().getPlugin("SkillAPI") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new SkillAPIAttackHandler(), (Plugin)this);
            this.getLogger().log(Level.INFO, "Hooked onto SkillAPI");
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            MythicPlaceholders.registerPlaceholder(new MythicPlaceholderAPIHook());
            new PlaceholderAPIHook().register();
            this.placeholderParser = new PlaceholderAPIParser();
            this.getLogger().log(Level.INFO, "Hooked onto PlaceholderAPI");
        } else {
            this.placeholderParser = new DefaultPlaceholderParser();
        }
        if (Bukkit.getPluginManager().getPlugin("RealDualWield") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new RealDualWieldHook(), (Plugin)this);
            this.getLogger().log(Level.INFO, "Hooked onto RealDualWield");
        }
        if (Bukkit.getPluginManager().getPlugin("DualWield") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)new DualWieldHook(), (Plugin)this);
            this.getLogger().log(Level.INFO, "Hooked onto DualWield");
        }
        if ((dependencyCycle = new DependencyCycleCheck().checkCycle()) != null) {
            this.getLogger().log(Level.WARNING, "Found a dependency cycle! Please make sure that the plugins involved load with no errors.");
            this.getLogger().log(Level.WARNING, "Plugin dependency cycle: " + dependencyCycle);
        }
        this.indicatorManager.load(this.getConfig());
        if (this.glowModule == null) {
            this.glowModule = new MythicGlowModule();
            this.glowModule.enable();
        }
        this.getCommand("exploreattributes").setExecutor((CommandExecutor)new ExploreAttributesCommand());
        this.getCommand("mythiclib").setExecutor((CommandExecutor)new MythicLibCommand());
        this.getCommand("mmotempstat").setExecutor((CommandExecutor)new MMOTempStatCommand());
        this.getCommand("healthscale").setExecutor((CommandExecutor)new HealthScaleCommand());
        this.getCommand("superworkbench").setExecutor((CommandExecutor)SuperWorkbenchMapping.SWB);
        Bukkit.getPluginManager().registerEvents((Listener)SuperWorkbenchMapping.SWB, (Plugin)this);
        this.getCommand("megaworkbench").setExecutor((CommandExecutor)MegaWorkbenchMapping.MWB);
        Bukkit.getPluginManager().registerEvents((Listener)MegaWorkbenchMapping.MWB, (Plugin)this);
        this.skillManager.initialize(false);
        this.elementManager.reload(false);
        Bukkit.getOnlinePlayers().forEach(player -> MMOPlayerData.setup(player));
        Bukkit.getScheduler().runTaskTimer((Plugin)this, MMOPlayerData::flushOfflinePlayerData, 72000L, 72000L);
        this.configManager.reload();
        this.statManager.initialize(false);
    }

    public void reload() {
        this.reloadConfig();
        this.statManager.initialize(true);
        this.attackEffects.reload();
        this.mitigationMechanics.reload();
        this.skillManager.initialize(true);
        this.configManager.reload();
        this.elementManager.reload(true);
        this.indicatorManager.reload(this.getConfig());
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getOpenInventory() == null || player.getOpenInventory().getTopInventory().getHolder() == null || !(player.getOpenInventory().getTopInventory().getHolder() instanceof PluginInventory)) continue;
            player.closeInventory();
        }
        this.glowModule.disable();
    }

    public static MythicLib inst() {
        return plugin;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    @Deprecated
    public JsonManager getJson() {
        return this.jsonManager;
    }

    public DamageManager getDamage() {
        return this.damageManager;
    }

    public EntityManager getEntities() {
        return this.entityManager;
    }

    public SkillManager getSkills() {
        return this.skillManager;
    }

    public ModifierManager getModifiers() {
        return this.modifierManager;
    }

    public ElementManager getElements() {
        return this.elementManager;
    }

    public StatManager getStats() {
        return this.statManager;
    }

    public ConfigManager getMMOConfig() {
        return this.configManager;
    }

    public FlagHandler getFlags() {
        return this.flagHandler;
    }

    public PlaceholderParser getPlaceholderParser() {
        return this.placeholderParser;
    }

    public AttackEffects getAttackEffects() {
        return this.attackEffects;
    }

    public AntiCheatSupport getAntiCheat() {
        return this.antiCheatSupport;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Nullable
    public GlowModule getGlowing() {
        return this.glowModule;
    }

    @Deprecated
    public void handleFlags(FlagPlugin flagPlugin) {
        this.getFlags().registerPlugin(flagPlugin);
    }

    public boolean hasAntiCheat() {
        return this.antiCheatSupport != null;
    }

    public String parseColors(String format) {
        return this.adventureParser.parse(format);
    }

    public List<String> parseColors(String ... format) {
        return this.parseColors(Arrays.asList(format));
    }

    public List<String> parseColors(List<String> format) {
        return new ArrayList<String>(this.adventureParser.parse(format));
    }

    public AdventureParser getAdventureParser() {
        return this.adventureParser;
    }

    public File getJarFile() {
        return plugin.getFile();
    }
}

