/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.ingredients;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapelessItem;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.ui.FFPMythicLib;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapelessRequester {
    final int requestIdentifier;
    boolean fulfilled = false;
    @NotNull
    final MythicIngredient ingredient;
    @NotNull
    final HashMap<Integer, ShapelessItem> dibbed = new HashMap();
    @NotNull
    final HashMap<Integer, ProvidedUIFilter> matched = new HashMap();
    @NotNull
    ArrayList<Integer> dibAmountOrder = new ArrayList();

    public ShapelessRequester(int id, @NotNull MythicIngredient ingredient) {
        this.requestIdentifier = id;
        this.ingredient = ingredient;
    }

    public int getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public boolean isFulfilled() {
        return this.fulfilled;
    }

    @NotNull
    public MythicIngredient getIngredient() {
        return this.ingredient;
    }

    @NotNull
    public HashMap<Integer, ShapelessItem> getDibbed() {
        return this.dibbed;
    }

    @Nullable
    public ShapelessItem getDibbed(int id) {
        return this.dibbed.get(id);
    }

    @NotNull
    public HashMap<Integer, ProvidedUIFilter> getMatched() {
        return this.matched;
    }

    @Nullable
    public ProvidedUIFilter getMatched(int id) {
        return this.matched.get(id);
    }

    public void dib(@NotNull ShapelessItem item, @NotNull ProvidedUIFilter filter) {
        item.claimDibs(this);
        this.dibbed.put(item.getOperationalIdentifier(), item);
        this.matched.put(item.getOperationalIdentifier(), filter);
        boolean reg = false;
        for (int i = 0; i < this.dibAmountOrder.size(); ++i) {
            Integer p = this.dibAmountOrder.get(i);
            ProvidedUIFilter dib = this.getMatched(p);
            if (dib == null || filter.getAmount(0) > dib.getAmount(0)) continue;
            this.dibAmountOrder.add(i, item.getOperationalIdentifier());
            reg = true;
            break;
        }
        if (!reg) {
            this.dibAmountOrder.add(item.getOperationalIdentifier());
        }
    }

    public boolean firstClaim() {
        ProvidedUIFilter filter;
        ShapelessItem item;
        for (Integer dib : this.dibAmountOrder) {
            item = this.getDibbed(dib);
            filter = this.getMatched(dib);
            Validate.isTrue((filter != null && item != null ? 1 : 0) != 0, (String)"Mismatch occurred between the order in which shapeless items are evaluated. ");
            if (item.getRequesters().size() != 1) continue;
            if (item.getAmount() < filter.getAmount(0)) {
                return false;
            }
            this.fulfilled = true;
            item.take(filter.getAmount(0));
            return true;
        }
        for (Integer dib : this.dibAmountOrder) {
            item = this.getDibbed(dib);
            filter = this.getMatched(dib);
            Validate.isTrue((filter != null && item != null ? 1 : 0) != 0, (String)"Mismatch occurred between the order in which shapeless items are evaluated. ");
            if (item.getAmount() < filter.getAmount(0)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ArrayList<ArrayList<ShapelessItem>> secondClaim(@NotNull ArrayList<ShapelessItem> originalPool) {
        ArrayList<ShapelessItem> relevantPool = new ArrayList<ShapelessItem>();
        for (ShapelessItem item : originalPool) {
            if (item.getRequesters().size() > 1) {
                relevantPool.add(item);
                continue;
            }
            if (item.getRequesters().size() != 0) continue;
            MythicLib.plugin.getLogger().log(Level.WARNING, FriendlyFeedbackProvider.quickForConsole(FFPMythicLib.get(), "Undibbed item has bypassed onto the $rsecondClaim$b area: $u{0}$b. $fThis should be impossible, contact Gunging.", SilentNumbers.getItemName(item.getStack())));
        }
        ArrayList<ArrayList<ShapelessItem>> ret = new ArrayList<ArrayList<ShapelessItem>>();
        for (ShapelessItem path : this.getDibbed().values()) {
            ArrayList<ShapelessItem> pathPool = ShapelessItem.deepCloneList(relevantPool);
            boolean success = false;
            for (ShapelessItem observed : pathPool) {
                if (path.getOperationalIdentifier() != observed.getOperationalIdentifier()) continue;
                ProvidedUIFilter filter = this.getMatched(path.getOperationalIdentifier());
                Validate.isTrue((filter != null ? 1 : 0) != 0, (String)"Fatal Error when evaluating Second Claim of Shapeless Recipe: Actually found matching ShapelessItem, but the filter was lost somehow.");
                if (observed.getAmount() < filter.getAmount(0)) continue;
                observed.take(filter.getAmount(0));
                success = true;
                break;
            }
            if (!success) continue;
            ret.add(pathPool);
        }
        return ret;
    }
}

