/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.Closeable;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class StatInstance {
    private final StatMap map;
    private final String stat;
    private final Map<String, StatModifier> modifiers = new ConcurrentHashMap<String, StatModifier>();

    public StatInstance(StatMap map, String stat) {
        this.map = map;
        this.stat = stat;
    }

    public StatMap getMap() {
        return this.map;
    }

    public String getStat() {
        return this.stat;
    }

    public double getBase() {
        return MythicLib.inst().getStats().getBaseValue(this.stat, this.map);
    }

    public double getTotal() {
        return this.getFilteredTotal(EquipmentSlot.MAIN_HAND::isCompatible);
    }

    public double getFilteredTotal(Predicate<StatModifier> filter) {
        return this.getFilteredTotal(filter, mod -> mod);
    }

    public double getTotal(Function<StatModifier, StatModifier> modification) {
        return this.getFilteredTotal(EquipmentSlot.MAIN_HAND::isCompatible, modification);
    }

    public double getFilteredTotal(Predicate<StatModifier> filter, Function<StatModifier, StatModifier> modification) {
        double d = this.getBase();
        for (StatModifier attr : this.modifiers.values()) {
            if (attr.getType() != ModifierType.FLAT || !filter.test(attr)) continue;
            d += modification.apply(attr).getValue();
        }
        for (StatModifier attr : this.modifiers.values()) {
            if (attr.getType() != ModifierType.RELATIVE || !filter.test(attr)) continue;
            d *= 1.0 + modification.apply(attr).getValue() / 100.0;
        }
        return d;
    }

    @Nullable
    public StatModifier getModifier(String key) {
        return this.modifiers.get(key);
    }

    public void addModifier(StatModifier modifier) {
        ModifierPacket packet = new ModifierPacket();
        packet.addModifier(modifier);
        packet.runUpdate();
    }

    public Collection<StatModifier> getModifiers() {
        return this.modifiers.values();
    }

    public Set<String> getKeys() {
        return this.modifiers.keySet();
    }

    public void removeIf(Predicate<String> condition) {
        ModifierPacket packet = new ModifierPacket();
        packet.removeIf(condition);
        packet.runUpdate();
    }

    public boolean contains(String key) {
        return this.modifiers.containsKey(key);
    }

    public void remove(String key) {
        ModifierPacket packet = new ModifierPacket();
        packet.remove(key);
        packet.runUpdate();
    }

    public ModifierPacket newPacket() {
        return new ModifierPacket();
    }

    public class ModifierPacket {
        private boolean updateRequired;

        public void addModifier(StatModifier modifier) {
            StatModifier current = StatInstance.this.modifiers.put(modifier.getKey(), modifier);
            if (current != null && current instanceof Closeable) {
                ((Closeable)((Object)current)).close();
            }
            this.updateRequired = true;
        }

        public void remove(String key) {
            StatModifier mod = (StatModifier)StatInstance.this.modifiers.remove(key);
            if (mod == null) {
                return;
            }
            if (mod instanceof Closeable) {
                ((Closeable)((Object)mod)).close();
            }
            this.updateRequired = true;
        }

        public void removeIf(Predicate<String> condition) {
            Iterator iterator = StatInstance.this.modifiers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!condition.test((String)entry.getKey())) continue;
                StatModifier modifier = (StatModifier)entry.getValue();
                if (modifier instanceof Closeable) {
                    ((Closeable)((Object)modifier)).close();
                }
                iterator.remove();
                this.updateRequired = true;
            }
        }

        public void runUpdate() {
            if (this.updateRequired) {
                MythicLib.plugin.getStats().runUpdate(StatInstance.this.map, StatInstance.this.stat);
            }
        }
    }
}

