/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.provider.StatProvider;
import io.lumine.mythic.lib.player.PlayerMetadata;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class StatMap
implements StatProvider {
    private final MMOPlayerData data;
    private final Map<String, StatInstance> stats = new ConcurrentHashMap<String, StatInstance>();

    public StatMap(MMOPlayerData player) {
        this.data = player;
    }

    public MMOPlayerData getPlayerData() {
        return this.data;
    }

    @Override
    public double getStat(String stat) {
        return this.getInstance(stat).getTotal();
    }

    @NotNull
    public StatInstance getInstance(String id) {
        return this.stats.computeIfAbsent(id, stat -> new StatInstance(this, (String)stat));
    }

    public Collection<StatInstance> getInstances() {
        return this.stats.values();
    }

    @Deprecated
    public void updateAll() {
        MythicLib.plugin.getStats().runUpdates(this);
    }

    @Deprecated
    public void update(String stat) {
        MythicLib.plugin.getStats().runUpdate(this, stat);
    }

    public PlayerMetadata cache(EquipmentSlot castHand) {
        return new PlayerMetadata(this, castHand);
    }
}

