/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.stat.handler;

import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.handler.StatHandler;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;

public class MovementSpeedStatHandler
implements StatHandler {
    private final boolean moveSpeed;

    public MovementSpeedStatHandler(boolean moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    @Override
    public void runUpdate(StatMap stats) {
        AttributeInstance attrIns = stats.getPlayerData().getPlayer().getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        this.removeModifiers(attrIns);
        double coef = 1.0 - Math.min(0.8, Math.max(0.0, stats.getInstance("SPEED_MALUS_REDUCTION").getTotal() / 100.0));
        StatInstance statIns = stats.getInstance("MOVEMENT_SPEED");
        double mmo = statIns.getFilteredTotal(mod -> !mod.getSource().isWeapon() || mod.getSlot() != EquipmentSlot.OFF_HAND, mod -> mod.getValue() < 0.0 ? mod.multiply(coef) : mod);
        double base = stats.getPlayerData().getPlayer().getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue();
        if (mmo != base) {
            attrIns.addModifier(new AttributeModifier("mythiclib.main", mmo - base, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    @Override
    public double getTotalValue(StatMap map) {
        return this.moveSpeed ? map.getPlayerData().getPlayer().getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getValue() : map.getStat("SPEED_MALUS_REDUCTION");
    }

    @Override
    public double getBaseValue(StatMap map) {
        return this.moveSpeed ? map.getPlayerData().getPlayer().getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue() : 0.0;
    }
}

