/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.util;

import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostLoadObject {
    @Nullable
    private ConfigurationSection config;

    public PostLoadObject(@Nullable ConfigurationSection config) {
        this.config = config;
    }

    @NotNull
    public ConfigurationSection getPostLoadConfig() {
        return Objects.requireNonNull(this.config, "Object already post loaded");
    }

    public void postLoad() {
        Validate.notNull((Object)this.config, (String)"Object already post loaded");
        this.whenPostLoaded(this.config);
        this.config = null;
    }

    protected abstract void whenPostLoaded(@NotNull ConfigurationSection var1);
}

