/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.command.api;

import io.lumine.mythic.lib.command.api.CommandTreeExplorer;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;

public class Parameter {
    private final String key;
    private final BiConsumer<CommandTreeExplorer, List<String>> autoComplete;
    public static final Parameter PLAYER = new Parameter("<player>", (explorer, list) -> Bukkit.getOnlinePlayers().forEach(online -> list.add(online.getName())));
    public static final Parameter PLAYER_OPTIONAL = new Parameter("(player)", (explorer, list) -> Bukkit.getOnlinePlayers().forEach(online -> list.add(online.getName())));
    public static final Parameter AMOUNT = new Parameter("<amount>", (explorer, list) -> {
        for (int j = 0; j <= 10; ++j) {
            list.add("" + j);
        }
    });
    public static final Parameter AMOUNT_OPTIONAL = new Parameter("(amount)", (explorer, list) -> {
        for (int j = 0; j <= 10; ++j) {
            list.add("" + j);
        }
    });

    public Parameter(String key, BiConsumer<CommandTreeExplorer, List<String>> autoComplete) {
        this.key = key;
        this.autoComplete = autoComplete;
    }

    public String getKey() {
        return this.key;
    }

    public void autoComplete(CommandTreeExplorer explorer, List<String> list) {
        this.autoComplete.accept(explorer, list);
    }
}

