/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.adventure.gradient;

@FunctionalInterface
public interface Interpolator {
    public static final Interpolator LINEAR = (from, to, max) -> {
        double[] res = new double[max];
        for (int i = 0; i < max; ++i) {
            res[i] = from + (double)i * ((to - from) / (double)(max - 1));
        }
        return res;
    };
    public static final Interpolator QUADRATIC_SLOW_TO_FAST = (from, to, max) -> {
        double[] results = new double[max];
        double a = (to - from) / (double)(max * max);
        for (int i = 0; i < results.length; ++i) {
            results[i] = a * (double)i * (double)i + from;
        }
        return results;
    };
    public static final Interpolator QUADRATIC_FAST_TO_SLOW = (from, to, max) -> {
        double[] results = new double[max];
        double a = (from - to) / (double)(max * max);
        double b = -2.0 * a * (double)max;
        for (int i = 0; i < results.length; ++i) {
            results[i] = a * (double)i * (double)i + b * (double)i + from;
        }
        return results;
    };

    public double[] interpolate(double var1, double var3, int var5);
}

