/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.element;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.SimpleSkill;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Element {
    private final String id;
    private final String name;
    private final String loreIcon;
    private final String color;
    private final Material icon;
    private final SkillHandler<?> criticalStrike;
    private final SkillHandler<?> regularAttack;
    private static final String DEFAULT_LORE_ICON = "\u2756";
    private static final String DEFAULT_MATERIAL = "DIRT";
    private static final String DEFAULT_COLOR = "&f";

    public Element(ConfigurationSection config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        this.id = UtilityMethods.enumName(config.getName());
        this.icon = Material.valueOf((String)UtilityMethods.enumName(config.getString("icon", DEFAULT_MATERIAL)));
        this.name = Objects.requireNonNull(config.getString("name"), "Please specify an element name");
        this.loreIcon = config.getString("lore-icon", DEFAULT_LORE_ICON);
        this.color = config.getString("color", DEFAULT_COLOR);
        this.regularAttack = MythicLib.plugin.getSkills().loadSkillHandler(Objects.requireNonNull(config.get("regular-attack"), "Could not find skill for regular attacks"));
        this.criticalStrike = config.contains("crit-strike") ? MythicLib.plugin.getSkills().loadSkillHandler(config.get("crit-strike")) : null;
    }

    public String getId() {
        return UtilityMethods.enumName(this.id);
    }

    public String getName() {
        return this.name;
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getLoreIcon() {
        return this.loreIcon;
    }

    public String getColor() {
        return this.color;
    }

    @NotNull
    public Skill getSkill(boolean criticalStrike) {
        SkillHandler<?> handler = criticalStrike && this.criticalStrike != null ? this.criticalStrike : this.regularAttack;
        return new SimpleSkill(TriggerType.API, handler);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        return this.id.equals(element.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static Collection<Element> values() {
        return MythicLib.plugin.getElements().getAll();
    }

    @Nullable
    public static Element valueOf(String id) {
        return Objects.requireNonNull(MythicLib.plugin.getElements().get(id), "Could not find element with ID '" + id + "'");
    }
}

