/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.glow.provided;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.glow.GlowModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class MythicGlowModule
implements GlowModule {
    private final Map<ChatColor, Team> scoreboardTeams = new HashMap<ChatColor, Team>();
    private final NamespacedKey colorTagPath = new NamespacedKey((Plugin)MythicLib.plugin, "GlowColor");
    private int counter;

    @Override
    public void enable() {
        Scoreboard scoreboard = Bukkit.getServer().getScoreboardManager().getMainScoreboard();
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor()) continue;
            String teamName = this.getTeamName(color);
            Team team = Objects.requireNonNullElseGet(scoreboard.getTeam(teamName), () -> scoreboard.registerNewTeam(teamName));
            team.setColor(color);
            this.scoreboardTeams.put(color, team);
        }
    }

    private String getTeamName(ChatColor color) {
        Validate.isTrue((boolean)color.isColor(), (String)"Not a color");
        return "ml_glow_" + this.counter++;
    }

    @Override
    public void disable() {
        this.scoreboardTeams.forEach((color, team) -> team.unregister());
    }

    @Override
    public void setGlowing(Entity entity, ChatColor color) {
        Validate.isTrue((boolean)color.isColor(), (String)"Not a color");
        this.scoreboardTeams.get(color).addEntry(entity.getUniqueId().toString());
        entity.getPersistentDataContainer().set(this.colorTagPath, PersistentDataType.STRING, (Object)color.name());
        entity.setGlowing(true);
    }

    @Override
    public void disableGlowing(Entity entity) {
        entity.getPersistentDataContainer().remove(this.colorTagPath);
        entity.setGlowing(false);
    }
}

