/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener.event;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.AttackEvent;
import io.lumine.mythic.lib.api.event.DamageCheckEvent;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.event.PlayerKillEntityEvent;
import io.lumine.mythic.lib.damage.AttackMetadata;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;

public class AttackEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void registerEvents(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof LivingEntity) || event instanceof DamageCheckEvent || event.getDamage() == 0.0) {
            return;
        }
        @NotNull AttackMetadata attack = MythicLib.plugin.getDamage().findAttack(event);
        if (attack.isPlayer() && attack.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        AttackEvent attackEvent = attack.isPlayer() ? new PlayerAttackEvent(event, attack) : new AttackEvent(event, attack);
        Bukkit.getPluginManager().callEvent((Event)attackEvent);
        if (attackEvent.isCancelled()) {
            return;
        }
        event.setDamage(attack.getDamage().getDamage());
        if (attack.isPlayer() && event.getFinalDamage() >= ((Damageable)event.getEntity()).getHealth()) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerKillEntityEvent(attack, (LivingEntity)event.getEntity()));
        }
    }
}

