/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.comp.interaction.relation.EmptyPvPInteractionRules;
import io.lumine.mythic.lib.comp.interaction.relation.InteractionRules;
import io.lumine.mythic.lib.skill.SimpleSkill;
import io.lumine.mythic.lib.skill.Skill;
import io.lumine.mythic.lib.skill.handler.MythicLibSkillHandler;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.annotation.Nullable;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    public final DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
    public DecimalFormat decimal;
    public DecimalFormat decimals;
    public boolean playerAbilityDamage;
    public boolean castingDelayCancelOnMove;
    public boolean enableCastingDelayBossbar;
    public boolean fixTooLargePackets;
    public boolean debugMode;
    public String naturalDefenseFormula;
    public String elementalDefenseFormula;
    public String castingDelayBossbarFormat;
    public double castingDelaySlowness;
    public int maxSyncTries;
    @NotNull
    public InteractionRules interactionRules;
    @Nullable
    public Skill skillCastScript;
    @Nullable
    public Skill skillCancelScript;

    public void reload() {
        FileConfiguration config = MythicLib.plugin.getConfig();
        this.formatSymbols.setDecimalSeparator(this.getFirstChar(config.getString("number-format.decimal-separator")));
        this.decimal = this.newDecimalFormat("0.#");
        this.decimals = this.newDecimalFormat("0.##");
        this.interactionRules = config.getBoolean("interaction_rules.enabled") ? new InteractionRules(config.getConfigurationSection("interaction_rules")) : new EmptyPvPInteractionRules();
        this.playerAbilityDamage = config.getBoolean("player-ability-damage");
        this.naturalDefenseFormula = config.getString("defense-application.natural");
        this.elementalDefenseFormula = config.getString("defense-application.elemental");
        this.fixTooLargePackets = config.getBoolean("fix-too-large-packets");
        this.debugMode = config.getBoolean("debug");
        this.maxSyncTries = config.getInt("max-sync-tries");
        this.castingDelaySlowness = config.getDouble("casting-delay.slowness");
        this.castingDelayCancelOnMove = config.getBoolean("casting-delay.cancel-on-move");
        this.enableCastingDelayBossbar = config.getBoolean("casting-delay.bossbar.enabled");
        this.castingDelayBossbarFormat = config.getString("casting-delay.bossbar.format");
        try {
            this.skillCastScript = config.getBoolean("casting-delay.cast-script.enabled") ? new SimpleSkill(TriggerType.CAST, new MythicLibSkillHandler(MythicLib.plugin.getSkills().loadScript(config.get("casting-delay.cast-script.script")))) : null;
        }
        catch (IllegalArgumentException exception) {
            this.skillCastScript = null;
        }
        try {
            this.skillCancelScript = config.getBoolean("casting-delay.cancel-script.enabled") ? new SimpleSkill(TriggerType.CAST, new MythicLibSkillHandler(MythicLib.plugin.getSkills().loadScript(config.get("casting-delay.cancel-script.script")))) : null;
        }
        catch (IllegalArgumentException exception) {
            this.skillCancelScript = null;
        }
    }

    public DecimalFormat newDecimalFormat(String pattern) {
        return new DecimalFormat(pattern, this.formatSymbols);
    }

    private char getFirstChar(String str) {
        return str == null || str.isEmpty() ? (char)'.' : str.charAt(0);
    }
}

