/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.stat.provider.StatProvider;
import io.lumine.mythic.lib.damage.AttackHandler;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.damage.MeleeAttackMetadata;
import io.lumine.mythic.lib.damage.ProjectileAttackMetadata;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.util.CustomProjectile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageManager
implements Listener {
    private final List<AttackHandler> handlers = new ArrayList<AttackHandler>();
    private final WeakHashMap<UUID, AttackMetadata> attackMetadatas = new WeakHashMap();
    private static final AttributeModifier NO_KNOCKBACK = new AttributeModifier(UUID.randomUUID(), "noKnockback", 100.0, AttributeModifier.Operation.ADD_NUMBER);

    public void registerHandler(AttackHandler handler) {
        Validate.notNull((Object)handler, (String)"Damage handler cannot be null");
        this.handlers.add(handler);
    }

    @Deprecated
    public void damage(@NotNull AttackMetadata metadata, @NotNull LivingEntity target) {
        this.damage(metadata, target, true);
    }

    public void registerAttack(@NotNull AttackMetadata metadata) {
        this.registerAttack(metadata, true, false);
    }

    @Deprecated
    public void damage(@NotNull AttackMetadata metadata, @NotNull LivingEntity target, boolean knockback) {
        this.damage(metadata, target, knockback, false);
    }

    public void registerAttack(@NotNull AttackMetadata metadata, boolean knockback) {
        this.registerAttack(metadata, knockback, false);
    }

    @Deprecated
    public void damage(@NotNull AttackMetadata metadata, @NotNull LivingEntity target, boolean knockback, boolean ignoreImmunity) {
        this.registerAttack(new AttackMetadata(metadata.getDamage(), target, metadata.getAttacker()), knockback, ignoreImmunity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAttack(@NotNull AttackMetadata attack, boolean knockback, boolean ignoreImmunity) {
        double damage = attack.getDamage().getDamage();
        if (damage <= 0.0) {
            return;
        }
        Validate.notNull((Object)attack.getTarget(), (String)"Target cannot be null");
        this.markAsMetadata(attack);
        try {
            this.applyDamage(attack.getDamage().getDamage(), attack.getTarget(), attack.isPlayer() ? ((PlayerMetadata)attack.getAttacker()).getPlayer() : null, knockback, ignoreImmunity);
        }
        catch (Exception exception) {
            MythicLib.plugin.getLogger().log(Level.SEVERE, "Caught an exception (1) while damaging entity '" + attack.getTarget().getUniqueId() + "':");
            exception.printStackTrace();
        }
        finally {
            this.unmarkAsMetadata(attack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDamage(double damage, @NotNull LivingEntity target, @Nullable Player damager, boolean knockback, boolean ignoreImmunity) {
        if (!knockback) {
            AttributeInstance instance = target.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
            try {
                instance.addModifier(NO_KNOCKBACK);
                this.applyDamage(damage, target, damager, true, ignoreImmunity);
            }
            catch (Exception anyError) {
                MythicLib.plugin.getLogger().log(Level.SEVERE, "Caught an exception (2) while damaging entity '" + target.getUniqueId() + "':");
                anyError.printStackTrace();
            }
            finally {
                instance.removeModifier(NO_KNOCKBACK);
            }
        } else if (ignoreImmunity) {
            int noDamageTicks = target.getNoDamageTicks();
            try {
                target.setNoDamageTicks(0);
                this.applyDamage(damage, target, damager, true, false);
            }
            catch (Exception anyError) {
                MythicLib.plugin.getLogger().log(Level.SEVERE, "Caught an exception (3) while damaging entity '" + target.getUniqueId() + "':");
                anyError.printStackTrace();
            }
            finally {
                target.setNoDamageTicks(noDamageTicks);
            }
        } else {
            Validate.isTrue((damage > 0.0 ? 1 : 0) != 0, (String)"Damage must be strictly positive");
            if (damager == null) {
                target.damage(damage);
            } else {
                target.damage(damage, (Entity)damager);
            }
        }
    }

    @Deprecated
    @NotNull
    public DamageMetadata findDamage(EntityDamageEvent event) {
        return this.findAttack(event).getDamage();
    }

    @NotNull
    public AttackMetadata findAttack(EntityDamageEvent event) {
        Validate.isTrue((boolean)(event.getEntity() instanceof LivingEntity), (String)"Target entity is not living");
        LivingEntity entity = (LivingEntity)event.getEntity();
        @Nullable AttackMetadata found = this.getRegisteredAttackMetadata((Entity)entity);
        if (found != null) {
            return found;
        }
        for (AttackHandler handler : this.handlers) {
            found = handler.getAttack(event);
            if (found == null) continue;
            this.markAsMetadata(found);
            return found;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
            if (damager instanceof LivingEntity) {
                StatProvider attacker = StatProvider.get((LivingEntity)damager, EquipmentSlot.MAIN_HAND, true);
                MeleeAttackMetadata attackMeta = new MeleeAttackMetadata(new DamageMetadata(event.getDamage(), this.getVanillaDamageTypes((EntityDamageByEntityEvent)event, EquipmentSlot.MAIN_HAND)), entity, attacker);
                this.markAsMetadata(attackMeta);
                return attackMeta;
            }
            if (damager instanceof Projectile) {
                Projectile projectile = (Projectile)damager;
                @Nullable CustomProjectile projectileData = CustomProjectile.getCustomData((Entity)projectile);
                if (projectileData != null) {
                    ProjectileAttackMetadata attackMeta = new ProjectileAttackMetadata(new DamageMetadata(event.getDamage(), DamageType.WEAPON, DamageType.PHYSICAL, DamageType.PROJECTILE), (LivingEntity)event.getEntity(), projectileData.getCaster(), projectile);
                    this.markAsMetadata(attackMeta);
                    return attackMeta;
                }
                ProjectileSource source = projectile.getShooter();
                if (source != null && !source.equals(event.getEntity()) && source instanceof LivingEntity) {
                    StatProvider attacker = StatProvider.get((LivingEntity)source, EquipmentSlot.MAIN_HAND, true);
                    ProjectileAttackMetadata attackMeta = new ProjectileAttackMetadata(new DamageMetadata(event.getDamage(), DamageType.WEAPON, DamageType.PHYSICAL, DamageType.PROJECTILE), (LivingEntity)event.getEntity(), attacker, projectile);
                    this.markAsMetadata(attackMeta);
                    return attackMeta;
                }
            }
        }
        @NotNull AttackMetadata vanillaAttack = new AttackMetadata(new DamageMetadata(event.getDamage(), this.getVanillaDamageTypes(event)), entity, null);
        this.markAsMetadata(vanillaAttack);
        return vanillaAttack;
    }

    public void markAsMetadata(AttackMetadata attackMeta) {
        @Nullable AttackMetadata found = this.attackMetadatas.put(attackMeta.getTarget().getUniqueId(), attackMeta);
        if (found != null) {
            MythicLib.plugin.getLogger().log(Level.WARNING, "Please report this issue to the developper: persistent attack metadata was found.");
        }
    }

    public void unmarkAsMetadata(AttackMetadata attackMeta) {
        this.attackMetadatas.remove(attackMeta.getTarget().getUniqueId());
    }

    @NotNull
    public DamageType[] getVanillaDamageTypes(EntityDamageEvent event) {
        return this.getVanillaDamageTypes(event.getCause());
    }

    @NotNull
    public DamageType[] getVanillaDamageTypes(EntityDamageEvent.DamageCause cause) {
        switch (cause) {
            case MAGIC: 
            case DRAGON_BREATH: {
                return new DamageType[]{DamageType.MAGIC};
            }
            case POISON: 
            case WITHER: {
                return new DamageType[]{DamageType.MAGIC, DamageType.DOT};
            }
            case FIRE_TICK: 
            case MELTING: {
                return new DamageType[]{DamageType.PHYSICAL, DamageType.DOT};
            }
            case FALL: 
            case THORNS: 
            case CONTACT: 
            case ENTITY_EXPLOSION: 
            case ENTITY_SWEEP_ATTACK: 
            case FALLING_BLOCK: 
            case FLY_INTO_WALL: 
            case BLOCK_EXPLOSION: 
            case ENTITY_ATTACK: 
            case SUFFOCATION: 
            case CRAMMING: 
            case DROWNING: {
                return new DamageType[]{DamageType.PHYSICAL};
            }
            case PROJECTILE: {
                return new DamageType[]{DamageType.PHYSICAL, DamageType.PROJECTILE};
            }
        }
        return new DamageType[0];
    }

    @NotNull
    public DamageType[] getVanillaDamageTypes(EntityDamageByEntityEvent event, EquipmentSlot hand) {
        Validate.isTrue((boolean)(event.getDamager() instanceof LivingEntity), (String)"Not an entity attack");
        return this.getVanillaDamageTypes((LivingEntity)event.getDamager(), event.getCause(), hand);
    }

    @NotNull
    public DamageType[] getVanillaDamageTypes(@NotNull LivingEntity damager, @NotNull EntityDamageEvent.DamageCause cause, @NotNull EquipmentSlot hand) {
        if (cause != EntityDamageEvent.DamageCause.ENTITY_ATTACK && cause != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            return new DamageType[]{DamageType.PHYSICAL};
        }
        if (this.isAir(damager.getEquipment().getItem(hand.toBukkit()))) {
            return new DamageType[]{DamageType.UNARMED, DamageType.PHYSICAL};
        }
        if (this.isWeapon(damager.getEquipment().getItem(hand.toBukkit()).getType())) {
            return new DamageType[]{DamageType.WEAPON, DamageType.PHYSICAL};
        }
        return new DamageType[]{DamageType.PHYSICAL};
    }

    @Nullable
    public AttackMetadata getRegisteredAttackMetadata(Entity entity) {
        return this.attackMetadatas.get(entity.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void unregisterCustomAttacks(EntityDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            this.attackMetadatas.remove(event.getEntity().getUniqueId());
        }
    }

    private boolean isWeapon(Material mat) {
        return mat.getMaxDurability() > 0;
    }

    private boolean isAir(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }
}

