/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.math3.distribution;

import io.lumine.mythic.lib.math3.distribution.MixtureMultivariateRealDistribution;
import io.lumine.mythic.lib.math3.distribution.MultivariateNormalDistribution;
import io.lumine.mythic.lib.math3.exception.DimensionMismatchException;
import io.lumine.mythic.lib.math3.exception.NotPositiveException;
import io.lumine.mythic.lib.math3.random.RandomGenerator;
import io.lumine.mythic.lib.math3.util.Pair;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixtureMultivariateNormalDistribution
extends MixtureMultivariateRealDistribution<MultivariateNormalDistribution> {
    public MixtureMultivariateNormalDistribution(double[] weights, double[][] means, double[][][] covariances) {
        super(MixtureMultivariateNormalDistribution.createComponents(weights, means, covariances));
    }

    public MixtureMultivariateNormalDistribution(List<Pair<Double, MultivariateNormalDistribution>> components) {
        super(components);
    }

    public MixtureMultivariateNormalDistribution(RandomGenerator rng, List<Pair<Double, MultivariateNormalDistribution>> components) throws NotPositiveException, DimensionMismatchException {
        super(rng, components);
    }

    private static List<Pair<Double, MultivariateNormalDistribution>> createComponents(double[] weights, double[][] means, double[][][] covariances) {
        ArrayList<Pair<Double, MultivariateNormalDistribution>> mvns = new ArrayList<Pair<Double, MultivariateNormalDistribution>>(weights.length);
        for (int i = 0; i < weights.length; ++i) {
            MultivariateNormalDistribution dist = new MultivariateNormalDistribution(means[i], covariances[i]);
            mvns.add(new Pair<Double, MultivariateNormalDistribution>(weights[i], dist));
        }
        return mvns;
    }
}

