/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.math3.ml.distance;

import io.lumine.mythic.lib.math3.exception.DimensionMismatchException;
import io.lumine.mythic.lib.math3.ml.distance.DistanceMeasure;
import io.lumine.mythic.lib.math3.util.FastMath;
import io.lumine.mythic.lib.math3.util.MathArrays;

public class EarthMoversDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -5406732779747414922L;

    public double compute(double[] a, double[] b) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a, b);
        double lastDistance = 0.0;
        double totalDistance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double currentDistance = a[i] + lastDistance - b[i];
            totalDistance += FastMath.abs(currentDistance);
            lastDistance = currentDistance;
        }
        return totalDistance;
    }
}

