/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.eval;

import io.lumine.mythic.lib.math3.Field;
import io.lumine.mythic.lib.math3.complex.Complex;
import io.lumine.mythic.lib.math3.complex.ComplexField;
import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FloatNode;
import io.lumine.mythic.lib.parser.client.ast.FractionNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.NumberNode;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.StringNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.eval.BooleanVariable;
import io.lumine.mythic.lib.parser.client.eval.ComplexNode;
import io.lumine.mythic.lib.parser.client.eval.ComplexVariable;
import io.lumine.mythic.lib.parser.client.eval.DoubleNode;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementEvaluator;
import io.lumine.mythic.lib.parser.client.eval.api.FieldElementVariable;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanBoolean2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IBooleanFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement0Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement1Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElement2Function;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementFunction;
import io.lumine.mythic.lib.parser.client.eval.api.IFieldElementInt2Function;
import io.lumine.mythic.lib.parser.client.eval.api.function.CompoundExpressionFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.PlusFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.SetFunction;
import io.lumine.mythic.lib.parser.client.eval.api.function.TimesFunction;
import io.lumine.mythic.lib.parser.client.math.ArithmeticMathException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ComplexEvaluator
extends FieldElementEvaluator<Complex> {
    private static Map<String, IBooleanFunction<Complex>> FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, IBooleanFunction<Complex>>();
    private static Map<String, Complex> SYMBOL_MAP;
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP;
    private static Map<String, IFieldElementFunction<Complex>> FUNCTION_MAP;

    public static String toString(Complex c) {
        double real = c.getReal();
        double imag = c.getImaginary();
        if (imag == 0.0) {
            return Double.toString(real);
        }
        if (imag >= 0.0) {
            return Double.toString(real) + "+I*" + Double.toString(imag);
        }
        return Double.toString(real) + "+I*(" + Double.toString(imag) + ")";
    }

    public ComplexEvaluator() {
        this(true);
    }

    public ComplexEvaluator(boolean relaxedSyntax) {
        super(relaxedSyntax);
        if (this.fRelaxedSyntax && SYMBOL_MAP.get("pi") == null) {
            for (Map.Entry<String, Complex> entry : SYMBOL_MAP.entrySet()) {
                SYMBOL_MAP.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            for (Map.Entry<String, Serializable> entry : SYMBOL_BOOLEAN_MAP.entrySet()) {
                SYMBOL_BOOLEAN_MAP.put(entry.getKey().toLowerCase(), (Boolean)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : FUNCTION_MAP.entrySet()) {
                FUNCTION_MAP.put(entry.getKey().toLowerCase(), (IFieldElementFunction)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : FUNCTION_BOOLEAN_MAP.entrySet()) {
                FUNCTION_BOOLEAN_MAP.put(entry.getKey().toLowerCase(), (IBooleanFunction)entry.getValue());
            }
        }
    }

    @Override
    public void clearVariables() {
        this.fVariableMap.clear();
    }

    @Override
    public FieldElementVariable<Complex> createVariable(Complex value) {
        return new ComplexVariable(value);
    }

    @Override
    public void defineVariable(String variableName, BooleanVariable value) {
        this.fBooleanVariables.put(variableName, value);
    }

    @Override
    public void defineVariable(String variableName, FieldElementVariable<Complex> value) {
        this.fVariableMap.put(variableName, value);
    }

    @Override
    public Field<Complex> getField() {
        return ComplexField.getInstance();
    }

    @Override
    public IBooleanFunction<Complex> getFunctionBooleanMap(String symbolName) {
        return FUNCTION_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public IFieldElementFunction<Complex> getFunctionMap(String symbolName) {
        return FUNCTION_MAP.get(symbolName);
    }

    @Override
    public Boolean getSymbolBooleanMap(String symbolName) {
        return SYMBOL_BOOLEAN_MAP.get(symbolName);
    }

    @Override
    public Complex getSymbolFieldElementMap(String symbolName) {
        return SYMBOL_MAP.get(symbolName);
    }

    @Override
    public FieldElementVariable<Complex> getVariable(String variableName) {
        return (FieldElementVariable)this.fVariableMap.get(variableName);
    }

    @Override
    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (!functionNode.isEmpty()) {
            boolean complexOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    functionNode.set(i, new ComplexNode(((NumberNode)functionNode.getNode(i)).doubleValue()));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof ComplexNode)) {
                        complexOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Complex c = SYMBOL_MAP.get(node.toString());
                    if (c != null) {
                        functionNode.set(i, new ComplexNode(c));
                        continue;
                    }
                    complexOnly = false;
                    continue;
                }
                complexOnly = false;
            }
            if (complexOnly) {
                try {
                    return new ComplexNode((Complex)this.visit(functionNode));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    @Override
    public void setUp(Complex data) {
        super.setUp(data);
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Complex visit(ComplexNode node) {
        return node.complexValue();
    }

    @Override
    public Complex visit(DoubleNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(FloatNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(FractionNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(IntegerNode node) {
        return new Complex(node.doubleValue(), 0.0);
    }

    @Override
    public Complex visit(PatternNode node) {
        return null;
    }

    @Override
    public Complex visit(StringNode node) {
        return null;
    }

    @Override
    public Complex visit(SymbolNode node) {
        FieldElementVariable v = (FieldElementVariable)this.fVariableMap.get(node.toString());
        if (v != null) {
            return (Complex)v.getValue();
        }
        Complex c = SYMBOL_MAP.get(node.toString());
        if (c != null) {
            return c;
        }
        throw new ArithmeticMathException("ComplexEvalVisitor#visit(SymbolNode) not possible for: " + node.toString());
    }

    static {
        FUNCTION_BOOLEAN_MAP.put("And", (IBooleanFunction<Complex>)new IBooleanBoolean2Function<Complex>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", (IBooleanFunction<Complex>)new IBooleanBoolean1Function<Complex>(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", (IBooleanFunction<Complex>)new IBooleanBoolean2Function<Complex>(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", (IBooleanFunction<Complex>)new IBooleanFieldElement2Function<Complex>(){

            @Override
            public boolean evaluate(Complex arg1, Complex arg2) {
                return arg1.equals(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", (IBooleanFunction<Complex>)new IBooleanFieldElement2Function<Complex>(){

            @Override
            public boolean evaluate(Complex arg1, Complex arg2) {
                return !arg1.equals(arg2);
            }
        });
        SYMBOL_MAP = new ConcurrentHashMap<String, Complex>();
        SYMBOL_MAP.put("Catalan", new Complex(0.915965594177219, 0.0));
        SYMBOL_MAP.put("Degree", new Complex(Math.PI / 180, 0.0));
        SYMBOL_MAP.put("E", new Complex(Math.E, 0.0));
        SYMBOL_MAP.put("I", new Complex(0.0, 1.0));
        SYMBOL_MAP.put("Pi", new Complex(Math.PI, 0.0));
        SYMBOL_MAP.put("EulerGamma", new Complex(0.5772156649015329, 0.0));
        SYMBOL_MAP.put("Glaisher", new Complex(1.2824271291006226, 0.0));
        SYMBOL_MAP.put("GoldenRatio", new Complex(1.618033988749895, 0.0));
        SYMBOL_MAP.put("Khinchin", new Complex(2.6854520010653062, 0.0));
        SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_MAP = new ConcurrentHashMap<String, IFieldElementFunction<Complex>>();
        FUNCTION_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_MAP.put("Log", new LogFunction());
        FUNCTION_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_MAP.put("Set", new SetFunction());
        FUNCTION_MAP.put("Plus", new PlusFunction());
        FUNCTION_MAP.put("Times", new TimesFunction());
        FUNCTION_MAP.put("Random", (IFieldElementFunction<Complex>)new IFieldElement0Function<Complex>(){

            @Override
            public Complex evaluate() {
                return new Complex(Math.random(), Math.random());
            }
        });
        FUNCTION_MAP.put("Abs", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return new Complex(arg1.abs());
            }
        });
        FUNCTION_MAP.put("ArcCos", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.acos();
            }
        });
        FUNCTION_MAP.put("ArcSin", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.asin();
            }
        });
        FUNCTION_MAP.put("Cos", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.cos();
            }
        });
        FUNCTION_MAP.put("Cosh", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.cosh();
            }
        });
        FUNCTION_MAP.put("Exp", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.exp();
            }
        });
        FUNCTION_MAP.put("Sin", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sin();
            }
        });
        FUNCTION_MAP.put("Sinh", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sinh();
            }
        });
        FUNCTION_MAP.put("Sqrt", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.sqrt();
            }
        });
        FUNCTION_MAP.put("Tan", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.tan();
            }
        });
        FUNCTION_MAP.put("Tanh", (IFieldElementFunction<Complex>)new IFieldElement1Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1) {
                return arg1.tanh();
            }
        });
        FUNCTION_MAP.put("Power", (IFieldElementFunction<Complex>)new IFieldElementInt2Function<Complex>(){

            @Override
            public Complex evaluate(Complex arg1, Complex arg2) {
                if (arg1.equals(Complex.ZERO) && !arg2.equals(Complex.ZERO)) {
                    return Complex.ZERO;
                }
                return arg1.pow(arg2);
            }

            @Override
            public Complex evaluate(Complex arg1, int n) {
                if (n == 0 && arg1.equals(Complex.ZERO)) {
                    return Complex.ZERO;
                }
                return arg1.pow(n);
            }
        });
    }

    static class ArcTanFunction
    implements IFieldElement1Function<Complex> {
        ArcTanFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1) {
            return arg1.atan();
        }
    }

    static class LogFunction
    implements IFieldElement1Function<Complex>,
    IFieldElement2Function<Complex> {
        LogFunction() {
        }

        @Override
        public Complex evaluate(Complex arg1) {
            return arg1.log();
        }

        @Override
        public Complex evaluate(Complex base, Complex z) {
            return z.log().divide(base.log());
        }
    }
}

