/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.parser.client.operator;

import io.lumine.mythic.lib.parser.client.ast.ASTNode;
import io.lumine.mythic.lib.parser.client.ast.FloatNode;
import io.lumine.mythic.lib.parser.client.ast.FractionNode;
import io.lumine.mythic.lib.parser.client.ast.FunctionNode;
import io.lumine.mythic.lib.parser.client.ast.IParserFactory;
import io.lumine.mythic.lib.parser.client.ast.IntegerNode;
import io.lumine.mythic.lib.parser.client.ast.Pattern2Node;
import io.lumine.mythic.lib.parser.client.ast.Pattern3Node;
import io.lumine.mythic.lib.parser.client.ast.PatternNode;
import io.lumine.mythic.lib.parser.client.ast.StringNode;
import io.lumine.mythic.lib.parser.client.ast.SymbolNode;
import io.lumine.mythic.lib.parser.client.operator.DivideOperator;
import io.lumine.mythic.lib.parser.client.operator.InfixOperator;
import io.lumine.mythic.lib.parser.client.operator.Operator;
import io.lumine.mythic.lib.parser.client.operator.PostfixOperator;
import io.lumine.mythic.lib.parser.client.operator.PreMinusOperator;
import io.lumine.mythic.lib.parser.client.operator.PrePlusOperator;
import io.lumine.mythic.lib.parser.client.operator.PrefixOperator;
import io.lumine.mythic.lib.parser.client.operator.SubtractOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASTNodeFactory
implements IParserFactory {
    public static final int PLUS_PRECEDENCE = 2900;
    public static final int TIMES_PRECEDENCE = 3800;
    public static final int DIVIDE_PRECEDENCE = 4500;
    public static final int POWER_PRECEDENCE = 5700;
    static final String[] HEADER_STRINGS = new String[]{"MessageName", "Get", "PatternTest", "MapAll", "TimesBy", "Plus", "UpSet", "CompoundExpression", "Map", "Unset", "Apply", "ReplaceRepeated", "Less", "And", "Divide", "Set", "Increment", "Factorial2", "LessEqual", "NonCommutativeMultiply", "Factorial", "Times", "Power", "Dot", "Not", "PreMinus", "SameQ", "RuleDelayed", "GreaterEqual", "Condition", "Colon", "//", "DivideBy", "Or", "Equal", "StringJoin", "Unequal", "Decrement", "SubtractFrom", "PrePlus", "RepeatedNull", "UnsameQ", "Rule", "UpSetDelayed", "PreIncrement", "Function", "Greater", "PreDecrement", "Subtract", "SetDelayed", "Alternatives", "AddTo", "Repeated", "ReplaceAll"};
    static final String[] OPERATOR_STRINGS = new String[]{"::", "<<", "?", "//@", "*=", "+", "^=", ";", "/@", "=.", "@@", "//.", "<", "&&", "/", "=", "++", "!!", "<=", "**", "!", "*", "^", ".", "!", "-", "===", ":>", ">=", "/;", ":", "//", "/=", "||", "==", "<>", "!=", "--", "-=", "+", "...", "=!=", "->", "^:=", "++", "&", ">", "--", "-", ":=", "|", "+=", "..", "/."};
    static final Operator[] OPERATORS = new Operator[]{new InfixOperator("::", "MessageName", 7400, 0), new PrefixOperator("<<", "Get", 7000), new InfixOperator("?", "PatternTest", 6600, 0), new InfixOperator("//@", "MapAll", 6100, 1), new InfixOperator("*=", "TimesBy", 900, 0), new InfixOperator("+", "Plus", 2900, 0), new InfixOperator("^=", "UpSet", 300, 0), new InfixOperator(";", "CompoundExpression", 100, 0), new InfixOperator("/@", "Map", 6100, 1), new PostfixOperator("=.", "Unset", 300), new InfixOperator("@@", "Apply", 6100, 1), new InfixOperator("//.", "ReplaceRepeated", 1000, 2), new InfixOperator("<", "Less", 2600, 0), new InfixOperator("&&", "And", 2000, 0), new DivideOperator("/", "Divide", 4500, 2), new InfixOperator("=", "Set", 300, 1), new PostfixOperator("++", "Increment", 6400), new PostfixOperator("!!", "Factorial2", 6000), new InfixOperator("<=", "LessEqual", 2600, 0), new InfixOperator("**", "NonCommutativeMultiply", 5000, 0), new PostfixOperator("!", "Factorial", 6000), new InfixOperator("*", "Times", 3800, 0), new InfixOperator("^", "Power", 5700, 1), new InfixOperator(".", "Dot", 4700, 0), new PrefixOperator("!", "Not", 2100), new PreMinusOperator("-", "PreMinus", 4600), new InfixOperator("===", "SameQ", 2400, 0), new InfixOperator(":>", "RuleDelayed", 1100, 1), new InfixOperator(">=", "GreaterEqual", 2600, 0), new InfixOperator("/;", "Condition", 1200, 2), new InfixOperator(":", "Colon", 700, 0), new InfixOperator("//", "//", 600, 0), new InfixOperator("/=", "DivideBy", 900, 0), new InfixOperator("||", "Or", 1900, 0), new InfixOperator("==", "Equal", 2600, 0), new InfixOperator("<>", "StringJoin", 5800, 0), new InfixOperator("!=", "Unequal", 2600, 0), new PostfixOperator("--", "Decrement", 6400), new InfixOperator("-=", "SubtractFrom", 900, 0), new PrePlusOperator("+", "PrePlus", 4600), new PostfixOperator("...", "RepeatedNull", 1500), new InfixOperator("=!=", "UnsameQ", 2400, 0), new InfixOperator("->", "Rule", 1100, 1), new InfixOperator("^:=", "UpSetDelayed", 300, 0), new PrefixOperator("++", "PreIncrement", 6400), new PostfixOperator("&", "Function", 800), new InfixOperator(">", "Greater", 2600, 0), new PrefixOperator("--", "PreDecrement", 6400), new SubtractOperator("-", "Subtract", 2900, 2), new InfixOperator(":=", "SetDelayed", 300, 0), new InfixOperator("|", "Alternatives", 1400, 0), new InfixOperator("+=", "AddTo", 900, 0), new PostfixOperator("..", "Repeated", 1500), new InfixOperator("/.", "ReplaceAll", 1000, 2)};
    public static final ASTNodeFactory MMA_STYLE_FACTORY = new ASTNodeFactory(false);
    public static final ASTNodeFactory RELAXED_STYLE_FACTORY = new ASTNodeFactory(true);
    private static HashMap<String, Operator> fOperatorMap = new HashMap();
    private static HashMap<String, ArrayList<Operator>> fOperatorTokenStartSet = new HashMap();
    private final boolean fIgnoreCase;

    public static void addOperator(Map<String, Operator> operatorMap, Map<String, ArrayList<Operator>> operatorTokenStartSet, String operatorStr, String headStr, Operator oper) {
        operatorMap.put(headStr, oper);
        ArrayList<Operator> list = operatorTokenStartSet.get(operatorStr);
        if (list == null) {
            list = new ArrayList(2);
            list.add(oper);
            operatorTokenStartSet.put(operatorStr, list);
        } else {
            list.add(oper);
        }
    }

    public static InfixOperator createInfixOperator(String operatorStr, String headStr, int precedence, int grouping) {
        InfixOperator oper = headStr.equals("Divide") ? new DivideOperator(operatorStr, headStr, precedence, grouping) : (headStr.equals("Subtract") ? new SubtractOperator(operatorStr, headStr, precedence, grouping) : new InfixOperator(operatorStr, headStr, precedence, grouping));
        return oper;
    }

    public static PostfixOperator createPostfixOperator(String operatorStr, String headStr, int precedence) {
        return new PostfixOperator(operatorStr, headStr, precedence);
    }

    public static PrefixOperator createPrefixOperator(String operatorStr, String headStr, int precedence) {
        PrefixOperator oper = headStr.equals("PreMinus") ? new PreMinusOperator(operatorStr, headStr, precedence) : (headStr.equals("PrePlus") ? new PrePlusOperator(operatorStr, headStr, precedence) : new PrefixOperator(operatorStr, headStr, precedence));
        return oper;
    }

    public ASTNodeFactory(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    @Override
    public FunctionNode createAST(ASTNode headExpr) {
        return new FunctionNode(headExpr);
    }

    @Override
    public ASTNode createDouble(String doubleString) {
        return new FloatNode(doubleString);
    }

    @Override
    public FractionNode createFraction(IntegerNode numerator, IntegerNode denominator) {
        return new FractionNode(numerator, denominator);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head) {
        return new FunctionNode(head);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0) {
        return new FunctionNode(head, arg0);
    }

    @Override
    public FunctionNode createFunction(SymbolNode head, ASTNode arg0, ASTNode arg1) {
        return new FunctionNode(head, arg0, arg1);
    }

    @Override
    public IntegerNode createInteger(int intValue) {
        return new IntegerNode(intValue);
    }

    @Override
    public IntegerNode createInteger(String integerString, int numberFormat) {
        return new IntegerNode(integerString, numberFormat);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check) {
        return new PatternNode(patternName, check);
    }

    @Override
    public PatternNode createPattern(SymbolNode patternName, ASTNode check, boolean optional) {
        return new PatternNode(patternName, check, optional);
    }

    @Override
    public PatternNode createPattern2(SymbolNode patternName, ASTNode check) {
        return new Pattern2Node(patternName, check);
    }

    @Override
    public PatternNode createPattern3(SymbolNode patternName, ASTNode check) {
        return new Pattern3Node(patternName, check);
    }

    @Override
    public StringNode createString(StringBuilder buffer) {
        return new StringNode(buffer.toString());
    }

    @Override
    public SymbolNode createSymbol(String symbolName) {
        String name = symbolName;
        if (this.fIgnoreCase) {
            name = symbolName.toLowerCase();
        }
        return new SymbolNode(name);
    }

    @Override
    public Operator get(String identifier) {
        return fOperatorMap.get(identifier);
    }

    @Override
    public Map<String, Operator> getIdentifier2OperatorMap() {
        return fOperatorMap;
    }

    @Override
    public Map<String, ArrayList<Operator>> getOperator2ListMap() {
        return fOperatorTokenStartSet;
    }

    @Override
    public String getOperatorCharacters() {
        return ".-:=<>*+;!^|&/@?";
    }

    @Override
    public List<Operator> getOperatorList(String key) {
        return fOperatorTokenStartSet.get(key);
    }

    @Override
    public boolean isValidIdentifier(String identifier) {
        return true;
    }

    static {
        for (int i = 0; i < HEADER_STRINGS.length; ++i) {
            ASTNodeFactory.addOperator(fOperatorMap, fOperatorTokenStartSet, OPERATOR_STRINGS[i], HEADER_STRINGS[i], OPERATORS[i]);
        }
    }
}

