/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.offense;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.element.Element;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.TargetMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

@MechanicMetadata
public class MultiplyDamageMechanic
extends TargetMechanic {
    private final DoubleFormula amount;
    private final DamageType damageType;
    private final boolean additive;
    @Nullable
    private final String elementName;

    public MultiplyDamageMechanic(ConfigObject config) {
        super(config);
        config.validateKeys("amount");
        this.amount = new DoubleFormula(config.getString("amount"));
        this.damageType = config.contains("damage_type") ? DamageType.valueOf(config.getString("damage_type").toUpperCase()) : null;
        this.additive = config.getBoolean("additive", false);
        this.elementName = config.contains("element") ? UtilityMethods.enumName(config.getString("element")) : null;
    }

    @Override
    public void cast(SkillMetadata meta, Entity target) {
        Element element;
        Element element2 = element = this.elementName != null ? Objects.requireNonNull(MythicLib.plugin.getElements().get(this.elementName), "Could not find element with ID '" + this.elementName + "'") : null;
        if (this.additive) {
            if (element != null) {
                meta.getAttack().getDamage().additiveModifier(this.amount.evaluate(meta), element);
            } else if (this.damageType != null) {
                meta.getAttack().getDamage().additiveModifier(this.amount.evaluate(meta), this.damageType);
            } else {
                meta.getAttack().getDamage().additiveModifier(this.amount.evaluate(meta));
            }
        } else if (element != null) {
            meta.getAttack().getDamage().multiplicativeModifier(this.amount.evaluate(meta), element);
        } else if (this.damageType != null) {
            meta.getAttack().getDamage().multiplicativeModifier(this.amount.evaluate(meta), this.damageType);
        } else {
            meta.getAttack().getDamage().multiplicativeModifier(this.amount.evaluate(meta));
        }
    }
}

