/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable.def;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.script.variable.SimpleVariableRegistry;
import io.lumine.mythic.lib.script.variable.Variable;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import io.lumine.mythic.lib.script.variable.def.DoubleVariable;
import io.lumine.mythic.lib.script.variable.def.StringVariable;
import io.lumine.mythic.lib.script.variable.def.WorldVariable;
import io.lumine.mythic.lib.util.Position;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.util.Vector;

@VariableMetadata(name="vector")
public class PositionVariable
extends Variable<Position> {
    public static final SimpleVariableRegistry<PositionVariable> VARIABLE_REGISTRY = new SimpleVariableRegistry();

    public PositionVariable(String name, Position position) {
        super(name, position);
    }

    public PositionVariable(String name, Location loc) {
        super(name, new Position(loc));
    }

    public PositionVariable(String name, World world, Vector vec) {
        super(name, new Position(world, vec));
    }

    @Override
    public VariableRegistry getVariableRegistry() {
        return VARIABLE_REGISTRY;
    }

    private static Biome getBiomeAt(Position loc) {
        return loc.getWorld().getBiome(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    static {
        VARIABLE_REGISTRY.registerVariable("x", var -> new DoubleVariable("temp", ((Position)var.getStored()).getX()));
        VARIABLE_REGISTRY.registerVariable("y", var -> new DoubleVariable("temp", ((Position)var.getStored()).getY()));
        VARIABLE_REGISTRY.registerVariable("z", var -> new DoubleVariable("temp", ((Position)var.getStored()).getZ()));
        VARIABLE_REGISTRY.registerVariable("length", var -> new DoubleVariable("temp", ((Position)var.getStored()).length()));
        VARIABLE_REGISTRY.registerVariable("world", var -> new WorldVariable("temp", ((Position)var.getStored()).getWorld()));
        VARIABLE_REGISTRY.registerVariable("biome", var -> new StringVariable("temp", PositionVariable.getBiomeAt((Position)var.getStored()).name()));
        VARIABLE_REGISTRY.registerVariable("altitude", var -> new DoubleVariable("temp", UtilityMethods.getAltitude(((Position)var.getStored()).toLocation())));
    }
}

