/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.location;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.LocationSkillResult;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Corrosion
extends SkillHandler<LocationSkillResult> {
    public Corrosion() {
        this.registerModifiers("duration", "amplifier", "radius");
    }

    @Override
    public LocationSkillResult getResult(SkillMetadata meta) {
        return new LocationSkillResult(meta);
    }

    @Override
    public void whenCast(LocationSkillResult result, SkillMetadata skillMeta) {
        Location loc = result.getTarget();
        Player caster = skillMeta.getCaster().getPlayer();
        int duration = (int)(skillMeta.getModifier("duration") * 20.0);
        int amplifier = (int)skillMeta.getModifier("amplifier");
        double radiusSquared = Math.pow(skillMeta.getModifier("radius"), 2.0);
        loc.getWorld().spawnParticle(Particle.SLIME, loc, 48, 2.0, 2.0, 2.0, 0.0);
        loc.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, 32, 2.0, 2.0, 2.0, 0.0);
        loc.getWorld().playSound(loc, Sound.BLOCK_BREWING_STAND_BREW, 2.0f, 0.0f);
        for (Entity entity : UtilityMethods.getNearbyChunkEntities(loc)) {
            if (!(entity.getLocation().distanceSquared(loc) < radiusSquared) || !UtilityMethods.canTarget(caster, entity)) continue;
            ((LivingEntity)entity).removePotionEffect(PotionEffectType.POISON);
            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.POISON, duration, amplifier));
        }
    }
}

