/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.util.SmallParticleEffect;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Evade
extends SkillHandler<SimpleSkillResult> {
    public Evade() {
        this.registerModifiers("duration");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_ENDERMAN_TELEPORT.toSound(), 1.0f, 2.0f);
        new SmallParticleEffect((Entity)caster, Particle.CLOUD);
        new EvadeSkill(skillMeta.getCaster().getData(), skillMeta.getModifier("duration"));
    }

    private static class EvadeSkill
    extends BukkitRunnable
    implements Listener {
        private final MMOPlayerData data;

        public EvadeSkill(MMOPlayerData data, double duration) {
            this.data = data;
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
            this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
            Bukkit.getScheduler().runTaskLater((Plugin)MythicLib.plugin, this::close, (long)(duration * 20.0));
        }

        private void close() {
            this.cancel();
            EntityDamageEvent.getHandlerList().unregister((Listener)this);
        }

        @EventHandler(priority=EventPriority.LOW)
        public void a(EntityDamageEvent event) {
            if (!this.data.isOnline()) {
                return;
            }
            if (event.getEntity().equals(this.data.getPlayer())) {
                event.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void b(PlayerAttackEvent event) {
            if (event.getAttack().getDamage().hasType(DamageType.WEAPON) && event.getAttacker().getData().equals(this.data)) {
                this.close();
            }
        }

        public void run() {
            if (!this.data.isOnline() || this.data.getPlayer().isDead()) {
                this.close();
            } else {
                this.data.getPlayer().getWorld().spawnParticle(Particle.CLOUD, this.data.getPlayer().getLocation().add(0.0, 1.0, 0.0), 0);
            }
        }
    }
}

