/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Firefly
extends SkillHandler<SimpleSkillResult> {
    public Firefly() {
        this.registerModifiers("damage", "duration", "knockback");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, final SkillMetadata skillMeta) {
        final double duration = skillMeta.getModifier("duration") * 20.0;
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            int j = 0;

            public void run() {
                int n = this.j++;
                if ((double)n > duration) {
                    this.cancel();
                }
                if (caster.getLocation().getBlock().getType() == Material.WATER) {
                    caster.setVelocity(caster.getVelocity().multiply(3).setY(1.8));
                    caster.getWorld().playSound(caster.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 0.5f);
                    caster.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.2);
                    caster.getWorld().spawnParticle(Particle.CLOUD, caster.getLocation().add(0.0, 1.0, 0.0), 32, 0.0, 0.0, 0.0, 0.2);
                    this.cancel();
                    return;
                }
                for (Entity entity : caster.getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (!UtilityMethods.canTarget(caster, entity)) continue;
                    double damage = skillMeta.getModifier("damage");
                    double knockback = skillMeta.getModifier("knockback");
                    caster.getWorld().playSound(caster.getLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 1.0f, 0.5f);
                    caster.getWorld().spawnParticle(Particle.LAVA, caster.getLocation().add(0.0, 1.0, 0.0), 32);
                    caster.getWorld().spawnParticle(Particle.SMOKE_LARGE, caster.getLocation().add(0.0, 1.0, 0.0), 24, 0.0, 0.0, 0.0, 0.3);
                    caster.getWorld().spawnParticle(Particle.FLAME, caster.getLocation().add(0.0, 1.0, 0.0), 24, 0.0, 0.0, 0.0, 0.3);
                    entity.setVelocity(caster.getVelocity().setY(0.3).multiply(1.7 * knockback));
                    caster.setVelocity(caster.getEyeLocation().getDirection().multiply(-3).setY(0.5));
                    skillMeta.getCaster().attack((LivingEntity)entity, damage, DamageType.SKILL, DamageType.MAGIC);
                    this.cancel();
                    return;
                }
                Location loc = caster.getLocation().add(0.0, 1.0, 0.0);
                for (double a = 0.0; a < Math.PI * 2; a += 0.3490658503988659) {
                    Vector vec = new Vector(0.6 * Math.cos(a), 0.6 * Math.sin(a), 0.0);
                    vec = UtilityMethods.rotate(vec, loc.getDirection());
                    loc.add(vec);
                    caster.getWorld().spawnParticle(Particle.SMOKE_NORMAL, loc, 0);
                    if (random.nextDouble() < 0.3) {
                        caster.getWorld().spawnParticle(Particle.FLAME, loc, 0);
                    }
                    loc.add(vec.multiply(-1));
                }
                caster.setVelocity(caster.getEyeLocation().getDirection());
                caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_FIREWORK_ROCKET_BLAST.toSound(), 1.0f, 1.0f);
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

