/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.comp.interaction.InteractionType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Human_Shield
extends SkillHandler<TargetSkillResult> {
    public Human_Shield() {
        this.registerModifiers("reduction", "redirect", "duration", "low");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        TargetSkillResult result = new TargetSkillResult(meta, 7.0, InteractionType.SUPPORT_SKILL);
        return result.isSuccessful(meta) && result.getTarget() instanceof Player ? result : new TargetSkillResult((LivingEntity)null);
    }

    @Override
    public void whenCast(TargetSkillResult result, SkillMetadata skillMeta) {
        Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), Sound.ENTITY_BLAZE_AMBIENT, 1.0f, 1.0f);
        new HumanShield(skillMeta.getCaster().getData(), (Player)result.getTarget(), skillMeta.getModifier("reduction"), skillMeta.getModifier("redirect"), skillMeta.getModifier("duration"), skillMeta.getModifier("low"));
    }

    public static class HumanShield
    extends BukkitRunnable
    implements Listener {
        private final MMOPlayerData caster;
        private final Player target;
        private final double damageCoefficient;
        private final double redirectRate;
        private final double duration;
        private final double minimumHealthPercentage;
        private int j;

        public HumanShield(MMOPlayerData caster, Player target, double reduction, double redirect, double duration, double low) {
            this.target = target;
            this.caster = caster;
            this.damageCoefficient = 1.0 - Math.min(1.0, reduction / 100.0);
            this.redirectRate = redirect / 100.0;
            this.duration = duration * 20.0;
            this.minimumHealthPercentage = low / 100.0;
            this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
        }

        @EventHandler
        public void a(EntityDamageEvent event) {
            if (event.getEntity().equals(this.target)) {
                double damage = event.getDamage() * this.damageCoefficient;
                event.setDamage(damage);
                double health = this.caster.getPlayer().getHealth() - damage * this.redirectRate;
                if (health > this.caster.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * this.minimumHealthPercentage) {
                    this.caster.getPlayer().setHealth(health);
                } else {
                    this.caster.getPlayer().setHealth(1.0);
                    this.close();
                }
            }
        }

        public void run() {
            block3: {
                block2: {
                    if (!this.caster.isOnline() || this.caster.getPlayer().isDead() || !this.target.isOnline() || this.target.isDead()) break block2;
                    int n = this.j++;
                    if (!((double)n >= this.duration)) break block3;
                }
                this.close();
                return;
            }
            double a = (double)this.j / 5.0;
            this.target.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, this.target.getLocation().add(Math.cos(a), 1.0 + Math.sin(a / 3.0) / 1.3, Math.sin(a)), 0);
        }

        private void close() {
            this.cancel();
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

