/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Tactical_Grenade
extends SkillHandler<TargetSkillResult> {
    public Tactical_Grenade() {
        this.registerModifiers("knock-up", "damage", "radius");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, final SkillMetadata skillMeta) {
        final LivingEntity target = result.getTarget();
        final Player caster = skillMeta.getCaster().getPlayer();
        new BukkitRunnable(){
            final Location loc;
            final double radius;
            final double knockup;
            final List<Integer> hit;
            int j;
            {
                this.loc = caster.getLocation().add(0.0, 0.1, 0.0);
                this.radius = skillMeta.getModifier("radius");
                this.knockup = 0.7 * skillMeta.getModifier("knock-up");
                this.hit = new ArrayList<Integer>();
                this.j = 0;
            }

            public void run() {
                if (target.isDead() || !target.getWorld().equals(this.loc.getWorld()) || this.j++ > 200) {
                    this.cancel();
                    return;
                }
                Vector vec = target.getLocation().add(0.0, 0.1, 0.0).subtract(this.loc).toVector();
                vec = vec.length() < 3.0 ? vec : vec.normalize().multiply(3);
                this.loc.add(vec);
                this.loc.getWorld().spawnParticle(Particle.CLOUD, this.loc, 32, 1.0, 0.0, 1.0, 0.0);
                this.loc.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, this.loc, 16, 1.0, 0.0, 1.0, 0.05);
                this.loc.getWorld().playSound(this.loc, Sound.BLOCK_ANVIL_LAND, 2.0f, 0.0f);
                this.loc.getWorld().playSound(this.loc, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 1.0f);
                for (Entity entity : UtilityMethods.getNearbyChunkEntities(this.loc)) {
                    if (this.hit.contains(entity.getEntityId()) || !UtilityMethods.canTarget(caster, entity) || !(entity.getLocation().distanceSquared(this.loc) < this.radius * this.radius)) continue;
                    this.hit.add(entity.getEntityId());
                    if (entity.equals(target)) {
                        this.cancel();
                    }
                    skillMeta.getCaster().attack((LivingEntity)entity, skillMeta.getModifier("damage"), DamageType.SKILL, DamageType.MAGIC);
                    entity.setVelocity(entity.getVelocity().add(Tactical_Grenade.this.offsetVector(this.knockup)));
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 12L);
    }

    private Vector offsetVector(double y) {
        return new Vector(2.0 * (random.nextDouble() - 0.5), y, 2.0 * (random.nextDouble() - 0.5));
    }
}

