/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.VersionSound;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Firebolt
extends SkillHandler<VectorSkillResult> {
    public Firebolt() {
        this.registerModifiers("damage", "ignite");
    }

    @Override
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), VersionSound.ENTITY_FIREWORK_ROCKET_BLAST.toSound(), 1.0f, 1.0f);
        new BukkitRunnable(){
            final Vector vec;
            final Location loc;
            int ti;
            {
                this.vec = result.getTarget().multiply(0.8);
                this.loc = caster.getEyeLocation();
                this.ti = 0;
            }

            public void run() {
                ++this.ti;
                if (this.ti > 20) {
                    this.cancel();
                }
                List<Entity> entities = UtilityMethods.getNearbyChunkEntities(this.loc);
                this.loc.getWorld().playSound(this.loc, Sound.BLOCK_FIRE_AMBIENT, 2.0f, 1.0f);
                for (int j = 0; j < 2; ++j) {
                    this.loc.add(this.vec);
                    if (this.loc.getBlock().getType().isSolid()) {
                        this.cancel();
                    }
                    this.loc.getWorld().spawnParticle(Particle.FLAME, this.loc, 5, 0.12, 0.12, 0.12, 0.0);
                    if (random.nextDouble() < 0.3) {
                        this.loc.getWorld().spawnParticle(Particle.LAVA, this.loc, 0);
                    }
                    for (Entity target : entities) {
                        if (!UtilityMethods.canTarget(caster, this.loc, target)) continue;
                        this.loc.getWorld().spawnParticle(Particle.FLAME, this.loc, 32, 0.0, 0.0, 0.0, 0.1);
                        this.loc.getWorld().spawnParticle(Particle.LAVA, this.loc, 8, 0.0, 0.0, 0.0, 0.0);
                        this.loc.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, this.loc, 0);
                        this.loc.getWorld().playSound(this.loc, Sound.ENTITY_GENERIC_EXPLODE, 3.0f, 1.0f);
                        skillMeta.getCaster().attack((LivingEntity)target, skillMeta.getModifier("damage"), DamageType.SKILL, DamageType.MAGIC, DamageType.PROJECTILE);
                        target.setFireTicks((int)skillMeta.getModifier("ignite") * 20);
                        this.cancel();
                        return;
                    }
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

