/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.result;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.api.skills.TargetSkill;
import com.sucy.skill.api.target.TargetHelper;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.result.SkillResult;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class SkillAPISkillResult
implements SkillResult {
    private final PlayerData skillPlayerData;
    private final Skill skill;
    private final int level;
    @Nullable
    private LivingEntity target;

    public SkillAPISkillResult(SkillMetadata skillMeta, Skill skill) {
        this.skillPlayerData = SkillAPI.getPlayerData((OfflinePlayer)skillMeta.getCaster().getPlayer());
        this.skill = skill;
        this.level = (int)skillMeta.getModifier("level");
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getLevel() {
        return this.level;
    }

    @NotNull
    public LivingEntity getTarget() {
        return Objects.requireNonNull(this.target, "Skill has no target");
    }

    @Override
    public boolean isSuccessful(SkillMetadata skillMeta) {
        if (skillMeta.getCaster().getPlayer().isDead()) {
            return false;
        }
        if (this.skill instanceof SkillShot) {
            return true;
        }
        if (this.skill instanceof TargetSkill) {
            LivingEntity livingEntity = this.target = skillMeta.hasTargetEntity() && skillMeta.getTargetEntityOrNull() instanceof LivingEntity ? (LivingEntity)skillMeta.getTargetEntity() : TargetHelper.getLivingTarget((LivingEntity)this.skillPlayerData.getPlayer(), (double)this.skill.getRange(this.level));
            if (this.target == null) {
                return false;
            }
        }
        return false;
    }
}

