/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.PlayerAttackEvent;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.damage.ProjectileAttackMetadata;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.skill.PassiveSkill;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class CustomProjectile
extends TemporaryListener {
    private final int entityId;
    private final BukkitRunnable runnable;
    private final ProjectileType projectileType;
    private final Iterable<PassiveSkill> cachedSkills;
    private final PlayerMetadata caster;
    public static final String METADATA_KEY = "CustomProjectile";

    public CustomProjectile(final MMOPlayerData caster, final ProjectileType projectileType, final Entity projectile, EquipmentSlot hand) {
        super(ProjectileHitEvent.getHandlerList(), EntityDeathEvent.getHandlerList(), PlayerQuitEvent.getHandlerList(), PlayerAttackEvent.getHandlerList());
        this.entityId = projectile.getEntityId();
        this.projectileType = projectileType;
        this.caster = caster.getStatMap().cache(hand);
        this.cachedSkills = caster.getPassiveSkillMap().isolateModifiers(hand);
        this.runnable = new BukkitRunnable(){

            public void run() {
                caster.triggerSkills(projectileType.getTickTrigger(), CustomProjectile.this.caster, projectile, CustomProjectile.this.cachedSkills);
            }
        };
        this.runnable.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
        projectile.setMetadata(METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)MythicLib.plugin, (Object)this));
    }

    public PlayerMetadata getCaster() {
        return this.caster;
    }

    @EventHandler
    public void unregisterOnHit(ProjectileHitEvent event) {
        if (event.getEntity().getEntityId() == this.entityId) {
            Bukkit.getScheduler().runTask((Plugin)MythicLib.plugin, () -> this.close());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void triggerHit(PlayerAttackEvent event) {
        if (event.getAttack() instanceof ProjectileAttackMetadata && ((ProjectileAttackMetadata)event.getAttack()).getProjectile().getEntityId() == this.entityId) {
            this.caster.getData().triggerSkills(this.projectileType.getHitTrigger(), this.caster, (Entity)event.getEntity(), this.cachedSkills);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void triggerLand(ProjectileHitEvent event) {
        if (event.getHitBlock() != null && event.getEntity().getEntityId() == this.entityId) {
            this.caster.getData().triggerSkills(this.projectileType.getLandTrigger(), this.caster, (Entity)event.getEntity(), this.cachedSkills);
        }
    }

    @EventHandler
    public void unregisterOnDeath(EntityDeathEvent event) {
        if (event.getEntity().getEntityId() == this.entityId) {
            this.close();
        }
    }

    @EventHandler
    public void unregisterOnLogout(PlayerQuitEvent event) {
        if (event.getPlayer().getUniqueId().equals(this.caster.getData().getUniqueId())) {
            this.close();
        }
    }

    @Override
    public void whenClosed() {
        this.runnable.cancel();
    }

    @Nullable
    public static CustomProjectile getCustomData(Entity proj) {
        for (MetadataValue mv : proj.getMetadata(METADATA_KEY)) {
            if (!mv.getOwningPlugin().equals((Object)MythicLib.plugin)) continue;
            return (CustomProjectile)mv.value();
        }
        return null;
    }

    public static enum ProjectileType {
        ARROW,
        TRIDENT;

        private final TriggerType tick = new TriggerType(this.name() + "_TICK");
        private final TriggerType hit = new TriggerType(this.name() + "_HIT");
        private final TriggerType land = new TriggerType(this.name() + "_LAND");

        public TriggerType getTickTrigger() {
            return this.tick;
        }

        public TriggerType getHitTrigger() {
            return this.hit;
        }

        public TriggerType getLandTrigger() {
            return this.land;
        }
    }
}

