/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.version.wrapper.VersionWrapper;

public class ServerVersion {
    private final String version;
    private final int[] integers;
    private final VersionWrapper versionWrapper;

    public ServerVersion(Class<?> clazz) throws Exception {
        this.version = clazz.getPackage().getName().replace(".", ",").split(",")[3];
        String[] split = this.version.substring(1).split("_");
        this.integers = new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1])};
        this.versionWrapper = (VersionWrapper)Class.forName("io.lumine.mythic.lib.version.wrapper.VersionWrapper_" + this.version.substring(1)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public boolean isBelowOrEqual(int ... version) {
        return version[0] > this.integers[0] || version[1] >= this.integers[1];
    }

    public boolean isStrictlyHigher(int ... version) {
        return version[0] < this.integers[0] || version[1] < this.integers[1];
    }

    public int getRevisionNumber() {
        return Integer.parseInt(this.version.split("_")[2].replaceAll("[^0-9]", ""));
    }

    public int[] toNumbers() {
        return this.integers;
    }

    public VersionWrapper getWrapper() {
        return this.versionWrapper;
    }

    public String toString() {
        return this.version;
    }
}

