/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.volatilecode.virtual;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.virtual.IPacketEntityRenderer;
import io.lumine.mythic.bukkit.utils.cache.DataTracker;

public abstract class PacketEntity<T extends IPacketEntityRenderer> {
    protected T renderer;
    protected boolean isDirty;
    protected DataTracker<AbstractLocation> location;
    protected DataTracker<AbstractVector> velocity;
    private AbstractLocation previousLocation;
    protected DataTracker<Boolean> hasGravity;

    public PacketEntity(AbstractLocation location) {
        this.location = DataTracker.of(location.clone());
        this.velocity = DataTracker.of(new AbstractVector(0, 0, 0));
        this.previousLocation = location.clone();
        this.hasGravity = DataTracker.of(Boolean.TRUE);
    }

    protected void setRenderer(T renderer) {
        this.renderer = renderer;
    }

    public void update() {
        this.renderer.update();
    }

    public void destroy() {
        this.renderer.destroy();
    }

    public int getEntityId() {
        return this.renderer.getEntityId();
    }

    public void setPosition(AbstractLocation location) {
        this.previousLocation = this.location.peek().clone();
        this.location.set(location);
        this.location.clearDirty();
    }

    public DataTracker<AbstractLocation> getLocation() {
        return this.location;
    }

    public AbstractLocation previousLocation() {
        return this.previousLocation;
    }

    public void teleport(AbstractLocation location) {
        this.previousLocation = this.location.peek().clone();
        this.location.set(location.clone());
        this.renderer.update();
    }

    public void setVelocity(AbstractVector velocity) {
        this.velocity.set(velocity.clone());
        this.renderer.update();
    }

    public void setHasGravity(Boolean bool) {
        this.hasGravity.set(bool);
        this.renderer.update();
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public T getRenderer() {
        return this.renderer;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public DataTracker<AbstractVector> getVelocity() {
        return this.velocity;
    }

    public AbstractLocation getPreviousLocation() {
        return this.previousLocation;
    }

    public DataTracker<Boolean> getHasGravity() {
        return this.hasGravity;
    }
}

