/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items.edit;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.bukkit.utils.prompts.chat.ChatPrompt;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.items.MythicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;

public class EditEnchantsCommand
extends Command<MythicBukkit> {
    public EditEnchantsCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        MythicBukkit cfr_ignored_0 = (MythicBukkit)this.getPlugin();
        if (!MythicBukkit.isVolatile()) {
            CommandHelper.sendError(sender, "This feature requires Mythic Premium");
            return true;
        }
        String itemName = args[0];
        Optional<MythicItem> maybeItem = ((MythicBukkit)this.getPlugin()).getItemManager().getItem(itemName);
        if (maybeItem.isEmpty()) {
            CommandHelper.sendError(sender, "Invalid Item Name");
            return true;
        }
        MythicItem item = maybeItem.get();
        if (args.length == 1) {
            this.printEnchantsEditor(sender, item);
            return true;
        }
        EditAction action = EditAction.valueOf(args[1]);
        if (action == EditAction.CLEAR) {
            item.setLore(Lists.newArrayList());
            EditEnchantsCommand.saveEnchants(item);
            item.buildItemCache();
            this.printEnchantsEditor(sender, item);
            return true;
        }
        if (action == EditAction.ADD) {
            CommandHelper.sendEditorMessage(sender, "Type in the Enchantment you'd like to add.", "Format: [enchantment_type] [amount]", "Type cancel to abort editing.");
            ChatPrompt.listen((Player)sender, input -> {
                if (input.equalsIgnoreCase("cancel")) {
                    return ChatPrompt.Response.ACCEPTED;
                }
                if (!item.addEnchantment(input)) {
                    CommandHelper.sendError(sender, "Invalid enchantment supplied");
                    return ChatPrompt.Response.TRY_AGAIN;
                }
                EditEnchantsCommand.saveEnchants(item);
                return ChatPrompt.Response.ACCEPTED;
            }).thenAcceptSync(in -> {
                item.buildItemCache();
                this.printEnchantsEditor(sender, item);
            });
            return true;
        }
        Enchantment enchant = Enchantment.getByName((String)args[2]);
        if (enchant == null) {
            CommandHelper.sendError(sender, "Invalid Enchantment");
            this.printEnchantsEditor(sender, item);
            return true;
        }
        switch (action) {
            case REMOVE: {
                item.getEnchantments().remove(enchant);
                break;
            }
        }
        EditEnchantsCommand.saveEnchants(item);
        item.buildItemCache();
        this.printEnchantsEditor(sender, item);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.edit";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "enchants";
    }

    public static void saveEnchants(MythicItem item) {
        ArrayList saveList = Lists.newArrayList();
        for (Map.Entry<Enchantment, PlaceholderInt> entry : item.getEnchantments().entrySet()) {
            saveList.add(entry.getKey().getName() + " " + entry.getValue().toString());
        }
        item.getConfig().setSave("Enchantments", saveList);
    }

    public void printEnchantsEditor(CommandSender sender, MythicItem item) {
        String n = item.getInternalName();
        CommandHelper.sendEditorMessage(sender, "<yellow>Editing Item Enchantments for: <aqua>" + item.getInternalName());
        Text.sendMessage(sender, "<gray><bold>--------------------</bold>");
        for (Map.Entry<Enchantment, PlaceholderInt> entry : item.getEnchantments().entrySet()) {
            Object message = "";
            message = (String)message + "<red><click:run_command:/mm i edit enchants " + n + " REMOVE " + entry.getKey().getName() + ">\u2715</click> ";
            message = (String)message + "<gray><bold>\u2507</bold> ";
            message = (String)message + "<white>" + entry.getKey().getName() + " " + entry.getValue().toString();
            Text.sendMessage(sender, (String)message);
        }
        Text.sendMessage(sender, "<gray>[<green><bold><click:run_command:/mm i edit enchants " + n + " ADD>+</click></bold><gray>] <gray>[<gold><click:run_command:/mm i edit " + n + ">Finished Editing</click><gray>]");
    }

    private static enum EditAction {
        CLEAR,
        ADD,
        REMOVE;

    }
}

