/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.config.GenericConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class LibsDisguisesSupport {
    public LDVersion version = LDVersion.v1_1_1;
    public boolean enabled = false;
    public LibsDisguises ld = (LibsDisguises)Bukkit.getPluginManager().getPlugin("LibsDisguises");

    public LibsDisguisesSupport() {
        this.setCompatibility();
    }

    private void setCompatibility() {
        try {
            Integer[] v = (Integer[])Arrays.stream(this.ld.getDescription().getVersion().replaceAll("[^0-9.]", "").split("\\.")).map(Integer::parseInt).toArray(Integer[]::new);
            LDVersion[] versions = LDVersion.values();
            block2: for (int i = versions.length - 1; i >= 0; --i) {
                Integer[] v1 = (Integer[])Arrays.stream(versions[i].name().replace("v", "").split("_")).map(Integer::parseInt).toArray(Integer[]::new);
                for (int a = 0; a < Math.min(v1.length, v.length); ++a) {
                    if (v[a] < v1[a]) continue block2;
                }
                this.version = versions[i];
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCompatible(LDVersion version) {
        return version.ordinal() >= this.version.ordinal();
    }

    public void setDisguise(ActiveMob am, String disguise) {
        Entity e = am.getEntity().getBukkitEntity();
        Disguise fd = this.getParsedDisguise(disguise);
        Schedulers.sync().run(() -> {
            try {
                DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
            }
            catch (Exception ex) {
                MythicLogger.errorCompatibility("LibsDisguises", "Error applying Disguise: disguise may be configured incorrectly.");
                MythicLogger.handleMinorError(ex);
                return;
            }
        });
    }

    public void setDisguise(AbstractEntity entity, MythicLineConfig mc) {
        Entity e = BukkitAdapter.adapt(entity);
        String disguise = mc.getString(new String[]{"type", "disguise", "d", "config", "conf", "c"}, "player Xikage", new String[0]);
        Disguise fd = this.getParsedDisguise(disguise);
        try {
            DisguiseAPI.disguiseToAll((Entity)e, (Disguise)fd);
        }
        catch (NullPointerException ex) {
            MythicLogger.error("(LibsDisguises) Error applying Disguise: disguise may be configured incorrectly.");
            ex.printStackTrace();
            return;
        }
    }

    public void removeDisguise(AbstractEntity entity) {
        Schedulers.sync().run(() -> DisguiseAPI.undisguiseToAll((Entity)entity.getBukkitEntity()));
    }

    public Disguise getDisguise(String disguise) {
        try {
            return DisguiseParser.parseDisguise((String)disguise);
        }
        catch (Exception e) {
            MythicLogger.errorCompatibility("LibsDisguises", "Invalid disguise supplied");
            e.printStackTrace();
            return null;
        }
    }

    public void modifyDisguise(AbstractEntity target, String disguiseString) {
        try {
            Entity entity = target.getBukkitEntity();
            Disguise disguise = DisguiseAPI.getDisguise((Entity)entity);
            if (disguise != null) {
                DisguiseParser.modifyDisguise((Disguise)disguise, (Entity)entity, (String)disguiseString);
            }
        }
        catch (Exception e) {
            MythicLogger.errorCompatibility("LibsDisguises", "Failed to modify disguise: Invalid arguments supplied: " + disguiseString);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disguise getParsedDisguise(String disguiseConfig) {
        Disguise d = null;
        try {
            d = DisguiseParser.parseDisguise((String)disguiseConfig);
        }
        catch (Exception ex) {
            if (disguiseConfig != null && disguiseConfig.startsWith("MemorySection")) {
                MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + disguiseConfig + "' is out of date! Please update this mob to the new disguise syntax.");
                d = new PlayerDisguise("Out Of Date");
            } else {
                MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + disguiseConfig + "' failed to parse");
                ex.printStackTrace();
                d = new PlayerDisguise("Error");
            }
        }
        finally {
            if (d == null) {
                MythicLogger.errorCompatibility("LibsDisguises", "Disguise '" + disguiseConfig + "' not found");
                d = new PlayerDisguise("Ashijin");
            }
        }
        return d;
    }

    public void setDisguiseName(AbstractEntity target, String name) {
        Disguise disguise = DisguiseAPI.getDisguise((Entity)target.getBukkitEntity());
        if (disguise == null) {
            return;
        }
        if (disguise.isPlayerDisguise() && this.isCompatible(LDVersion.v9_9_3)) {
            if (!((PlayerDisguise)disguise).getName().equals(" ")) {
                ((PlayerDisguise)disguise).setName(name);
            }
        } else if (disguise.getWatcher().getCustomName() != null) {
            disguise.getWatcher().setCustomName(name);
        }
    }

    public void modifyDisguise(AbstractEntity target, GenericConfig mc) {
        Entity entity = BukkitAdapter.adapt(target);
        Disguise d = DisguiseAPI.getDisguise((Entity)entity);
        if (d == null) {
            return;
        }
        FlagWatcher fw = d.getWatcher();
        if (mc.getBoolean("Burning", false)) {
            fw.setBurning(true);
        } else {
            fw.setBurning(false);
        }
        if (mc.getBoolean("Invisible", false)) {
            fw.setInvisible(true);
        } else {
            fw.setInvisible(false);
        }
        if (mc.getBoolean("Glowing", false)) {
            fw.setGlowing(true);
        } else {
            fw.setGlowing(false);
        }
        if (mc.getBoolean("Gliding", false)) {
            fw.setFlyingWithElytra(true);
        } else {
            fw.setFlyingWithElytra(false);
        }
        if (mc.getBoolean("Blocking", false)) {
            fw.setRightClicking(true);
        } else {
            fw.setRightClicking(false);
        }
        if (mc.getBoolean("Sneaking", false)) {
            fw.setSneaking(true);
        } else {
            fw.setSneaking(false);
        }
        if (mc.getBoolean("Sprinting", false)) {
            fw.setSprinting(true);
        } else {
            fw.setSprinting(false);
        }
        if (!mc.getBoolean("ModifyBoundingBox", true)) {
            d.setModifyBoundingBox(false);
        } else {
            d.setModifyBoundingBox(true);
        }
        d = d.setWatcher(fw);
        DisguiseAPI.disguiseToAll((Entity)entity, (Disguise)d);
    }

    static enum LDVersion {
        v1_1_1,
        v9_9_3;

    }
}

