/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hoglin;

public class BukkitHoglin
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private boolean ableToBeHunted = true;
    private boolean immuneToZombification = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.ableToBeHunted = mc.getBoolean("Options.AbleToHunted", true);
        this.ableToBeHunted = mc.getBoolean("Options.Huntable", this.ableToBeHunted);
        this.immuneToZombification = mc.getBoolean("Options.ImmuneToZombification", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.HOGLIN, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Hoglin hoglin = (Hoglin)entity;
        this.ageableProperty.applyProperties((Entity)hoglin);
        hoglin.setImmuneToZombification(this.immuneToZombification);
        hoglin.setIsAbleToBeHunted(this.ableToBeHunted);
        return hoglin;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Hoglin;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

