/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.events;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class MythicMobItemGenerateEvent
extends Event {
    private final MythicItem item;
    private final DropMetadata metadata;
    private ItemStack itemStack;
    private final AbstractEntity dropper;
    private final AbstractEntity trigger;
    private static final HandlerList handlers = new HandlerList();

    public MythicMobItemGenerateEvent(MythicItem item, DropMetadata metadata, ItemStack itemStack) {
        this.item = item;
        this.metadata = metadata;
        this.itemStack = itemStack;
        if (metadata != null) {
            this.dropper = metadata.getDropper().isPresent() ? metadata.getDropper().get().getEntity() : null;
            this.trigger = metadata.getCause().isPresent() ? metadata.getCause().get() : null;
        } else {
            this.dropper = null;
            this.trigger = null;
        }
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public MythicItem getItem() {
        return this.item;
    }

    public DropMetadata getMetadata() {
        return this.metadata;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public AbstractEntity getDropper() {
        return this.dropper;
    }

    public AbstractEntity getTrigger() {
        return this.trigger;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MythicMobItemGenerateEvent)) {
            return false;
        }
        MythicMobItemGenerateEvent other = (MythicMobItemGenerateEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MythicItem this$item = this.getItem();
        MythicItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        DropMetadata this$metadata = this.getMetadata();
        DropMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        ItemStack this$itemStack = this.getItemStack();
        ItemStack other$itemStack = other.getItemStack();
        if (this$itemStack == null ? other$itemStack != null : !this$itemStack.equals(other$itemStack)) {
            return false;
        }
        AbstractEntity this$dropper = this.getDropper();
        AbstractEntity other$dropper = other.getDropper();
        if (this$dropper == null ? other$dropper != null : !this$dropper.equals(other$dropper)) {
            return false;
        }
        AbstractEntity this$trigger = this.getTrigger();
        AbstractEntity other$trigger = other.getTrigger();
        return !(this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MythicMobItemGenerateEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MythicItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        DropMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        ItemStack $itemStack = this.getItemStack();
        result = result * 59 + ($itemStack == null ? 43 : $itemStack.hashCode());
        AbstractEntity $dropper = this.getDropper();
        result = result * 59 + ($dropper == null ? 43 : $dropper.hashCode());
        AbstractEntity $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        return result;
    }

    public String toString() {
        return "MythicMobItemGenerateEvent(item=" + this.getItem() + ", metadata=" + this.getMetadata() + ", itemStack=" + this.getItemStack() + ", dropper=" + this.getDropper() + ", trigger=" + this.getTrigger() + ")";
    }
}

