/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.cache;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class Cache<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private volatile T value = null;

    public static <T> Cache<T> suppliedBy(Supplier<T> supplier) {
        return new Cache<T>(Objects.requireNonNull(supplier, "supplier"));
    }

    private Cache(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        T val = this.value;
        if (val == null) {
            Cache cache = this;
            synchronized (cache) {
                val = this.value;
                if (val == null) {
                    this.value = val = this.supplier.get();
                }
            }
        }
        return val;
    }

    public final Optional<T> getIfPresent() {
        return Optional.ofNullable(this.value);
    }

    public final void invalidate() {
        this.value = null;
    }
}

