/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.serialize.Direction;
import io.lumine.mythic.bukkit.utils.serialize.Point;
import io.lumine.mythic.bukkit.utils.serialize.Position;
import java.util.ArrayList;
import java.util.List;

public class PointListProp
extends PropertyType<List<Point>> {
    public PointListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
    }

    @Override
    protected List<Point> compute(ConfigurationSection section, String node) {
        ArrayList<Point> result = new ArrayList<Point>();
        if (section == null) {
            return result;
        }
        List<String> listprop = section.getStringList(node);
        if (listprop == null) {
            return result;
        }
        for (String prop : listprop) {
            try {
                String[] split = prop.split(",");
                String world = split[0];
                double x = Double.valueOf(split[1]);
                double y = Double.valueOf(split[2]);
                double z = Double.valueOf(split[3]);
                float yaw = split.length > 3 ? Float.valueOf(split[4]).floatValue() : 0.0f;
                float pitch = split.length > 4 ? Float.valueOf(split[5]).floatValue() : 0.0f;
                result.add(Point.of(Position.of(x, y, z, world), Direction.of(yaw, pitch)));
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void set(String holder, List<Point> value) {
        if (this.config == null) {
            return;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Point point : value) {
            out.add(point.serializeShortForm());
        }
        this.config.set(this.node, out);
    }
}

