/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.ForeignKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.JoinType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Keyword;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Operator;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQL;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableField;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableLike;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOnConditionStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptionalOnStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOuterJoinStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.TablePartitionByStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.RenderOptionalKeyword;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataAccessException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractTable;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Alias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ConditionProviderImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartList;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QueryPartListView;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RecordImplN;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.TableAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class JoinTable
extends AbstractTable<Record>
implements TableOuterJoinStep<Record>,
TableOptionalOnStep<Record>,
TablePartitionByStep<Record>,
TableOnConditionStep<Record>,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE, Clause.TABLE_JOIN};
    private static final Set<SQLDialect> EMULATE_NATURAL_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID);
    private static final Set<SQLDialect> EMULATE_NATURAL_OUTER_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.IGNITE);
    private static final Set<SQLDialect> EMULATE_JOIN_USING = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.IGNITE);
    private static final Set<SQLDialect> EMULATE_APPLY = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final Table<?> lhs;
    final Table<?> rhs;
    final JoinType type;
    final ConditionProviderImpl condition;
    final QueryPartList<Field<?>> using;

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type) {
        super(TableOptions.expression(), Names.N_JOIN);
        this.lhs = lhs.asTable();
        this.rhs = rhs.asTable();
        this.type = type;
        this.condition = new ConditionProviderImpl();
        this.using = new QueryPartList();
    }

    final JoinTable transform(Table<?> newLhs, Table<?> newRhs) {
        if (this.lhs == newLhs && this.rhs == newRhs) {
            return this;
        }
        JoinTable result = new JoinTable(newLhs, newRhs, this.type);
        return !this.using.isEmpty() ? result.using(this.using) : result.on((Condition)this.condition);
    }

    @Override
    public final List<ForeignKey<Record, ?>> getReferences() {
        List<ForeignKey<?, ?>> lhsReferences = this.lhs.getReferences();
        List<ForeignKey<?, ?>> rhsReferences = this.rhs.getReferences();
        ArrayList result = new ArrayList(lhsReferences.size() + rhsReferences.size());
        result.addAll(lhsReferences);
        result.addAll(rhsReferences);
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        JoinType translatedType = this.translateType(ctx);
        Clause translatedClause = this.translateClause(translatedType);
        Keyword keyword = this.translateKeyword(ctx, translatedType);
        this.toSQLTable(ctx, this.lhs);
        switch (translatedType) {
            case LEFT_SEMI_JOIN: 
            case LEFT_ANTI_JOIN: {
                if (!Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN))) break;
                ArrayList<Condition> semiAntiJoinPredicates = (ArrayList<Condition>)ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN);
                if (semiAntiJoinPredicates == null) {
                    semiAntiJoinPredicates = new ArrayList<Condition>();
                    ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, semiAntiJoinPredicates);
                }
                Condition c = !this.using.isEmpty() ? this.usingCondition() : this.condition;
                switch (translatedType) {
                    case LEFT_SEMI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.exists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                        break;
                    }
                    case LEFT_ANTI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.notExists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                    }
                }
                return;
            }
        }
        ctx.formatIndentStart().formatSeparator().start(translatedClause).visit(keyword).sql(' ');
        this.toSQLTable(ctx, this.rhs);
        if (translatedType.qualified()) {
            ctx.formatIndentStart();
            this.toSQLJoinCondition(ctx);
            ctx.formatIndentEnd();
        } else if (JoinType.OUTER_APPLY == translatedType && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            ctx.formatIndentStart().formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(" 1 = 1").end(Clause.TABLE_JOIN_ON).formatIndentEnd();
        }
        ctx.end(translatedClause).formatIndentEnd();
    }

    private final Keyword translateKeyword(Context<?> ctx, JoinType translatedType) {
        Keyword keyword;
        switch (translatedType) {
            case JOIN: 
            case NATURAL_JOIN: {
                if (ctx.settings().getRenderOptionalInnerKeyword() == RenderOptionalKeyword.ON) {
                    keyword = translatedType.toKeyword(true);
                    break;
                }
                keyword = translatedType.toKeyword();
                break;
            }
            case LEFT_OUTER_JOIN: 
            case NATURAL_LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case NATURAL_RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case NATURAL_FULL_OUTER_JOIN: {
                if (ctx.settings().getRenderOptionalOuterKeyword() == RenderOptionalKeyword.OFF) {
                    keyword = translatedType.toKeyword(false);
                    break;
                }
                keyword = translatedType.toKeyword();
                break;
            }
            default: {
                keyword = translatedType.toKeyword();
            }
        }
        if (translatedType == JoinType.CROSS_APPLY && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            keyword = Keywords.K_CROSS_JOIN_LATERAL;
        } else if (translatedType == JoinType.OUTER_APPLY && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            keyword = ctx.settings().getRenderOptionalOuterKeyword() == RenderOptionalKeyword.OFF ? Keywords.K_LEFT_JOIN_LATERAL : Keywords.K_LEFT_OUTER_JOIN_LATERAL;
        }
        return keyword;
    }

    private void toSQLTable(Context<?> ctx, Table<?> table) {
        boolean wrap;
        boolean bl = wrap = table instanceof JoinTable && table == this.rhs;
        if (wrap) {
            ctx.sqlIndentStart('(');
        }
        ctx.visit(table);
        if (wrap) {
            ctx.sqlIndentEnd(')');
        }
    }

    final Clause translateClause(JoinType translatedType) {
        switch (translatedType) {
            case JOIN: {
                return Clause.TABLE_JOIN_INNER;
            }
            case CROSS_JOIN: {
                return Clause.TABLE_JOIN_CROSS;
            }
            case NATURAL_JOIN: {
                return Clause.TABLE_JOIN_NATURAL;
            }
            case LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_LEFT;
            }
            case RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_RIGHT;
            }
            case FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_FULL;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_LEFT;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_RIGHT;
            }
            case NATURAL_FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_FULL;
            }
            case CROSS_APPLY: {
                return Clause.TABLE_JOIN_CROSS_APPLY;
            }
            case OUTER_APPLY: {
                return Clause.TABLE_JOIN_OUTER_APPLY;
            }
            case LEFT_SEMI_JOIN: {
                return Clause.TABLE_JOIN_SEMI_LEFT;
            }
            case LEFT_ANTI_JOIN: {
                return Clause.TABLE_JOIN_ANTI_LEFT;
            }
            case STRAIGHT_JOIN: {
                return Clause.TABLE_JOIN_STRAIGHT;
            }
        }
        throw new IllegalArgumentException("Bad join type: " + translatedType);
    }

    final JoinType translateType(Context<?> ctx) {
        if (this.emulateCrossJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalLeftOuterJoin(ctx)) {
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (this.emulateNaturalRightOuterJoin(ctx)) {
            return JoinType.RIGHT_OUTER_JOIN;
        }
        if (this.emulateNaturalFullOuterJoin(ctx)) {
            return JoinType.FULL_OUTER_JOIN;
        }
        return this.type;
    }

    private final boolean emulateCrossJoin(Context<?> ctx) {
        return false;
    }

    private final boolean emulateNaturalJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_JOIN && EMULATE_NATURAL_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalLeftOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalRightOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalFullOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_FULL_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final void toSQLJoinCondition(Context<?> ctx) {
        if (!this.using.isEmpty()) {
            if (EMULATE_JOIN_USING.contains((Object)ctx.dialect())) {
                this.toSQLJoinCondition(ctx, this.usingCondition());
            } else {
                ctx.formatSeparator().start(Clause.TABLE_JOIN_USING).visit(Keywords.K_USING).sql(" (").visit(QueryPartListView.wrap(this.using).qualify(false)).sql(')').end(Clause.TABLE_JOIN_USING);
            }
        } else if (this.emulateNaturalJoin(ctx) || this.emulateNaturalLeftOuterJoin(ctx) || this.emulateNaturalRightOuterJoin(ctx) || this.emulateNaturalFullOuterJoin(ctx)) {
            this.toSQLJoinCondition(ctx, this.naturalCondition());
        } else {
            this.toSQLJoinCondition(ctx, this.condition);
        }
    }

    final Condition naturalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>(this.using.size());
        for (Field<?> field : this.lhs.fields()) {
            Field<?> other = this.rhs.field(field);
            if (other == null) continue;
            conditions.add(field.eq(other));
        }
        return DSL.and(conditions);
    }

    final Condition usingCondition() {
        return DSL.and(Tools.map(this.using, f -> Tools.qualify(this.lhs, f).eq(Tools.qualify(this.rhs, f))));
    }

    private final void toSQLJoinCondition(Context<?> context, Condition c) {
        context.formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(' ').visit(c).end(Clause.TABLE_JOIN_ON);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<Record> as(Name alias) {
        return new TableAlias<Record>(this, alias, c -> true);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, c -> true);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return this.lhs.getRecordType();
        }
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return new FieldsImpl<Record>(this.lhs.asTable().fields());
        }
        Field<?>[] l = this.lhs.asTable().fields();
        Field<?>[] r = this.rhs.asTable().fields();
        Field[] all = new Field[l.length + r.length];
        System.arraycopy(l, 0, all, 0, l.length);
        System.arraycopy(r, 0, all, l.length, r.length);
        return new FieldsImpl<Record>(all);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    public final JoinTable on(Condition conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Condition ... conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Field<Boolean> c) {
        return this.on(DSL.condition(c));
    }

    public final JoinTable on(SQL sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql, Object ... bindings) {
        this.and(sql, bindings);
        return this;
    }

    public final JoinTable on(String sql, QueryPart ... parts) {
        this.and(sql, parts);
        return this;
    }

    public final JoinTable onKey() throws DataAccessException {
        List<ForeignKey<?, ?>> leftToRight = this.lhs.getReferencesTo(this.rhs);
        List<ForeignKey<?, ?>> rightToLeft = this.rhs.getReferencesTo(this.lhs);
        if (leftToRight.size() == 1 && rightToLeft.size() == 0) {
            return this.onKey(leftToRight.get(0), this.lhs, this.rhs);
        }
        if (rightToLeft.size() == 1 && leftToRight.size() == 0) {
            return this.onKey(rightToLeft.get(0), this.rhs, this.lhs);
        }
        if (rightToLeft.isEmpty() && leftToRight.isEmpty()) {
            throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, leftToRight, rightToLeft);
        }
        throw this.onKeyException(OnKeyExceptionReason.AMBIGUOUS, null, null);
    }

    public final JoinTable onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        block5: {
            ArrayList unaliased;
            block6: {
                if (keyFields == null || keyFields.length <= 0) break block5;
                unaliased = new ArrayList(Arrays.asList(keyFields));
                for (int i = 0; i < unaliased.size(); ++i) {
                    TableField f = (TableField)unaliased.get(i);
                    Alias alias = Tools.alias(f.getTable());
                    if (alias == null) continue;
                    unaliased.set(i, (TableField)alias.wrapped().field(f));
                }
                if (!Tools.containsUnaliasedTable(this.lhs, keyFields[0].getTable())) break block6;
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                    return this.onKey((ForeignKey)key);
                }
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased)) continue;
                    return this.onKey((ForeignKey)key);
                }
                break block5;
            }
            if (!Tools.containsUnaliasedTable(this.rhs, keyFields[0].getTable())) break block5;
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                return this.onKey((ForeignKey)key);
            }
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(unaliased)) continue;
                return this.onKey((ForeignKey)key);
            }
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    public final JoinTable onKey(ForeignKey<?, ?> key) {
        if (Tools.containsUnaliasedTable(this.lhs, key.getTable())) {
            return this.onKey(key, this.lhs, this.rhs);
        }
        if (Tools.containsUnaliasedTable(this.rhs, key.getTable())) {
            return this.onKey(key, this.rhs, this.lhs);
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    private final JoinTable onKey(ForeignKey<?, ?> key, Table<?> fk, Table<?> pk) {
        JoinTable result = this;
        TableField<R, ?>[] references = key.getFieldsArray();
        TableField<?, ?>[] referenced = key.getKeyFieldsArray();
        for (int i = 0; i < references.length; ++i) {
            Field f1 = fk.field(references[i]);
            Field f2 = pk.field(referenced[i]);
            result.and(f1.equal(f2));
        }
        return result;
    }

    private final DataAccessException onKeyException(OnKeyExceptionReason reason, List<?> leftToRight, List<?> rightToLeft) {
        switch (reason) {
            case AMBIGUOUS: {
                return new DataAccessException("Key ambiguous between tables [" + this.lhs + "] and [" + this.rhs + "]. Found: " + leftToRight + " and " + rightToLeft);
            }
        }
        return new DataAccessException("No matching Key found between tables [" + this.lhs + "] and [" + this.rhs + "]");
    }

    public final JoinTable using(Field<?> ... fields) {
        return this.using(Arrays.asList(fields));
    }

    public final JoinTable using(Collection<? extends Field<?>> fields) {
        this.using.addAll((Collection<Field<?>>)fields);
        return this;
    }

    public final JoinTable and(Condition c) {
        this.condition.addConditions(c);
        return this;
    }

    public final JoinTable and(Field<Boolean> c) {
        return this.and(DSL.condition(c));
    }

    public final JoinTable and(SQL sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql, Object ... bindings) {
        return this.and(DSL.condition(sql, bindings));
    }

    public final JoinTable and(String sql, QueryPart ... parts) {
        return this.and(DSL.condition(sql, parts));
    }

    public final JoinTable andNot(Condition c) {
        return this.and(c.not());
    }

    public final JoinTable andNot(Field<Boolean> c) {
        return this.andNot(DSL.condition(c));
    }

    public final JoinTable andExists(Select<?> select) {
        return this.and(DSL.exists(select));
    }

    public final JoinTable andNotExists(Select<?> select) {
        return this.and(DSL.notExists(select));
    }

    public final JoinTable or(Condition c) {
        this.condition.addConditions(Operator.OR, c);
        return this;
    }

    public final JoinTable or(Field<Boolean> c) {
        return this.or(DSL.condition(c));
    }

    public final JoinTable or(SQL sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql, Object ... bindings) {
        return this.or(DSL.condition(sql, bindings));
    }

    public final JoinTable or(String sql, QueryPart ... parts) {
        return this.or(DSL.condition(sql, parts));
    }

    public final JoinTable orNot(Condition c) {
        return this.or(c.not());
    }

    public final JoinTable orNot(Field<Boolean> c) {
        return this.orNot(DSL.condition(c));
    }

    public final JoinTable orExists(Select<?> select) {
        return this.or(DSL.exists(select));
    }

    public final JoinTable orNotExists(Select<?> select) {
        return this.or(DSL.notExists(select));
    }

    private static enum OnKeyExceptionReason {
        AMBIGUOUS,
        NOT_FOUND;

    }
}

