/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.particles;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public abstract class Laser {
    protected final int distanceSquared;
    protected final int duration;
    protected boolean durationInTicks = false;
    protected Location start;
    protected Location end;
    protected Plugin plugin;
    protected BukkitRunnable main;
    protected BukkitTask startMove;
    protected BukkitTask endMove;
    protected Set<Player> show = ConcurrentHashMap.newKeySet();
    private Set<Player> seen = new HashSet<Player>();
    private List<Runnable> executeEnd = new ArrayList<Runnable>(1);

    protected Laser(Location start, Location end, int duration, int distance) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Laser Beam API is disabled. An error has occured during initialization.");
        }
        if (start.getWorld() != end.getWorld()) {
            throw new IllegalArgumentException("Locations do not belong to the same worlds.");
        }
        this.start = start.clone();
        this.end = end.clone();
        this.duration = duration;
        this.distanceSquared = distance < 0 ? -1 : distance * distance;
    }

    public Laser executeEnd(Runnable runnable) {
        this.executeEnd.add(runnable);
        return this;
    }

    public Laser durationInTicks() {
        this.durationInTicks = true;
        return this;
    }

    public void start(Plugin plugin) {
        if (this.main != null) {
            throw new IllegalStateException("Task already started");
        }
        this.plugin = plugin;
        this.main = new BukkitRunnable(){
            int time = 0;

            public void run() {
                try {
                    if (this.time == Laser.this.duration) {
                        this.cancel();
                        return;
                    }
                    if (!Laser.this.durationInTicks || this.time % 20 == 0) {
                        for (Player p : Laser.this.start.getWorld().getPlayers()) {
                            if (Laser.this.isCloseEnough(p)) {
                                if (!Laser.this.show.add(p)) continue;
                                Laser.this.sendStartPackets(p, !Laser.this.seen.add(p));
                                continue;
                            }
                            if (!Laser.this.show.remove(p)) continue;
                            Laser.this.sendDestroyPackets(p);
                        }
                    }
                    ++this.time;
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                Laser.this.main = null;
                try {
                    for (Player p : Laser.this.show) {
                        Laser.this.sendDestroyPackets(p);
                    }
                    Laser.this.show.clear();
                    Laser.this.executeEnd.forEach(Runnable::run);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        };
        this.main.runTaskTimerAsynchronously(plugin, 0L, this.durationInTicks ? 1L : 20L);
    }

    public void stop() {
        if (this.main == null) {
            throw new IllegalStateException("Task not started");
        }
        this.main.cancel();
    }

    public boolean isStarted() {
        return this.main != null;
    }

    public abstract LaserType getLaserType();

    public abstract void moveStart(Location var1) throws ReflectiveOperationException;

    public abstract void moveEnd(Location var1) throws ReflectiveOperationException;

    public Location getStart() {
        return this.start.clone();
    }

    public Location getEnd() {
        return this.end.clone();
    }

    public void moveStart(Location location, int ticks, Runnable callback) {
        this.startMove = this.moveInternal(location, ticks, this.startMove, this::getStart, this::moveStart, callback);
    }

    public void moveEnd(Location location, int ticks, Runnable callback) {
        this.endMove = this.moveInternal(location, ticks, this.endMove, this::getEnd, this::moveEnd, callback);
    }

    private BukkitTask moveInternal(final Location location, final int ticks, BukkitTask oldTask, final Supplier<Location> locationSupplier, final ReflectiveConsumer<Location> moveConsumer, final Runnable callback) {
        if (ticks <= 0) {
            throw new IllegalArgumentException("Ticks must be a positive value");
        }
        if (this.plugin == null) {
            throw new IllegalStateException("The laser must have been started a least once");
        }
        if (oldTask != null && !oldTask.isCancelled()) {
            oldTask.cancel();
        }
        return new BukkitRunnable(){
            double xPerTick;
            double yPerTick;
            double zPerTick;
            int elapsed;
            {
                this.xPerTick = (location.getX() - ((Location)locationSupplier.get()).getX()) / (double)ticks;
                this.yPerTick = (location.getY() - ((Location)locationSupplier.get()).getY()) / (double)ticks;
                this.zPerTick = (location.getZ() - ((Location)locationSupplier.get()).getZ()) / (double)ticks;
                this.elapsed = 0;
            }

            public void run() {
                try {
                    moveConsumer.accept(((Location)locationSupplier.get()).add(this.xPerTick, this.yPerTick, this.zPerTick));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    this.cancel();
                    return;
                }
                if (++this.elapsed == ticks) {
                    this.cancel();
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    protected void moveFakeEntity(Location location, int entityId, Object fakeEntity) throws ReflectiveOperationException {
        if (fakeEntity != null) {
            Packets.moveFakeEntity(fakeEntity, location);
        }
        if (this.main == null) {
            return;
        }
        Object packet = fakeEntity == null ? Packets.createPacketMoveEntity(location, entityId) : Packets.createPacketMoveEntity(fakeEntity);
        for (Player p : this.show) {
            Packets.sendPackets(p, packet);
        }
    }

    protected abstract void sendStartPackets(Player var1, boolean var2) throws ReflectiveOperationException;

    protected abstract void sendDestroyPackets(Player var1) throws ReflectiveOperationException;

    protected boolean isCloseEnough(Player player) {
        if (this.distanceSquared == -1) {
            return true;
        }
        Location location = player.getLocation();
        return this.getStart().distanceSquared(location) <= (double)this.distanceSquared || this.getEnd().distanceSquared(location) <= (double)this.distanceSquared;
    }

    private static class Packets {
        private static AtomicInteger lastIssuedEID = new AtomicInteger(2000000000);
        private static Logger logger;
        private static int version;
        private static int versionMinor;
        private static String npack;
        private static String cpack;
        private static ProtocolMappings mappings;
        private static int crystalID;
        private static Object crystalType;
        private static Object squidType;
        private static Object guardianType;
        private static Constructor<?> crystalConstructor;
        private static Constructor<?> squidConstructor;
        private static Constructor<?> guardianConstructor;
        private static Object watcherObject1;
        private static Object watcherObject2;
        private static Object watcherObject3;
        private static Object watcherObject4;
        private static Object watcherObject5;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Constructor<?> blockPositionConstructor;
        private static Constructor<?> packetSpawnLiving;
        private static Constructor<?> packetSpawnNormal;
        private static Constructor<?> packetRemove;
        private static Constructor<?> packetTeleport;
        private static Constructor<?> packetMetadata;
        private static Class<?> packetTeam;
        private static Method createTeamPacket;
        private static Constructor<?> createTeam;
        private static Constructor<?> createScoreboard;
        private static Method setTeamPush;
        private static Object pushNever;
        private static Method getTeamPlayers;
        private static Method getHandle;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Method setLocation;
        private static Method setUUID;
        private static Method setID;
        private static Object fakeSquid;
        private static Object fakeSquidWatcher;
        private static Object nmsWorld;
        public static boolean enabled;

        private Packets() {
        }

        static int generateEID() {
            return lastIssuedEID.getAndIncrement();
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                if (packet == null) continue;
                sendPacket.invoke(connection, packet);
            }
        }

        public static Object createFakeDataWatcher() throws ReflectiveOperationException {
            Object watcher = watcherConstructor.newInstance(fakeSquid);
            if (version > 13) {
                Packets.setField(watcher, "registrationLocked", false);
            }
            return watcher;
        }

        public static void setDirtyWatcher(Object watcher) throws ReflectiveOperationException {
            if (version >= 15) {
                watcherDirty.invoke(watcher, watcherObject1);
            }
        }

        public static Object createSquid(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = squidConstructor.newInstance(squidType, nmsWorld);
            Packets.setEntityIDs(entity, uuid, id);
            Packets.moveFakeEntity(entity, location);
            return entity;
        }

        public static Object createGuardian(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = guardianConstructor.newInstance(guardianType, nmsWorld);
            Packets.setEntityIDs(entity, uuid, id);
            Packets.moveFakeEntity(entity, location);
            return entity;
        }

        public static Object createCrystal(Location location, UUID uuid, int id) throws ReflectiveOperationException {
            Object entity = crystalConstructor.newInstance(nmsWorld, location.getX(), location.getY(), location.getZ());
            Packets.setEntityIDs(entity, uuid, id);
            return entity;
        }

        public static Object createPacketEntitySpawnLiving(Location location, int typeID, UUID uuid, int id) throws ReflectiveOperationException {
            Object packet = packetSpawnLiving.newInstance(new Object[0]);
            Packets.setField(packet, "a", id);
            Packets.setField(packet, "b", uuid);
            Packets.setField(packet, "c", typeID);
            Packets.setField(packet, "d", location.getX());
            Packets.setField(packet, "e", location.getY());
            Packets.setField(packet, "f", location.getZ());
            Packets.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
            if (version <= 14) {
                Packets.setField(packet, "m", fakeSquidWatcher);
            }
            return packet;
        }

        public static Object createPacketEntitySpawnNormal(Location location, int typeID, Object type, int id) throws ReflectiveOperationException {
            Object packet = packetSpawnNormal.newInstance(new Object[0]);
            Packets.setField(packet, "a", id);
            Packets.setField(packet, "b", UUID.randomUUID());
            Packets.setField(packet, "c", location.getX());
            Packets.setField(packet, "d", location.getY());
            Packets.setField(packet, "e", location.getZ());
            Packets.setField(packet, "i", (int)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "j", (int)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(packet, "k", version < 13 ? Integer.valueOf(typeID) : type);
            return packet;
        }

        public static Object createPacketEntitySpawnLiving(Object entity) throws ReflectiveOperationException {
            return packetSpawnLiving.newInstance(entity);
        }

        public static Object createPacketEntitySpawnNormal(Object entity) throws ReflectiveOperationException {
            return packetSpawnNormal.newInstance(entity);
        }

        public static void initGuardianWatcher(Object watcher, int targetId) throws ReflectiveOperationException {
            Packets.tryWatcherSet(watcher, watcherObject1, (byte)32);
            Packets.tryWatcherSet(watcher, watcherObject2, Boolean.FALSE);
            Packets.tryWatcherSet(watcher, watcherObject3, targetId);
        }

        public static void setCrystalWatcher(Object watcher, Location target) throws ReflectiveOperationException {
            Object blockPosition = blockPositionConstructor.newInstance(target.getBlockX(), target.getBlockY(), target.getBlockZ());
            Packets.tryWatcherSet(watcher, watcherObject4, version < 13 ? com.google.common.base.Optional.of(blockPosition) : Optional.of(blockPosition));
            Packets.tryWatcherSet(watcher, watcherObject5, Boolean.FALSE);
        }

        public static Object[] createPacketsRemoveEntities(int ... entitiesId) throws ReflectiveOperationException {
            Object[] packets;
            if (version == 17 && versionMinor == 0) {
                packets = new Object[entitiesId.length];
                for (int i = 0; i < entitiesId.length; ++i) {
                    packets[i] = packetRemove.newInstance(entitiesId[i]);
                }
            } else {
                packets = new Object[]{packetRemove.newInstance(new Object[]{entitiesId})};
            }
            return packets;
        }

        public static Object createPacketMoveEntity(Location location, int entityId) throws ReflectiveOperationException {
            Object packet = packetTeleport.newInstance(new Object[0]);
            Packets.setField(packet, "a", entityId);
            Packets.setField(packet, "b", location.getX());
            Packets.setField(packet, "c", location.getY());
            Packets.setField(packet, "d", location.getZ());
            Packets.setField(packet, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
            Packets.setField(packet, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
            Packets.setField(packet, "g", true);
            return packet;
        }

        public static void setEntityIDs(Object entity, UUID uuid, int id) throws ReflectiveOperationException {
            setUUID.invoke(entity, uuid);
            setID.invoke(entity, id);
        }

        public static void moveFakeEntity(Object entity, Location location) throws ReflectiveOperationException {
            setLocation.invoke(entity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }

        public static Object createPacketMoveEntity(Object entity) throws ReflectiveOperationException {
            return packetTeleport.newInstance(entity);
        }

        public static Object createPacketTeamCreate(String teamName, UUID ... entities) throws ReflectiveOperationException {
            Object packet;
            if (version < 17) {
                packet = packetTeam.newInstance();
                Packets.setField(packet, "a", teamName);
                Packets.setField(packet, "i", 0);
                Packets.setField(packet, "f", "never");
                Collection players = (Collection)Packets.getField(packetTeam, "h", packet);
                for (UUID entity : entities) {
                    players.add(entity.toString());
                }
            } else {
                Object team = createTeam.newInstance(createScoreboard.newInstance(new Object[0]), teamName);
                setTeamPush.invoke(team, pushNever);
                Collection players = (Collection)getTeamPlayers.invoke(team, new Object[0]);
                for (UUID entity : entities) {
                    players.add(entity.toString());
                }
                packet = createTeamPacket.invoke(null, team, true);
            }
            return packet;
        }

        private static Object createPacketMetadata(int entityId, Object watcher) throws ReflectiveOperationException {
            if (version < 19 || version == 19 && versionMinor < 3) {
                return packetMetadata.newInstance(entityId, watcher, false);
            }
            return packetMetadata.newInstance(entityId, watcherPack.invoke(watcher, new Object[0]));
        }

        private static void tryWatcherSet(Object watcher, Object watcherObject, Object watcherData) throws ReflectiveOperationException {
            block2: {
                try {
                    watcherSet.invoke(watcher, watcherObject, watcherData);
                }
                catch (InvocationTargetException ex) {
                    watcherRegister.invoke(watcher, watcherObject, watcherData);
                    if (version < 15) break block2;
                    watcherDirty.invoke(watcher, watcherObject);
                }
            }
        }

        private static Method getMethod(Class<?> clazz, String name) throws NoSuchMethodException {
            for (Method m4 : clazz.getDeclaredMethods()) {
                if (!m4.getName().equals(name)) continue;
                return m4;
            }
            throw new NoSuchMethodException(name + " in " + clazz.getName());
        }

        private static void setField(Object instance, String name, Object value) throws ReflectiveOperationException {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }

        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        private static Class<?> getNMSClass(String package17, String className) throws ClassNotFoundException {
            return Class.forName((String)(version < 17 ? npack : "net.minecraft." + package17) + "." + className);
        }

        static {
            npack = "net.minecraft.server." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            crystalID = 51;
            enabled = false;
            try {
                Object[] objectArray;
                Class[] classArray;
                Class[] classArray2;
                Constructor<?> constructor;
                Class[] classArray3;
                logger = new Logger("GuardianBeam", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GuardianBeam] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String[] versions = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).split("_");
                version = Integer.parseInt(versions[1]);
                versionMinor = version >= 17 ? ((versions = Bukkit.getBukkitVersion().split("-R")[0].split("\\.")).length <= 2 ? 0 : Integer.parseInt(versions[2])) : Integer.parseInt(versions[2].substring(1));
                logger.info("Found server version 1." + version + "." + versionMinor);
                mappings = ProtocolMappings.getMappings(version);
                if (mappings == null) {
                    mappings = ProtocolMappings.values()[ProtocolMappings.values().length - 1];
                    logger.warning("Loaded not matching version of the mappings for your server version (1." + version + "." + versionMinor + ")");
                }
                logger.info("Loaded mappings " + mappings.name());
                Class<?> entityTypesClass = Packets.getNMSClass("world.entity", "EntityTypes");
                Class<?> entityClass = Packets.getNMSClass("world.entity", "Entity");
                Class<?> crystalClass = Packets.getNMSClass("world.entity.boss.enderdragon", "EntityEnderCrystal");
                Class<?> squidClass = Packets.getNMSClass("world.entity.animal", "EntitySquid");
                Class<?> guardianClass = Packets.getNMSClass("world.entity.monster", "EntityGuardian");
                watcherObject1 = Packets.getField(entityClass, mappings.getWatcherFlags(), null);
                watcherObject2 = Packets.getField(guardianClass, mappings.getWatcherSpikes(), null);
                watcherObject3 = Packets.getField(guardianClass, mappings.getWatcherTargetEntity(), null);
                watcherObject4 = Packets.getField(crystalClass, mappings.getWatcherTargetLocation(), null);
                watcherObject5 = Packets.getField(crystalClass, mappings.getWatcherBasePlate(), null);
                if (version >= 13) {
                    crystalType = entityTypesClass.getDeclaredField(mappings.getCrystalTypeName()).get(null);
                    if (version >= 17) {
                        squidType = entityTypesClass.getDeclaredField(mappings.getSquidTypeName()).get(null);
                        guardianType = entityTypesClass.getDeclaredField(mappings.getGuardianTypeName()).get(null);
                    }
                }
                Class<?> dataWatcherClass = Packets.getNMSClass("network.syncher", "DataWatcher");
                watcherConstructor = dataWatcherClass.getDeclaredConstructor(entityClass);
                if (version >= 18) {
                    watcherSet = dataWatcherClass.getDeclaredMethod("b", watcherObject1.getClass(), Object.class);
                    watcherRegister = dataWatcherClass.getDeclaredMethod("a", watcherObject1.getClass(), Object.class);
                } else {
                    watcherSet = Packets.getMethod(dataWatcherClass, "set");
                    watcherRegister = Packets.getMethod(dataWatcherClass, "register");
                }
                if (version >= 15) {
                    watcherDirty = Packets.getMethod(dataWatcherClass, "markDirty");
                }
                if (version > 19 || version == 19 && versionMinor >= 3) {
                    watcherPack = dataWatcherClass.getDeclaredMethod("b", new Class[0]);
                }
                Class<?> clazz = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity");
                if (version < 17) {
                    classArray3 = new Class[]{};
                } else {
                    Class[] classArray4 = new Class[1];
                    classArray3 = classArray4;
                    classArray4[0] = Packets.getNMSClass("world.entity", "Entity");
                }
                packetSpawnNormal = clazz.getDeclaredConstructor(classArray3);
                if (version >= 19) {
                    constructor = packetSpawnNormal;
                } else {
                    Class[] classArray5;
                    Class<?> clazz2 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntityLiving");
                    if (version < 17) {
                        classArray5 = new Class[]{};
                    } else {
                        Class[] classArray6 = new Class[1];
                        classArray5 = classArray6;
                        classArray6[0] = Packets.getNMSClass("world.entity", "EntityLiving");
                    }
                    constructor = clazz2.getDeclaredConstructor(classArray5);
                }
                packetSpawnLiving = constructor;
                packetRemove = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy").getDeclaredConstructor(version == 17 && versionMinor == 0 ? Integer.TYPE : int[].class);
                Class<?> clazz3 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
                if (version < 19 || version == 19 && versionMinor < 3) {
                    Class[] classArray7 = new Class[3];
                    classArray7[0] = Integer.TYPE;
                    classArray7[1] = dataWatcherClass;
                    classArray2 = classArray7;
                    classArray7[2] = Boolean.TYPE;
                } else {
                    Class[] classArray8 = new Class[2];
                    classArray8[0] = Integer.TYPE;
                    classArray2 = classArray8;
                    classArray8[1] = List.class;
                }
                packetMetadata = clazz3.getDeclaredConstructor(classArray2);
                Class<?> clazz4 = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityTeleport");
                if (version < 17) {
                    classArray = new Class[]{};
                } else {
                    Class[] classArray9 = new Class[1];
                    classArray = classArray9;
                    classArray9[0] = entityClass;
                }
                packetTeleport = clazz4.getDeclaredConstructor(classArray);
                packetTeam = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam");
                blockPositionConstructor = Packets.getNMSClass("core", "BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                nmsWorld = Class.forName(cpack + "CraftWorld").getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                squidConstructor = squidClass.getDeclaredConstructors()[0];
                if (version >= 17) {
                    guardianConstructor = guardianClass.getDeclaredConstructors()[0];
                    crystalConstructor = crystalClass.getDeclaredConstructor(nmsWorld.getClass().getSuperclass(), Double.TYPE, Double.TYPE, Double.TYPE);
                }
                if (version < 14) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = nmsWorld;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = entityTypesClass.getDeclaredField(mappings.getSquidTypeName()).get(null);
                    objectArray = objectArray3;
                    objectArray3[1] = nmsWorld;
                }
                Object[] entityConstructorParams = objectArray;
                fakeSquid = squidConstructor.newInstance(entityConstructorParams);
                fakeSquidWatcher = Packets.createFakeDataWatcher();
                Packets.tryWatcherSet(fakeSquidWatcher, watcherObject1, (byte)32);
                getHandle = Class.forName(cpack + "entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
                playerConnection = Packets.getNMSClass("server.level", "EntityPlayer").getDeclaredField(version < 17 ? "playerConnection" : (version < 20 ? "b" : "c"));
                playerConnection.setAccessible(true);
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod(version < 18 ? "sendPacket" : (version >= 20 && versionMinor >= 2 ? "b" : "a"), Packets.getNMSClass("network.protocol", "Packet"));
                if (version >= 17) {
                    setLocation = entityClass.getDeclaredMethod(version < 18 ? "setLocation" : "a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                    setUUID = entityClass.getDeclaredMethod("a_", UUID.class);
                    setID = entityClass.getDeclaredMethod("e", Integer.TYPE);
                    createTeamPacket = packetTeam.getMethod("a", Packets.getNMSClass("world.scores", "ScoreboardTeam"), Boolean.TYPE);
                    Class<?> scoreboardClass = Packets.getNMSClass("world.scores", "Scoreboard");
                    Class<?> teamClass = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                    Class<?> pushClass = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                    createTeam = teamClass.getDeclaredConstructor(scoreboardClass, String.class);
                    createScoreboard = scoreboardClass.getDeclaredConstructor(new Class[0]);
                    setTeamPush = teamClass.getDeclaredMethod(mappings.getTeamSetCollision(), pushClass);
                    pushNever = pushClass.getDeclaredField("b").get(null);
                    getTeamPlayers = teamClass.getDeclaredMethod(mappings.getTeamGetPlayers(), new Class[0]);
                }
                enabled = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMsg = "Laser Beam reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.";
                if (logger == null) {
                    System.err.println(errorMsg);
                }
                logger.severe(errorMsg);
            }
        }

        private static enum ProtocolMappings {
            V1_9(9, "Z", "bA", "bB", "b", "c", 94, 68),
            V1_10(10, V1_9),
            V1_11(11, V1_10),
            V1_12(12, V1_11),
            V1_13(13, "ac", "bF", "bG", "b", "c", 70, 28),
            V1_14(14, "W", "b", "bD", "c", "d", 73, 30),
            V1_15(15, "T", "b", "bA", "c", "d", 74, 31),
            V1_16(16, null, "b", "d", "c", "d", -1, 31){

                @Override
                public int getSquidID() {
                    return versionMinor < 2 ? 74 : 81;
                }

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 2 ? "T" : "S";
                }
            }
            ,
            V1_17(17, "Z", "b", "e", "c", "d", 86, 35, "K", "aJ", "u", "setCollisionRule", "getPlayerNameSet"),
            V1_18(18, null, "b", "e", "c", "d", 86, 35, "K", "aJ", "u", "a", "g"){

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 2 ? "aa" : "Z";
                }
            }
            ,
            V1_19(19, null, "b", "e", "c", "d", 89, 38, null, null, "w", "a", "g"){

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 4 ? "Z" : "an";
                }

                @Override
                public int getGuardianID() {
                    return versionMinor < 3 ? 38 : 39;
                }

                @Override
                public String getSquidTypeName() {
                    if (versionMinor < 3) {
                        return "aM";
                    }
                    if (versionMinor == 3) {
                        return "aN";
                    }
                    return "aT";
                }

                @Override
                public String getGuardianTypeName() {
                    if (versionMinor < 3) {
                        return "N";
                    }
                    if (versionMinor == 3) {
                        return "O";
                    }
                    return "V";
                }
            }
            ,
            V1_20(20, null, "b", "e", "c", "d", 89, 38, "V", "aT", "B", "a", "g"){

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 2 ? "an" : "ao";
                }
            };

            private final int major;
            private final String watcherFlags;
            private final String watcherSpikes;
            private final String watcherTargetEntity;
            private final String watcherTargetLocation;
            private final String watcherBasePlate;
            private final int squidID;
            private final int guardianID;
            private final String guardianTypeName;
            private final String squidTypeName;
            private final String crystalTypeName;
            private final String teamSetCollision;
            private final String teamGetPlayers;

            private ProtocolMappings(int major, ProtocolMappings parent) {
                this(major, parent.watcherFlags, parent.watcherSpikes, parent.watcherTargetEntity, parent.watcherTargetLocation, parent.watcherBasePlate, parent.squidID, parent.guardianID, parent.guardianTypeName, parent.squidTypeName, parent.crystalTypeName, parent.teamSetCollision, parent.teamGetPlayers);
            }

            private ProtocolMappings(int major, String watcherFlags, String watcherSpikes, String watcherTargetEntity, String watcherTargetLocation, String watcherBasePlate, int squidID, int guardianID) {
                this(major, watcherFlags, watcherSpikes, watcherTargetEntity, watcherTargetLocation, watcherBasePlate, squidID, guardianID, null, "SQUID", "END_CRYSTAL", null, null);
            }

            private ProtocolMappings(int major, String watcherFlags, String watcherSpikes, String watcherTargetEntity, String watcherTargetLocation, String watcherBasePlate, int squidID, int guardianID, String guardianTypeName, String squidTypeName, String crystalTypeName, String teamSetCollision, String teamGetPlayers) {
                this.major = major;
                this.watcherFlags = watcherFlags;
                this.watcherSpikes = watcherSpikes;
                this.watcherTargetEntity = watcherTargetEntity;
                this.watcherTargetLocation = watcherTargetLocation;
                this.watcherBasePlate = watcherBasePlate;
                this.squidID = squidID;
                this.guardianID = guardianID;
                this.guardianTypeName = guardianTypeName;
                this.squidTypeName = squidTypeName;
                this.crystalTypeName = crystalTypeName;
                this.teamSetCollision = teamSetCollision;
                this.teamGetPlayers = teamGetPlayers;
            }

            public int getMajor() {
                return this.major;
            }

            public String getWatcherFlags() {
                return this.watcherFlags;
            }

            public String getWatcherSpikes() {
                return this.watcherSpikes;
            }

            public String getWatcherTargetEntity() {
                return this.watcherTargetEntity;
            }

            public String getWatcherTargetLocation() {
                return this.watcherTargetLocation;
            }

            public String getWatcherBasePlate() {
                return this.watcherBasePlate;
            }

            public int getSquidID() {
                return this.squidID;
            }

            public int getGuardianID() {
                return this.guardianID;
            }

            public String getGuardianTypeName() {
                return this.guardianTypeName;
            }

            public String getSquidTypeName() {
                return this.squidTypeName;
            }

            public String getCrystalTypeName() {
                return this.crystalTypeName;
            }

            public String getTeamSetCollision() {
                return this.teamSetCollision;
            }

            public String getTeamGetPlayers() {
                return this.teamGetPlayers;
            }

            public static ProtocolMappings getMappings(int major) {
                for (ProtocolMappings map : ProtocolMappings.values()) {
                    if (major != map.getMajor()) continue;
                    return map;
                }
                return null;
            }
        }
    }

    @FunctionalInterface
    public static interface ReflectiveConsumer<T> {
        public void accept(T var1) throws ReflectiveOperationException;
    }

    public static enum LaserType {
        GUARDIAN,
        ENDER_CRYSTAL;


        public Laser create(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            switch (this) {
                case ENDER_CRYSTAL: {
                    return new CrystalLaser(start, end, duration, distance);
                }
                case GUARDIAN: {
                    return new GuardianLaser(start, end, duration, distance);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class CrystalLaser
    extends Laser {
        private Object createCrystalPacket;
        private Object metadataPacketCrystal;
        private Object[] destroyPackets;
        private Object fakeCrystalDataWatcher;
        private final Object crystal;
        private final int crystalID = Packets.generateEID();

        public CrystalLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, end, duration, distance);
            this.fakeCrystalDataWatcher = Packets.createFakeDataWatcher();
            Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, end);
            this.crystal = Packets.version < 17 ? null : Packets.createCrystal(start, UUID.randomUUID(), this.crystalID);
            this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.crystalID);
        }

        private Object getCrystalSpawnPacket() throws ReflectiveOperationException {
            if (this.createCrystalPacket == null) {
                this.createCrystalPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnNormal(this.start, Packets.crystalID, Packets.crystalType, this.crystalID) : Packets.createPacketEntitySpawnNormal(this.crystal);
            }
            return this.createCrystalPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.ENDER_CRYSTAL;
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.getCrystalSpawnPacket());
            Packets.sendPackets(p, this.metadataPacketCrystal);
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location.clone();
            this.createCrystalPacket = null;
            this.moveFakeEntity(this.start, this.crystalID, this.crystal);
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            if (this.end.equals((Object)location)) {
                return;
            }
            this.end = location.clone();
            if (this.main != null) {
                Packets.setCrystalWatcher(this.fakeCrystalDataWatcher, location);
                this.metadataPacketCrystal = Packets.createPacketMetadata(this.crystalID, this.fakeCrystalDataWatcher);
                for (Player p : this.show) {
                    Packets.sendPackets(p, this.metadataPacketCrystal);
                }
            }
        }
    }

    public static class GuardianLaser
    extends Laser {
        private static AtomicInteger teamID = new AtomicInteger(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
        private Object createGuardianPacket;
        private Object createSquidPacket;
        private Object teamCreatePacket;
        private Object[] destroyPackets;
        private Object metadataPacketGuardian;
        private Object metadataPacketSquid;
        private Object fakeGuardianDataWatcher;
        private final UUID squidUUID = UUID.randomUUID();
        private final UUID guardianUUID = UUID.randomUUID();
        private final int squidID = Packets.generateEID();
        private final int guardianID = Packets.generateEID();
        private Object squid;
        private Object guardian;
        private int targetID;
        private UUID targetUUID;
        protected LivingEntity endEntity;
        private Location correctStart;
        private Location correctEnd;

        public GuardianLaser(Location start, Location end, int duration, int distance) throws ReflectiveOperationException {
            super(start, end, duration, distance);
            this.initSquid();
            this.targetID = this.squidID;
            this.targetUUID = this.squidUUID;
            this.initLaser();
        }

        public GuardianLaser(Location start, LivingEntity endEntity, int duration, int distance) throws ReflectiveOperationException {
            super(start, endEntity.getLocation(), duration, distance);
            this.targetID = endEntity.getEntityId();
            this.targetUUID = endEntity.getUniqueId();
            this.initLaser();
        }

        private void initLaser() throws ReflectiveOperationException {
            this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
            Packets.initGuardianWatcher(this.fakeGuardianDataWatcher, this.targetID);
            if (Packets.version >= 17) {
                this.guardian = Packets.createGuardian(this.getCorrectStart(), this.guardianUUID, this.guardianID);
            }
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.fakeGuardianDataWatcher);
            this.teamCreatePacket = Packets.createPacketTeamCreate("noclip" + teamID.getAndIncrement(), this.squidUUID, this.guardianUUID);
            this.destroyPackets = Packets.createPacketsRemoveEntities(this.squidID, this.guardianID);
        }

        private void initSquid() throws ReflectiveOperationException {
            if (Packets.version >= 17) {
                this.squid = Packets.createSquid(this.getCorrectEnd(), this.squidUUID, this.squidID);
            }
            this.metadataPacketSquid = Packets.createPacketMetadata(this.squidID, Packets.fakeSquidWatcher);
            Packets.setDirtyWatcher(Packets.fakeSquidWatcher);
        }

        private Object getGuardianSpawnPacket() throws ReflectiveOperationException {
            if (this.createGuardianPacket == null) {
                this.createGuardianPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnLiving(this.getCorrectStart(), Packets.mappings.getGuardianID(), this.guardianUUID, this.guardianID) : Packets.createPacketEntitySpawnLiving(this.guardian);
            }
            return this.createGuardianPacket;
        }

        private Object getSquidSpawnPacket() throws ReflectiveOperationException {
            if (this.createSquidPacket == null) {
                this.createSquidPacket = Packets.version < 17 ? Packets.createPacketEntitySpawnLiving(this.getCorrectEnd(), Packets.mappings.getSquidID(), this.squidUUID, this.squidID) : Packets.createPacketEntitySpawnLiving(this.squid);
            }
            return this.createSquidPacket;
        }

        @Override
        public LaserType getLaserType() {
            return LaserType.GUARDIAN;
        }

        public void attachEndEntity(LivingEntity entity) throws ReflectiveOperationException {
            if (entity.getWorld() != this.start.getWorld()) {
                throw new IllegalArgumentException("Attached entity is not in the same world as the laser.");
            }
            this.endEntity = entity;
            this.setTargetEntity(entity.getUniqueId(), entity.getEntityId());
        }

        public Entity getEndEntity() {
            return this.endEntity;
        }

        private void setTargetEntity(UUID uuid, int id) throws ReflectiveOperationException {
            this.targetUUID = uuid;
            this.targetID = id;
            this.fakeGuardianDataWatcher = Packets.createFakeDataWatcher();
            Packets.initGuardianWatcher(this.fakeGuardianDataWatcher, this.targetID);
            this.metadataPacketGuardian = Packets.createPacketMetadata(this.guardianID, this.fakeGuardianDataWatcher);
            for (Player p : this.show) {
                Packets.sendPackets(p, this.metadataPacketGuardian);
            }
        }

        @Override
        public Location getEnd() {
            return this.endEntity == null ? this.end : this.endEntity.getLocation();
        }

        protected Location getCorrectStart() {
            if (this.correctStart == null) {
                this.correctStart = this.start.clone();
                this.correctStart.subtract(0.0, 0.5, 0.0);
            }
            return this.correctStart;
        }

        protected Location getCorrectEnd() {
            if (this.correctEnd == null) {
                this.correctEnd = this.end.clone();
                this.correctEnd.subtract(0.0, 0.5, 0.0);
                Vector corrective = this.correctEnd.toVector().subtract(this.getCorrectStart().toVector()).normalize();
                if (Double.isNaN(corrective.getX())) {
                    corrective.setX(0);
                }
                if (Double.isNaN(corrective.getY())) {
                    corrective.setY(0);
                }
                if (Double.isNaN(corrective.getZ())) {
                    corrective.setZ(0);
                }
                this.correctEnd.subtract(corrective);
            }
            return this.correctEnd;
        }

        @Override
        protected boolean isCloseEnough(Player player) {
            return player == this.endEntity || super.isCloseEnough(player);
        }

        @Override
        protected void sendStartPackets(Player p, boolean hasSeen) throws ReflectiveOperationException {
            if (this.squid == null) {
                Packets.sendPackets(p, this.getGuardianSpawnPacket(), this.metadataPacketGuardian);
            } else {
                Packets.sendPackets(p, this.getGuardianSpawnPacket(), this.getSquidSpawnPacket(), this.metadataPacketGuardian, this.metadataPacketSquid);
            }
            if (!hasSeen) {
                Packets.sendPackets(p, this.teamCreatePacket);
            }
        }

        @Override
        protected void sendDestroyPackets(Player p) throws ReflectiveOperationException {
            Packets.sendPackets(p, this.destroyPackets);
        }

        @Override
        public void moveStart(Location location) throws ReflectiveOperationException {
            this.start = location.clone();
            this.correctStart = null;
            this.createGuardianPacket = null;
            this.moveFakeEntity(this.getCorrectStart(), this.guardianID, this.guardian);
            if (this.squid != null) {
                this.correctEnd = null;
                this.createSquidPacket = null;
                this.moveFakeEntity(this.getCorrectEnd(), this.squidID, this.squid);
            }
        }

        @Override
        public void moveEnd(Location location) throws ReflectiveOperationException {
            this.end = location.clone();
            this.createSquidPacket = null;
            this.correctEnd = null;
            if (this.squid == null) {
                this.initSquid();
                for (Player p : this.show) {
                    Packets.sendPackets(p, this.getSquidSpawnPacket(), this.metadataPacketSquid);
                }
            } else {
                this.moveFakeEntity(this.getCorrectEnd(), this.squidID, this.squid);
            }
            if (this.targetUUID != this.squidUUID) {
                this.endEntity = null;
                this.setTargetEntity(this.squidUUID, this.squidID);
            }
        }

        public void callColorChange() throws ReflectiveOperationException {
            for (Player p : this.show) {
                Packets.sendPackets(p, this.metadataPacketGuardian);
            }
        }
    }
}

