/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.config.ConfigManager;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.file.FileConfiguration;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.ChromaProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.logging.ConsoleColor;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillString;
import java.io.File;
import java.util.HashSet;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Display;

public class ConfigExecutor
extends ReloadableModule<MythicBukkit>
implements ConfigManager,
PropertyHolder {
    private static final DoubleProp VERSION = Property.Double(Scope.CONFIG, "Version");
    private static final BooleanProp GENERAL_ALLOW_METRICS = Property.Boolean(Scope.CONFIG, "General.AllowMetrics", true);
    private static final BooleanProp GENERAL_CHECK_UPDATES = Property.Boolean(Scope.CONFIG, "General.CheckForUpdates", true);
    private static final BooleanProp GENERAL_COMPATIB_MODE = Property.Boolean(Scope.CONFIG, "General.CompatibilityMode", false);
    private static final BooleanProp GENERAL_ERROR_LOGGING = Property.Boolean(Scope.CONFIG, "General.ErrorLogging", true);
    private static final BooleanProp CANCEL_DAMAGE_IF_0 = Property.Boolean(Scope.CONFIG, "General.CancelDamageIfZero", false);
    private static final BooleanProp GENERAL_LOAD_EXAMPLES = Property.Boolean(Scope.CONFIG, "General.LoadExampleConfigs", true);
    private static final StringProp GENERAL_LANGUAGE = Property.String(Scope.CONFIG, "General.Language", "enUS");
    private static final IntProp DEBUG_LEVEL = Property.Int(Scope.CONFIG, "General.DebugLevel", 0);
    private static final BooleanProp DEBUG_MODE = Property.Boolean(Scope.CONFIG, "General.DebugMode", false);
    private static final BooleanProp DEBUG_SPAWNERS = Property.Boolean(Scope.CONFIG, "General.DebugSpawners", false);
    private static final IntProp CLOCK_SPEED = Property.Int(Scope.CONFIG, "Clock.Main", 1);
    private static final IntProp CLOCK_RANDOM_SPAWNING = Property.Int(Scope.CONFIG, "Clock.RandomSpawning", 1);
    private static final IntProp CLOCK_SAVING = Property.Int(Scope.CONFIG, "Clock.Saving", 300);
    private static final StringProp MOBS_KILL_MESSAGE_PREFIX = Property.String(Scope.CONFIG, "Mobs.KillMessagePrefix", null);
    private static final ChromaProp HOLOGRAM_CASTBAR_INFO_BACKGROUND = Property.Chroma(Scope.CONFIG, "Holograms.CastBar.InfoBackground", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_CASTBAR_INFO_BILLBOARDING = Property.String(Scope.CONFIG, "Holograms.CastBar.InfoBillboarding", "VERTICAL");
    private static final ChromaProp HOLOGRAM_CASTBAR_CAST_BACKGROUND = Property.Chroma(Scope.CONFIG, "Holograms.CastBar.CastBackground", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_CASTBAR_CAST_BILLBOARDING = Property.String(Scope.CONFIG, "Holograms.CastBar.CastBillboarding", "VERTICAL");
    private static final ChromaProp HOLOGRAM_HEALTHBAR_BACKGROUND = Property.Chroma(Scope.CONFIG, "Holograms.HealthBar.Background", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_HEALTHBAR_BILLBOARDING = Property.String(Scope.CONFIG, "Holograms.HealthBar.Billboarding", "VERTICAL");
    private static final ChromaProp HOLOGRAM_NAMEPLATE_BACKGROUND = Property.Chroma(Scope.CONFIG, "Holograms.Nameplate.Background", Chroma.of(0, 0, 0, 60));
    private static final StringProp HOLOGRAM_NAMEPLATE_BILLBOARDING = Property.String(Scope.CONFIG, "Holograms.Nameplate.Billboarding", "VERTICAL");
    private static final ChromaProp HOLOGRAM_SPEECH_BACKGROUND = Property.Chroma(Scope.CONFIG, "Holograms.Speech.Background", Chroma.of(0, 0, 0, 0));
    private static final StringProp HOLOGRAM_SPEECH_BILLBOARDING = Property.String(Scope.CONFIG, "Holograms.Speech.Billboarding", "VERTICAL");
    private static final StringProp ITEM_DEFAULT_PREVENTENCHANTING = Property.String(Scope.ITEMS, "DefaultItemOptions.PreventEnchanting", "false");
    private static final StringProp ITEM_DEFAULT_PREVENTCRAFTING = Property.String(Scope.ITEMS, "DefaultItemOptions.PreventCrafting", "modeled");
    private static final StringProp ITEM_DEFAULT_PREVENTANVILING = Property.String(Scope.ITEMS, "DefaultItemOptions.PreventAnviling", "default");
    private static final StringProp ITEM_DEFAULT_PREVENTSMITHING = Property.String(Scope.ITEMS, "DefaultItemOptions.PreventSmithing", "default");
    private IOLoader<MythicBukkit> settings;
    private MythicConfig config;
    private Boolean allowMetrics = true;
    private Boolean allowUpdateChecking = true;
    private Boolean useCompatibilityMode = false;
    private Boolean loadExampleConfigs = true;
    private Boolean fireAPIDeathEvent = true;
    private Boolean fireAPISkillEvent = true;
    private Boolean fireAPICustomSkillEvent = true;
    private int debugLevel = -1;
    private boolean debugMode = false;
    private boolean debugSpawners = false;
    private Boolean doErrorLogging = true;
    private boolean cancelDamageIfZero = false;
    private int clockIntervalMain = 1;
    private int clockIntervalRandomSpawning = 1;
    private int clockIntervalSaving = 300;
    public static int SpawningInterval = 1;
    public static int timerupdate;
    public static int walkupdate;
    public static int ShowHealthRadius;
    public static int ScanInterval;
    public static int ClnrInterval;
    private static int bossBarUpdateInterval;
    public static boolean EnableAIModifiers;
    public static boolean EnableThreatTables;
    public static String ShowHealthFormat;
    private String killMessagePrefix = "";
    private Boolean mobsDespawnByDefault = false;
    private Boolean preventOtherDropsByDefault = false;
    public static String defaultLevelModifierHealth;
    public static String defaultLevelModifierDamage;
    public static String defaultLevelModifierPower;
    public static String defaultLevelModifierArmor;
    public static String defaultLevelModifierKBR;
    private Expression scalingEquationDamage = null;
    private Expression scalingEquationHealth = null;
    private float globalMountedHologramOffset = 0.0f;
    private Color hologramCastingBarBackgroundColor;
    private Display.Billboard hologramCastingBarBillboarding;
    private Color hologramCastingInfoBackgroundColor;
    private Display.Billboard hologramCastingInfoBillboarding;
    private Color hologramHealthBarBackgroundColor;
    private Display.Billboard hologramHealthBarBillboarding;
    private Color hologramNameplateBackgroundColor;
    private Display.Billboard hologramNameplateBillboarding;
    private Color hologramSpeechBackgroundColor;
    private Display.Billboard hologramSpeechBillboarding;
    public static boolean EnableTimerSkills;
    private Boolean skillsIgnoreArmorStandsByDefault = true;
    public static boolean targetSelf;
    public static boolean targetPlayers;
    public static boolean targetArmorStands;
    public static boolean targetMarkers;
    public static boolean targetCreativeMode;
    public static boolean targetSpectatorMode;
    public static boolean targetCitizensNPCs;
    public static boolean targetAnimals;
    public static boolean targetCreatures;
    public static boolean targetMonsters;
    public static boolean targetWaterMobs;
    public static boolean targetFlyingMobs;
    public static boolean targetSameFaction;
    public static boolean targetOwner;
    public static boolean targetNonMythic;
    public static boolean targetVillagers;
    public static int SpawnerRange;
    private static boolean rsGeneratePoints;
    private static int rsMaxMobsPerChunk;
    private int randomSpawningPlayerRadiusMax = 64;
    private int randomSpawningPlayerRadiusMin = 16;
    private int randomSpawningPlayerRadiusY = 16;
    private static int rsPointsPerSecondLand;
    private static int rsPointsPerSecondAir;
    private static int rsPointsPerSecondSea;
    private static int rsPointsPerSecondLava;
    private static int rsPointsPerSecondGround;
    private static int rsMaxGenerationTimeMillis;
    private static boolean rsDespawnVanillaOutsideRadius;
    private static boolean vanillaSpawnsDisabled;
    public static boolean updateItems;
    public static boolean compatHeroesXPEnable;
    public static boolean compatHeroesShowXPMessage;
    public static String compatHeroesXPMessageFormat;
    public static boolean compatSkillAPIShowXPMessage;
    public static String compatSkillAPIXPMessageFormat;
    public static boolean compatVaultShowMoneyMessage;
    public static String compatVaultMoneyMessageFormat;
    public static boolean compatMcMMOShowXPMessage;
    public static String compatMcMMOXPMessageFormat;
    private static HashSet<Material> transparentBlocks;

    public ConfigExecutor(MythicBukkit core) {
        super(core, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.settings = new IOLoader<MythicBukkit>(plugin, "config.yml");
        this.loadSettings();
        plugin.getClock().setReloadingPause(true);
        try {
            plugin.reloadConfiguration();
            plugin.getPackManager().loadPacks();
            plugin.getPlaceholderManager().load(plugin);
            plugin.getPinManager().load(plugin);
            plugin.getItemManager().load(plugin);
            plugin.getSkillManager().loadSkills();
            plugin.getStatManager().load(plugin);
            plugin.getMobManager().loadMobs();
            plugin.getDropManager().loadDropTables();
            plugin.getRandomSpawningManager().loadRandomSpawns();
            plugin.getSpawnerManager().loadSpawners();
        }
        finally {
            plugin.getClock().setReloadingPause(false);
        }
        plugin.getClock().runSecondPass();
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getMobTypes().size() + " mobs.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getMobManager().getMobStacks().size() + " mob stacks.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getSkillManager().getSkills().size() + " skills.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getRandomSpawningManager().getNumberOfSpawners() + " random spawns.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getItemManager().getItems().size() + " mythic items.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getDropManager().getDropTables().size() + " drop tables.");
        MythicLogger.log(ConsoleColor.GREEN + ConsoleColor.CHECK_MARK + ConsoleColor.WHITE + " Loaded " + plugin.getSpawnerManager().getSpawners().size() + " mob spawners.");
    }

    public void save() {
        Schedulers.async().run(() -> {
            try {
                ((MythicBukkit)this.getPlugin()).getMobManager().saveCachedActiveMobs();
                ((MythicBukkit)this.getPlugin()).getPlayerManager().saveAll();
                ((MythicBukkit)this.getPlugin()).getWorldManager().saveAll();
                ((MythicBukkit)this.getPlugin()).getVariableManager().save();
                ((MythicBukkit)this.getPlugin()).getSpawnerManager().saveSpawners();
            }
            catch (Error | Exception ex) {
                MythicLogger.log(ConsoleColor.RED + ConsoleColor.ERROR_MARK + ConsoleColor.WHITE + "An error occurred while saving data");
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void unload() {
        this.save();
        ((MythicBukkit)this.plugin).getDropManager().unload();
        ((MythicBukkit)this.plugin).getItemManager().unload();
        ((MythicBukkit)this.plugin).getPinManager().unload();
        ((MythicBukkit)this.plugin).getStatManager().unload();
    }

    public void loadSettings() {
        File statsFile;
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Settings...", new Object[0]);
        File configFile = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            ((MythicBukkit)this.getPlugin()).saveResource("config.yml", false);
        }
        if (!(statsFile = new File(((MythicBukkit)this.getPlugin()).getDataFolder(), "stats.yml")).exists()) {
            ((MythicBukkit)this.getPlugin()).saveResource("stats.yml", false);
        }
        MythicConfigImpl mc = new MythicConfigImpl("Configuration", this.settings.getCustomConfig());
        this.allowMetrics = (Boolean)GENERAL_ALLOW_METRICS.get(this);
        this.allowUpdateChecking = (Boolean)GENERAL_CHECK_UPDATES.get(this);
        this.useCompatibilityMode = (Boolean)GENERAL_COMPATIB_MODE.get(this);
        this.doErrorLogging = (Boolean)GENERAL_ERROR_LOGGING.get(this);
        this.cancelDamageIfZero = (Boolean)CANCEL_DAMAGE_IF_0.get(this);
        this.debugLevel = (Integer)DEBUG_LEVEL.get(this);
        this.clockIntervalMain = (Integer)CLOCK_SPEED.get(this);
        this.clockIntervalRandomSpawning = (Integer)CLOCK_RANDOM_SPAWNING.get(this);
        this.clockIntervalSaving = (Integer)CLOCK_SAVING.get(this);
        SpawningInterval = mc.getInteger("Clock.SpawnsInterval", 2);
        ScanInterval = mc.getInteger("Clock.ScannerInterval", 10);
        ClnrInterval = mc.getInteger("Clock.CleanupInterval", 600);
        targetSelf = mc.getBoolean("Targeters.Filters.Default.TargetSelf", false);
        targetPlayers = mc.getBoolean("Targeters.Filters.Default.TargetPlayers", true);
        targetArmorStands = mc.getBoolean("Targeters.Filters.Default.TargetArmorStands", false);
        targetMarkers = mc.getBoolean("Targeters.Filters.Default.TargetMarkers", false);
        targetCreativeMode = mc.getBoolean("Targeters.Filters.Default.TargetCreativeMode", true);
        targetSpectatorMode = mc.getBoolean("Targeters.Filters.Default.TargetSpectatorMode", true);
        targetCitizensNPCs = mc.getBoolean("Targeters.Filters.Default.TargetCitizensNPCs", false);
        targetAnimals = mc.getBoolean("Targeters.Filters.Default.TargetAnimals", true);
        targetCreatures = mc.getBoolean("Targeters.Filters.Default.TargetCreatures", true);
        targetMonsters = mc.getBoolean("Targeters.Filters.Default.TargetMonsters", true);
        targetWaterMobs = mc.getBoolean("Targeters.Filters.Default.TargetWaterMobs", true);
        targetFlyingMobs = mc.getBoolean("Targeters.Filters.Default.TargetFlyingMobs", true);
        targetSameFaction = mc.getBoolean("Targeters.Filters.Default.TargetSameFaction", true);
        targetOwner = mc.getBoolean("Targeters.Filters.Default.TargetOwner", true);
        targetNonMythic = mc.getBoolean("Targeters.Filters.Default.TargetNonMythic", true);
        targetVillagers = mc.getBoolean("Targeters.Filters.Default.TargetVillagers", true);
        this.mobsDespawnByDefault = mc.getBoolean("Mobs.DespawnByDefault", true);
        this.preventOtherDropsByDefault = mc.getBoolean("Mobs.PreventOtherDropsByDefault", false);
        EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        ShowHealthRadius = mc.getInteger("Mobs.ShowHealth.Radius", 25);
        ShowHealthFormat = mc.getString("Mobs.ShowHealth.Format", ShowHealthFormat);
        this.killMessagePrefix = (String)MOBS_KILL_MESSAGE_PREFIX.get(this);
        this.killMessagePrefix = this.killMessagePrefix == null || this.killMessagePrefix.isEmpty() ? null : SkillString.parseMessageSpecialChars(this.killMessagePrefix);
        int barUpdateInterval = mc.getInteger("Mobs.BossBar.UpdateInterval", 20);
        int n = bossBarUpdateInterval = barUpdateInterval <= 0 ? 20 : barUpdateInterval;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            this.hologramCastingBarBackgroundColor = ((Chroma)HOLOGRAM_CASTBAR_CAST_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramCastingBarBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_CASTBAR_CAST_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.CastBar.CastBillboard");
            }
            this.hologramCastingInfoBackgroundColor = ((Chroma)HOLOGRAM_CASTBAR_INFO_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramCastingInfoBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_CASTBAR_INFO_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.CastBar.InfoBillboard");
            }
            this.hologramHealthBarBackgroundColor = ((Chroma)HOLOGRAM_HEALTHBAR_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramHealthBarBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_HEALTHBAR_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.HealthBar.Billboard");
            }
            this.hologramNameplateBackgroundColor = ((Chroma)HOLOGRAM_NAMEPLATE_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramNameplateBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_NAMEPLATE_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.Nameplate.Billboard");
            }
            this.hologramSpeechBackgroundColor = ((Chroma)HOLOGRAM_SPEECH_BACKGROUND.get(this)).toBukkitColor();
            try {
                this.hologramSpeechBillboarding = Display.Billboard.valueOf((String)((String)HOLOGRAM_SPEECH_BILLBOARDING.get(this)).toUpperCase());
            }
            catch (Throwable ex) {
                MythicLogger.errorGenericConfig("Invalid Billboarding Option for Holograms.Speech.Billboard");
            }
        }
        rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        rsMaxMobsPerChunk = mc.getInteger("RandomSpawning.MaxMobsPerChunk", 2);
        this.randomSpawningPlayerRadiusMax = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayer", 64);
        this.randomSpawningPlayerRadiusMin = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerMin", 16);
        this.randomSpawningPlayerRadiusY = mc.getInteger("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        rsPointsPerSecondLand = mc.getInteger("RandomSpawning.PointsPerSecond.Land", 10);
        rsPointsPerSecondAir = mc.getInteger("RandomSpawning.PointsPerSecond.Air", 1);
        rsPointsPerSecondSea = mc.getInteger("RandomSpawning.PointsPerSecond.Sea", 1);
        rsPointsPerSecondLava = mc.getInteger("RandomSpawning.PointsPerSecond.Lava", 0);
        rsPointsPerSecondGround = mc.getInteger("RandomSpawning.PointsPerSecond.Ground", 0);
        rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        rsMaxGenerationTimeMillis = mc.getInteger("RandomSpawning.MaxGenerationTime", 20);
        vanillaSpawnsDisabled = mc.getBoolean("RandomSpawning.DisableVanillaSpawns", false);
        compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", compatHeroesXPEnable);
        compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", compatHeroesShowXPMessage);
        compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", compatHeroesXPMessageFormat);
        compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", compatMcMMOShowXPMessage);
        compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", compatMcMMOXPMessageFormat);
        compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", compatSkillAPIShowXPMessage);
        compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", compatSkillAPIXPMessageFormat);
        compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", compatVaultShowMoneyMessage);
        compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", compatVaultMoneyMessageFormat);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        updateItems = mc.getBoolean("ItemUpdating.Enabled", true);
        this.loadExampleConfigs = mc.getBoolean("LoadExampleConfigs", true);
        if (MythicBukkit.isVolatile()) {
            String strScalingEquationHealth;
            String strScalingEquationDamage = mc.getString("Mobs.ScalingEquations.Damage", null);
            if (strScalingEquationDamage != null && !strScalingEquationDamage.equalsIgnoreCase("NONE")) {
                strScalingEquationDamage = strScalingEquationDamage.toLowerCase();
                this.scalingEquationDamage = new ExpressionBuilder(strScalingEquationDamage).variables("l", "v").build();
            }
            if ((strScalingEquationHealth = mc.getString("Mobs.ScalingEquations.Health", null)) != null && !strScalingEquationHealth.equalsIgnoreCase("NONE")) {
                strScalingEquationHealth = strScalingEquationHealth.toLowerCase();
                this.scalingEquationHealth = new ExpressionBuilder(strScalingEquationHealth).variables("l", "v").build();
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading WorldScaling Settings...", new Object[0]);
        WorldScaling.reset();
        if (this.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : this.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "*** Loading WorldScaling for world " + world, new Object[0]);
                MythicConfigImpl wmc = new MythicConfigImpl("Configuration.Mobs.Scaling." + world, this.settings.getCustomConfig());
                WorldScaling.initialize(world, wmc);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Loading Default Level Modifiers...", new Object[0]);
        defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Health: " + defaultLevelModifierHealth, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Damage: " + defaultLevelModifierDamage, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Power: " + defaultLevelModifierPower, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - Armor: " + defaultLevelModifierArmor, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "**** Default Level Modifiers - KBR: " + defaultLevelModifierKBR, new Object[0]);
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "** Finished Load Default Level Modifiers!", new Object[0]);
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public static boolean generateRSPoints() {
        return rsGeneratePoints;
    }

    public static int getRSMaxMobsPerChunk() {
        return rsMaxMobsPerChunk;
    }

    public static int getRSPointsPerSecondLand() {
        return rsPointsPerSecondLand;
    }

    public static int getRSPointsPerSecondAir() {
        return rsPointsPerSecondAir;
    }

    public static int getRSPointsPerSecondSea() {
        return rsPointsPerSecondSea;
    }

    public static int getRSPointsPerSecondLava() {
        return rsPointsPerSecondLava;
    }

    public static int getRSPointsPerSecondGround() {
        return rsPointsPerSecondGround;
    }

    public static int getRSMaxGenerationTimeMillis() {
        return rsMaxGenerationTimeMillis;
    }

    public static boolean getRSDespawnVanillaOutsideRadius() {
        return rsDespawnVanillaOutsideRadius;
    }

    public boolean getDespawnMobsByDefault() {
        return this.mobsDespawnByDefault;
    }

    public boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public HashSet<Material> getTransparentBlocks() {
        return transparentBlocks;
    }

    public boolean shouldUpdateItems() {
        return updateItems;
    }

    @Override
    public MythicConfig createConfig(FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, fileConfiguration);
    }

    @Override
    public MythicConfig createConfig(String node, File file) {
        return new MythicConfigImpl(node, file);
    }

    @Override
    public MythicConfig createConfig(String node, File file, FileConfiguration fileConfiguration) {
        return new MythicConfigImpl(node, file, fileConfiguration);
    }

    @Override
    public MythicLineConfig createLineConfig(File file, String line) {
        return new MythicLineConfigImpl(file, line);
    }

    @Override
    public MythicLineConfig createLineConfig(String line) {
        return new MythicLineConfigImpl(line);
    }

    @Override
    public String getPropertyNode() {
        return "Configuration";
    }

    public Boolean getAllowMetrics() {
        return this.allowMetrics;
    }

    public Boolean getAllowUpdateChecking() {
        return this.allowUpdateChecking;
    }

    public Boolean getUseCompatibilityMode() {
        return this.useCompatibilityMode;
    }

    public Boolean getLoadExampleConfigs() {
        return this.loadExampleConfigs;
    }

    public Boolean getFireAPIDeathEvent() {
        return this.fireAPIDeathEvent;
    }

    public Boolean getFireAPISkillEvent() {
        return this.fireAPISkillEvent;
    }

    public Boolean getFireAPICustomSkillEvent() {
        return this.fireAPICustomSkillEvent;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isDebugSpawners() {
        return this.debugSpawners;
    }

    public Boolean getDoErrorLogging() {
        return this.doErrorLogging;
    }

    public boolean isCancelDamageIfZero() {
        return this.cancelDamageIfZero;
    }

    public int getClockIntervalMain() {
        return this.clockIntervalMain;
    }

    public int getClockIntervalRandomSpawning() {
        return this.clockIntervalRandomSpawning;
    }

    public int getClockIntervalSaving() {
        return this.clockIntervalSaving;
    }

    public static int getBossBarUpdateInterval() {
        return bossBarUpdateInterval;
    }

    public String getKillMessagePrefix() {
        return this.killMessagePrefix;
    }

    public Boolean getMobsDespawnByDefault() {
        return this.mobsDespawnByDefault;
    }

    public Expression getScalingEquationDamage() {
        return this.scalingEquationDamage;
    }

    public Expression getScalingEquationHealth() {
        return this.scalingEquationHealth;
    }

    public Color getHologramCastingBarBackgroundColor() {
        return this.hologramCastingBarBackgroundColor;
    }

    public Display.Billboard getHologramCastingBarBillboarding() {
        return this.hologramCastingBarBillboarding;
    }

    public Color getHologramCastingInfoBackgroundColor() {
        return this.hologramCastingInfoBackgroundColor;
    }

    public Display.Billboard getHologramCastingInfoBillboarding() {
        return this.hologramCastingInfoBillboarding;
    }

    public Color getHologramHealthBarBackgroundColor() {
        return this.hologramHealthBarBackgroundColor;
    }

    public Display.Billboard getHologramHealthBarBillboarding() {
        return this.hologramHealthBarBillboarding;
    }

    public Color getHologramNameplateBackgroundColor() {
        return this.hologramNameplateBackgroundColor;
    }

    public Display.Billboard getHologramNameplateBillboarding() {
        return this.hologramNameplateBillboarding;
    }

    public Color getHologramSpeechBackgroundColor() {
        return this.hologramSpeechBackgroundColor;
    }

    public Display.Billboard getHologramSpeechBillboarding() {
        return this.hologramSpeechBillboarding;
    }

    public Boolean getSkillsIgnoreArmorStandsByDefault() {
        return this.skillsIgnoreArmorStandsByDefault;
    }

    public static boolean isTargetSelf() {
        return targetSelf;
    }

    public static boolean isTargetPlayers() {
        return targetPlayers;
    }

    public static boolean isTargetArmorStands() {
        return targetArmorStands;
    }

    public static boolean isTargetMarkers() {
        return targetMarkers;
    }

    public static boolean isTargetCreativeMode() {
        return targetCreativeMode;
    }

    public static boolean isTargetSpectatorMode() {
        return targetSpectatorMode;
    }

    public static boolean isTargetCitizensNPCs() {
        return targetCitizensNPCs;
    }

    public static boolean isTargetAnimals() {
        return targetAnimals;
    }

    public static boolean isTargetCreatures() {
        return targetCreatures;
    }

    public static boolean isTargetMonsters() {
        return targetMonsters;
    }

    public static boolean isTargetWaterMobs() {
        return targetWaterMobs;
    }

    public static boolean isTargetFlyingMobs() {
        return targetFlyingMobs;
    }

    public static boolean isTargetSameFaction() {
        return targetSameFaction;
    }

    public static boolean isTargetOwner() {
        return targetOwner;
    }

    public static boolean isTargetNonMythic() {
        return targetNonMythic;
    }

    public static boolean isTargetVillagers() {
        return targetVillagers;
    }

    public int getRandomSpawningPlayerRadiusMax() {
        return this.randomSpawningPlayerRadiusMax;
    }

    public int getRandomSpawningPlayerRadiusMin() {
        return this.randomSpawningPlayerRadiusMin;
    }

    public int getRandomSpawningPlayerRadiusY() {
        return this.randomSpawningPlayerRadiusY;
    }

    public static boolean isVanillaSpawnsDisabled() {
        return vanillaSpawnsDisabled;
    }

    static {
        ShowHealthRadius = 25;
        ScanInterval = 10;
        ClnrInterval = 600;
        bossBarUpdateInterval = 20;
        EnableAIModifiers = true;
        EnableThreatTables = true;
        ShowHealthFormat = "$mobname: $mobhp / $mobmaxhp";
        EnableTimerSkills = true;
        targetSelf = false;
        targetPlayers = true;
        targetArmorStands = false;
        targetMarkers = false;
        targetCreativeMode = true;
        targetSpectatorMode = true;
        targetCitizensNPCs = false;
        targetAnimals = true;
        targetCreatures = true;
        targetMonsters = true;
        targetWaterMobs = true;
        targetFlyingMobs = true;
        targetSameFaction = true;
        targetOwner = true;
        targetNonMythic = true;
        targetVillagers = true;
        SpawnerRange = 40;
        rsGeneratePoints = false;
        rsMaxMobsPerChunk = 20;
        rsPointsPerSecondLand = 10;
        rsPointsPerSecondAir = 0;
        rsPointsPerSecondSea = 1;
        rsPointsPerSecondLava = 0;
        rsPointsPerSecondGround = 0;
        rsMaxGenerationTimeMillis = 20;
        rsDespawnVanillaOutsideRadius = false;
        vanillaSpawnsDisabled = false;
        updateItems = true;
        compatHeroesXPEnable = false;
        compatHeroesShowXPMessage = true;
        compatHeroesXPMessageFormat = "";
        compatSkillAPIShowXPMessage = true;
        compatSkillAPIXPMessageFormat = "";
        compatVaultShowMoneyMessage = true;
        compatVaultMoneyMessageFormat = "";
        compatMcMMOShowXPMessage = true;
        compatMcMMOXPMessageFormat = "";
        transparentBlocks = new HashSet();
        for (Material m4 : Material.values()) {
            if (!m4.isTransparent() && m4.isSolid() && m4.isOccluding()) continue;
            transparentBlocks.add(m4);
        }
    }
}

