/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropManager;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.InvalidDrop;
import io.lumine.mythic.core.drops.droppables.CommandDrop;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.DropTableDrop;
import io.lumine.mythic.core.drops.droppables.ExperienceDrop;
import io.lumine.mythic.core.drops.droppables.HeroesExperienceDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.drops.droppables.McMMODrop;
import io.lumine.mythic.core.drops.droppables.MythicDropsDrop;
import io.lumine.mythic.core.drops.droppables.MythicItemDrop;
import io.lumine.mythic.core.drops.droppables.MythicMobDrop;
import io.lumine.mythic.core.drops.droppables.NothingDrop;
import io.lumine.mythic.core.drops.droppables.PhatLootsDrop;
import io.lumine.mythic.core.drops.droppables.SkillAPIDrop;
import io.lumine.mythic.core.drops.droppables.VaultDrop;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;

public class DropExecutor
extends ReloadableModule<MythicBukkit>
implements DropManager {
    private ConcurrentHashMap<String, DropTable> dropTables = new ConcurrentHashMap();

    public DropExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.loadDropTables();
    }

    public void loadDropTables() {
        MythicLogger.log("Loading Drop Tables...");
        IOLoader<MythicBukkit> defaultDroptables = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleDropTables.yml", "DropTables");
        List<File> droptableFiles = IOHandler.getAllFiles(defaultDroptables.getFile().getParent());
        File packsFolder = new File(((MythicBukkit)this.plugin).getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "DropTables")).exists() || !confFolder.isDirectory()) continue;
                droptableFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        List<IOLoader<MythicBukkit>> droptableLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), droptableFiles, "DropTables");
        this.dropTables.clear();
        for (IOLoader<MythicBukkit> sl : droptableLoaders) {
            for (String s2 : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                if (sl.getCustomConfig().getStringList(s2 + ".Drops") == null) continue;
                String file = sl.getFile().getName();
                MythicConfigImpl mc = new MythicConfigImpl(s2, sl.getCustomConfig());
                DropTable dt = new DropTable(this, file, s2, mc);
                this.dropTables.put(s2, dt);
            }
        }
        ((MythicBukkit)this.plugin).getClock().runSecondPass();
    }

    @Override
    public void unload() {
        this.dropTables.clear();
    }

    public void queueAfterLoad(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueAfterLoad(r);
    }

    public void queueSecondPass(Runnable r) {
        ((MythicBukkit)this.plugin).getClock().queueSecondPass(r);
    }

    @Override
    public Optional<DropTable> getDropTable(String name) {
        return Optional.ofNullable(this.dropTables.getOrDefault(name, null));
    }

    @Override
    public Collection<DropTable> getDropTables() {
        return this.dropTables.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Drop getDrop(String fileName, String drop) {
        if (drop.contains("}")) {
            sp1 = drop.substring(0, drop.indexOf("}"));
            sp2 = drop.substring(drop.indexOf("}"));
            ns = sp1.replace(" ", "") + sp2;
            drop = ns;
        }
        s = drop.split(" ");
        name = null;
        mlc = new MythicLineConfigImpl(fileName, s[0]);
        name = s[0].contains("{") != false ? s[0].substring(0, s[0].indexOf("{")) : s[0];
        oName = name.toUpperCase();
        oData = 0;
        if (name.contains(":")) {
            oName = name.split(":")[0].toUpperCase();
            try {
                oData = Byte.valueOf(name.split(":")[1]);
            }
            catch (Exception var8_8) {
                // empty catch block
            }
            name = name.split(":")[0];
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            material = null;
            try {
                v0 /* !! */  = material = oData == 0 ? Material.valueOf((String)oName) : LegacyItemConverter.getMaterial(oName, oData);
                if (material != null || oData <= 0) ** GOTO lbl51
                material = Material.valueOf((String)oName);
            }
            catch (Exception ex) {
                material = LegacyItemConverter.getMaterial(oName, oData);
                if (material != null || oData <= 0) ** GOTO lbl51
                try {
                    material = Material.valueOf((String)oName);
                }
                catch (Exception var10_15) {
                    // empty catch block
                }
            }
            finally {
                if (material != null && material != Material.AIR) {
                    name = material.toString();
                }
            }
        } else {
            material = Material.AIR;
            if (name.matches("[0-9]*")) {
                material = LegacyItemConverter.getMaterial(oName, (byte)0);
            } else {
                try {
                    material = Material.valueOf((String)oName);
                }
                catch (Exception var9_12) {
                    // empty catch block
                }
            }
            if (material != null && material != Material.AIR) {
                name = material.toString();
            }
        }
lbl51:
        // 8 sources

        try {
            if (Material.matchMaterial((String)name) != null) {
                return new ItemDrop((String)drop, (MythicLineConfig)mlc, name);
            }
            if (MythicBukkit.inst().getDropManager().getDropTable(name).isPresent()) {
                return new DropTableDrop((String)drop, name, mlc);
            }
            if (MythicBukkit.inst().getItemManager().getItem(name).isPresent()) {
                return new MythicItemDrop((String)drop, name, mlc);
            }
            material = name.toUpperCase();
            var9_14 = -1;
            switch (material.hashCode()) {
                case -1447660627: {
                    if (!material.equals("NOTHING")) break;
                    var9_14 = 0;
                    break;
                }
                case 2402104: {
                    if (!material.equals("NONE")) break;
                    var9_14 = 1;
                    break;
                }
                case 2407815: {
                    if (!material.equals("NULL")) break;
                    var9_14 = 2;
                    break;
                }
                case 1668377387: {
                    if (!material.equals("COMMAND")) break;
                    var9_14 = 3;
                    break;
                }
                case 66842: {
                    if (!material.equals("CMD")) break;
                    var9_14 = 4;
                    break;
                }
                case 399525226: {
                    if (!material.equals("EXPERIENCE")) break;
                    var9_14 = 5;
                    break;
                }
                case 69117: {
                    if (!material.equals("EXP")) break;
                    var9_14 = 6;
                    break;
                }
                case 2808: {
                    if (!material.equals("XP")) break;
                    var9_14 = 7;
                    break;
                }
                case -1872056730: {
                    if (!material.equals("MYTHICMOB")) break;
                    var9_14 = 8;
                    break;
                }
                case 2095783597: {
                    if (!material.equals("MYTHICMOBS")) break;
                    var9_14 = 9;
                    break;
                }
                case 2464: {
                    if (!material.equals("MM")) break;
                    var9_14 = 10;
                    break;
                }
                case 81443346: {
                    if (!material.equals("VAULT")) break;
                    var9_14 = 11;
                    break;
                }
                case 73541792: {
                    if (!material.equals("MONEY")) break;
                    var9_14 = 12;
                    break;
                }
                case 1358028817: {
                    if (!material.equals("CURRENCY")) break;
                    var9_14 = 13;
                    break;
                }
                case 795951829: {
                    if (!material.equals("HEROESEXP")) break;
                    var9_14 = 14;
                    break;
                }
                case -1096029992: {
                    if (!material.equals("HEROES-EXP")) break;
                    var9_14 = 15;
                    break;
                }
                case -1631374844: {
                    if (!material.equals("MCMMOEXP")) break;
                    var9_14 = 16;
                    break;
                }
                case 966254473: {
                    if (!material.equals("MCMMO-EXP")) break;
                    var9_14 = 17;
                    break;
                }
                case 2095518761: {
                    if (!material.equals("MYTHICDROP")) break;
                    var9_14 = 18;
                    break;
                }
                case 2455: {
                    if (!material.equals("MD")) break;
                    var9_14 = 19;
                    break;
                }
                case -892525229: {
                    if (!material.equals("PHATLOOT")) break;
                    var9_14 = 20;
                    break;
                }
                case -1898478240: {
                    if (!material.equals("PHATLOOTS")) break;
                    var9_14 = 21;
                    break;
                }
                case 2556: {
                    if (!material.equals("PL")) break;
                    var9_14 = 22;
                    break;
                }
                case 500514612: {
                    if (!material.equals("SKILLAPIEXP")) break;
                    var9_14 = 23;
                    break;
                }
                case -1664649127: {
                    if (!material.equals("SKILLAPI-EXP")) break;
                    var9_14 = 24;
                }
            }
            switch (var9_14) {
                case 0: 
                case 1: 
                case 2: {
                    return new NothingDrop((String)drop, mlc);
                }
                case 3: 
                case 4: {
                    return new CommandDrop((String)drop, mlc);
                }
                case 5: 
                case 6: 
                case 7: {
                    return new ExperienceDrop((String)drop, mlc);
                }
                case 8: 
                case 9: 
                case 10: {
                    return new MythicMobDrop((String)drop, mlc);
                }
                case 11: 
                case 12: 
                case 13: {
                    return new VaultDrop((String)drop, mlc);
                }
                case 14: 
                case 15: {
                    return new HeroesExperienceDrop((String)drop, mlc);
                }
                case 16: 
                case 17: {
                    return new McMMODrop((String)drop, mlc);
                }
                case 18: 
                case 19: {
                    return new MythicDropsDrop((String)drop, mlc);
                }
                case 20: 
                case 21: 
                case 22: {
                    return new PhatLootsDrop((String)drop, mlc);
                }
                case 23: 
                case 24: {
                    return new SkillAPIDrop((String)drop, mlc);
                }
            }
            return new CustomDrop(name, (String)drop, mlc);
        }
        catch (Exception ex) {
            return new InvalidDrop((String)drop, mlc);
        }
    }

    public static void Drop(Location loc, int exp, List<ItemStack> drops) {
        for (ItemStack is : drops) {
            loc.getWorld().dropItemNaturally(loc, is);
        }
        if (exp != 0) {
            int i = exp % 4;
            int per = (exp - exp % 4) / 4;
            for (int y = 0; y < 4; ++y) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(per);
            }
            if (i != 0) {
                ExperienceOrb eo = (ExperienceOrb)loc.getWorld().spawnEntity(loc, EntityType.EXPERIENCE_ORB);
                eo.setExperience(i);
            }
        }
    }
}

